/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.parser.docelement;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import znaishaded.org.testingisdocumenting.znai.utils.CollectionUtils;

public class DocElement {
    private Map<String, Object> props;
    private List<DocElement> content;
    private String type;

    public DocElement(String type) {
        this.type = type;
        this.props = new LinkedHashMap<String, Object>();
        this.content = new ArrayList<DocElement>();
    }

    public DocElement(String type, Object ... keyValues) {
        this(type);
        Map<String, Object> props = CollectionUtils.createMap(keyValues);
        props.forEach(this::addProp);
    }

    public void addProp(String key, Object value) {
        this.props.put(key, value);
    }

    public void addChild(DocElement element) {
        this.content.add(element);
    }

    public void removeChild(DocElement element) {
        this.content.remove(element);
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public Object getProp(String name) {
        return this.props.get(name);
    }

    public Map<String, Object> getProps() {
        return this.props;
    }

    public List<DocElement> getContent() {
        return this.content;
    }

    public List<Map<String, Object>> contentToListOfMaps() {
        return this.content.stream().map(DocElement::toMap).collect(Collectors.toList());
    }

    public Map<String, Object> toMap() {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>(this.props);
        result.put("type", this.type);
        if (!this.content.isEmpty()) {
            result.put("content", this.contentToListOfMaps());
        }
        return result;
    }

    public String toString() {
        return this.toMap().toString();
    }
}

