/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.parser.docelement;

import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import znaishaded.org.testingisdocumenting.znai.codesnippets.CodeSnippetsProps;
import znaishaded.org.testingisdocumenting.znai.core.AuxiliaryFile;
import znaishaded.org.testingisdocumenting.znai.core.ComponentsRegistry;
import znaishaded.org.testingisdocumenting.znai.core.ResourcesResolver;
import znaishaded.org.testingisdocumenting.znai.extensions.Plugin;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginParams;
import znaishaded.org.testingisdocumenting.znai.extensions.PluginResult;
import znaishaded.org.testingisdocumenting.znai.extensions.Plugins;
import znaishaded.org.testingisdocumenting.znai.extensions.fence.FencePlugin;
import znaishaded.org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import znaishaded.org.testingisdocumenting.znai.extensions.inlinedcode.InlinedCodePlugin;
import znaishaded.org.testingisdocumenting.znai.parser.PageSectionIdTitle;
import znaishaded.org.testingisdocumenting.znai.parser.ParserHandler;
import znaishaded.org.testingisdocumenting.znai.parser.docelement.DocElement;
import znaishaded.org.testingisdocumenting.znai.parser.table.MarkupTableData;
import znaishaded.org.testingisdocumenting.znai.reference.DocReferences;
import znaishaded.org.testingisdocumenting.znai.structure.DocStructure;
import znaishaded.org.testingisdocumenting.znai.structure.DocUrl;

public class DocElementCreationParserHandler
implements ParserHandler {
    private final ComponentsRegistry componentsRegistry;
    private final Path path;
    private final List<AuxiliaryFile> auxiliaryFiles;
    private final List<String> globalAnchorIds;
    private final List<DocElement> paragraphs;
    private final DocElement docElement;
    private final Deque<DocElement> elementsStack;
    private String currentSectionTitle;
    private boolean isSectionStarted;

    public DocElementCreationParserHandler(ComponentsRegistry componentsRegistry, Path path2) {
        this.componentsRegistry = componentsRegistry;
        this.path = path2;
        this.paragraphs = new ArrayList<DocElement>();
        this.auxiliaryFiles = new ArrayList<AuxiliaryFile>();
        this.globalAnchorIds = new ArrayList<String>();
        this.docElement = new DocElement("Page");
        this.elementsStack = new ArrayDeque<DocElement>();
        this.elementsStack.add(this.docElement);
        this.currentSectionTitle = "";
        this.isSectionStarted = false;
    }

    public DocElement getDocElement() {
        return this.docElement;
    }

    public List<AuxiliaryFile> getAuxiliaryFiles() {
        return this.auxiliaryFiles;
    }

    public List<String> getGlobalAnchorIds() {
        return this.globalAnchorIds;
    }

    @Override
    public void onSectionStart(String title) {
        this.currentSectionTitle = title;
        if (this.isSectionStarted) {
            this.onSectionEnd();
        }
        String id = new PageSectionIdTitle(title).getId();
        this.start("Section", "title", title, "id", id);
        this.componentsRegistry.docStructure().registerLocalAnchor(this.path, id);
        this.isSectionStarted = true;
    }

    @Override
    public void onSectionEnd() {
        this.currentSectionTitle = "";
        this.isSectionStarted = false;
        if (this.elementsStack.size() > 1) {
            this.end();
        }
    }

    @Override
    public void onSubHeading(int level, String title) {
        String id = new PageSectionIdTitle(title).getId();
        this.append("SubHeading", "level", level, "title", title, "id", id);
        this.componentsRegistry.docStructure().registerLocalAnchor(this.path, id);
    }

    @Override
    public void onHardLineBreak() {
        this.append("HardLineBreak", new Object[0]);
    }

    @Override
    public void onSoftLineBreak() {
        this.append("SoftLineBreak", new Object[0]);
    }

    @Override
    public void onParagraphStart() {
        this.start("Paragraph", new Object[0]);
    }

    @Override
    public void onParagraphEnd() {
        DocElement paragraph = this.end();
        this.paragraphs.add(paragraph);
    }

    @Override
    public void onBulletListStart(char bulletMarker, boolean tight) {
        this.start("BulletList", "bulletMarker", Character.valueOf(bulletMarker), "tight", tight);
    }

    @Override
    public void onBulletListEnd() {
        this.end();
    }

    @Override
    public void onOrderedListStart(char delimiter, int startNumber) {
        this.start("OrderedList", "delimiter", Character.valueOf(delimiter), "startNumber", startNumber);
    }

    @Override
    public void onOrderedListEnd() {
        this.end();
    }

    @Override
    public void onListItemStart() {
        this.start("ListItem", new Object[0]);
    }

    @Override
    public void onListItemEnd() {
        this.end();
    }

    @Override
    public void onTable(MarkupTableData tableData) {
        this.append(new DocElement("Table", "table", tableData.toMap()));
    }

    @Override
    public void onEmphasisStart() {
        this.start("Emphasis", new Object[0]);
    }

    @Override
    public void onEmphasisEnd() {
        this.end();
    }

    @Override
    public void onStrongEmphasisStart() {
        this.start("StrongEmphasis", new Object[0]);
    }

    @Override
    public void onStrongEmphasisEnd() {
        this.end();
    }

    @Override
    public void onStrikeThroughStart() {
        this.start("StrikeThrough", new Object[0]);
    }

    @Override
    public void onStrikeThroughEnd() {
        this.end();
    }

    @Override
    public void onBlockQuoteStart() {
        this.start("BlockQuote", new Object[0]);
    }

    @Override
    public void onBlockQuoteEnd() {
        this.end();
    }

    @Override
    public void onSimpleText(String value) {
        this.append("SimpleText", "text", value);
    }

    @Override
    public void onInlinedCode(String inlinedCode, DocReferences docReferences) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("code", inlinedCode);
        if (!docReferences.isEmpty()) {
            props.put("references", docReferences.toMap());
        }
        this.append("InlinedCode", props);
    }

    @Override
    public void onLinkStart(String url) {
        boolean isFile = this.isLocalFile(url);
        String convertedUrl = isFile ? this.convertAndRegisterLocalFileToUrl(url) : this.validateAndCovertUrl(url);
        this.start("Link", "url", convertedUrl, "isFile", isFile);
    }

    @Override
    public void onLinkEnd() {
        this.end();
    }

    @Override
    public void onImage(String title, String destination, String alt) {
        DocStructure docStructure = this.componentsRegistry.docStructure();
        ResourcesResolver resourcesResolver = this.componentsRegistry.resourceResolver();
        AuxiliaryFile auxiliaryFile = resourcesResolver.runtimeAuxiliaryFile(destination);
        BufferedImage image = resourcesResolver.imageContent(destination);
        this.append("Image", "title", title, "destination", docStructure.fullUrl(auxiliaryFile.getDeployRelativePath().toString()), "alt", alt, "inlined", true, "timestamp", this.componentsRegistry.timeService().fileModifiedTimeMillis(auxiliaryFile.getPath()), "width", image.getWidth(), "height", image.getHeight());
        if (!destination.startsWith("http")) {
            this.auxiliaryFiles.add(auxiliaryFile);
        }
    }

    @Override
    public void onSnippet(PluginParams pluginParams, String lang, String lineNumber, String snippet) {
        Map<String, Object> snippetProps = CodeSnippetsProps.create(lang, snippet);
        snippetProps.put("lineNumber", lineNumber);
        snippetProps.putAll(pluginParams.getOpts().toMap());
        this.append("Snippet", snippetProps);
    }

    @Override
    public void onThematicBreak() {
        this.append("ThematicBreak", new Object[0]);
    }

    @Override
    public void onCustomNodeStart(String nodeName, Map<String, ?> attrs) {
        DocElement docElement = new DocElement(nodeName);
        attrs.forEach(docElement::addProp);
        this.appendAndPush(docElement);
    }

    @Override
    public void onCustomNode(String nodeName, Map<String, ?> attrs) {
        this.append(nodeName, attrs);
    }

    @Override
    public void onCustomNodeEnd(String nodeName) {
        this.end();
    }

    @Override
    public void onGlobalAnchor(String id) {
        this.componentsRegistry.docStructure().registerGlobalAnchor(this.path, id);
        this.append("Anchor", "id", id);
    }

    @Override
    public void onGlobalAnchorRefStart(String id) {
        String anchorUrl = this.componentsRegistry.docStructure().globalAnchorUrl(this.path, id);
        this.onLinkStart(anchorUrl);
    }

    @Override
    public void onGlobalAnchorRefEnd() {
        this.onLinkEnd();
    }

    @Override
    public void onIncludePlugin(IncludePlugin includePlugin, PluginResult pluginResult) {
        this.processPlugin(includePlugin, pluginResult);
    }

    @Override
    public void onFencePlugin(FencePlugin fencePlugin, PluginResult pluginResult) {
        this.processPlugin(fencePlugin, pluginResult);
    }

    @Override
    public void onInlinedCodePlugin(PluginParams pluginParams) {
        InlinedCodePlugin inlinedCodePlugin = Plugins.inlinedCodePluginById(pluginParams.getPluginId());
        this.processPlugin(inlinedCodePlugin, (E p) -> p.process(this.componentsRegistry, this.path, pluginParams));
    }

    private <E extends Plugin> void processPlugin(E plugin, Function<E, PluginResult> processFunc) {
        try {
            PluginResult result = processFunc.apply(plugin);
            this.processPlugin(plugin, result);
        }
        catch (Exception e) {
            throw new RuntimeException("failure during processing plugin '" + plugin.id() + "': " + e.getMessage(), e);
        }
    }

    private <E extends Plugin> void processPlugin(E plugin, PluginResult result) {
        plugin.auxiliaryFiles(this.componentsRegistry).forEach(this.auxiliaryFiles::add);
        List<DocElement> docElements = result.getDocElements();
        if (docElements.isEmpty()) {
            return;
        }
        docElements.forEach(el -> {
            if (el.getType().equals("Section")) {
                while (this.elementsStack.size() > 1) {
                    this.end();
                }
            }
            this.append((DocElement)el);
        });
    }

    @Override
    public void onParsingEnd() {
        this.removeEmptyParagraphs(this.docElement);
        this.paragraphs.forEach(this::convertParagraphWithSingleImageToWideImage);
    }

    private void removeEmptyParagraphs(DocElement element) {
        List<DocElement> emptyParagraphs = element.getContent().stream().filter(e -> e.getType().equals("Paragraph") && e.getContent().isEmpty()).collect(Collectors.toList());
        emptyParagraphs.forEach(element::removeChild);
        element.getContent().forEach(this::removeEmptyParagraphs);
    }

    private void convertParagraphWithSingleImageToWideImage(DocElement paragraph) {
        if (paragraph.getContent().size() != 1) {
            return;
        }
        DocElement singleElement = paragraph.getContent().get(0);
        if (!singleElement.getType().equals("Image")) {
            return;
        }
        paragraph.setType(singleElement.getType());
        singleElement.getProps().forEach(paragraph::addProp);
        paragraph.addProp("inlined", false);
        paragraph.removeChild(singleElement);
    }

    private void start(String type, Object ... propsKeyValue) {
        this.appendAndPush(new DocElement(type, propsKeyValue));
    }

    private DocElement end() {
        return this.elementsStack.removeLast();
    }

    private void append(String type, Object ... propsKeyValue) {
        this.append(new DocElement(type, propsKeyValue));
    }

    private void append(String type, Map<String, ?> propsKeyValue) {
        DocElement element = new DocElement(type);
        propsKeyValue.forEach(element::addProp);
        this.append(element);
    }

    private void append(DocElement element) {
        this.elementsStack.peekLast().addChild(element);
    }

    private void appendAndPush(DocElement element) {
        this.elementsStack.peekLast().addChild(element);
        this.elementsStack.add(element);
    }

    private String validateAndCovertUrl(String url) {
        DocStructure docStructure = this.componentsRegistry.docStructure();
        DocUrl docUrl = new DocUrl(url);
        docStructure.validateUrl(this.path, "section title: " + this.currentSectionTitle, docUrl);
        return docStructure.createUrl(this.path, docUrl);
    }

    private boolean isLocalFile(String url) {
        if (url.startsWith("http:") || url.startsWith("https:") || url.startsWith("mailto:")) {
            return false;
        }
        ResourcesResolver resourcesResolver = this.componentsRegistry.resourceResolver();
        return url.indexOf(46) != -1 && resourcesResolver.isLocalFile(url);
    }

    private String convertAndRegisterLocalFileToUrl(String url) {
        DocStructure docStructure = this.componentsRegistry.docStructure();
        ResourcesResolver resourcesResolver = this.componentsRegistry.resourceResolver();
        AuxiliaryFile auxiliaryFile = resourcesResolver.runtimeAuxiliaryFile(url);
        this.auxiliaryFiles.add(auxiliaryFile);
        return docStructure.fullUrl(auxiliaryFile.getDeployRelativePath().toString());
    }
}

