/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.search;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import znaishaded.org.testingisdocumenting.znai.search.PageSearchEntry;
import znaishaded.org.testingisdocumenting.znai.structure.TocItem;

public class PageSearchEntries {
    private final TocItem tocItem;
    private List<PageSearchEntry> entries;

    public PageSearchEntries(TocItem tocItem, List<PageSearchEntry> entries) {
        this.tocItem = tocItem;
        this.entries = entries;
    }

    public TocItem getTocItem() {
        return this.tocItem;
    }

    public List<PageSearchEntry> getEntries() {
        return this.entries;
    }

    public List<List<String>> toListOfLists() {
        return this.entries.stream().map(this::createList).collect(Collectors.toList());
    }

    private List<String> createList(PageSearchEntry pageSearchEntry) {
        return Arrays.asList(this.genId(pageSearchEntry), this.tocItem.getSectionTitle(), this.tocItem.getPageTitle(), pageSearchEntry.getPageSectionTitle(), pageSearchEntry.getSearchText().getText());
    }

    private String genId(PageSearchEntry pageSearchEntry) {
        return this.tocItem.getDirName() + "@@" + this.tocItem.getFileNameWithoutExtension() + "@@" + pageSearchEntry.getPageSectionId();
    }
}

