/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.server.docpreparation;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationHandlers;
import znaishaded.org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationSocketProgress;
import znaishaded.org.testingisdocumenting.znai.server.sockets.JsonWebSocketHandler;
import znaishaded.org.testingisdocumenting.znai.utils.CollectionUtils;

public class DocumentationPreparationWebSocketHandler
extends JsonWebSocketHandler {
    private Vertx vertx;

    public DocumentationPreparationWebSocketHandler(Vertx vertx) {
        super("documentation update", "/_doc-update");
        this.vertx = vertx;
    }

    public void sendUpdate(String docId, String message, Map<String, String> keyValues, int progressPercent) {
        LinkedHashMap<String, Object> payload = new LinkedHashMap<String, Object>();
        payload.put("message", message);
        payload.put("progress", progressPercent);
        List keyValuesList = keyValues.keySet().stream().map(key -> CollectionUtils.createMap("key", key, "value", keyValues.get(key))).collect(Collectors.toList());
        payload.put("keyValues", keyValuesList);
        this.send("/" + docId, payload);
    }

    @Override
    public void onConnect(String uri) {
        int lastSepIdx = uri.lastIndexOf(47);
        String docId = uri.substring(lastSepIdx + 1);
        this.vertx.executeBlocking(future -> DocumentationPreparationHandlers.prepare(docId, new DocumentationPreparationSocketProgress(docId, this)), false, res -> {});
    }
}

