/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.server.landing;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.org.testingisdocumenting.znai.html.HtmlPage;
import znaishaded.org.testingisdocumenting.znai.html.reactjs.HtmlReactJsPage;
import znaishaded.org.testingisdocumenting.znai.html.reactjs.ReactJsBundle;
import znaishaded.org.testingisdocumenting.znai.server.landing.LandingDocEntriesProviders;
import znaishaded.org.testingisdocumenting.znai.server.landing.LandingDocEntry;
import znaishaded.org.testingisdocumenting.znai.server.urlhandlers.UrlContentHandler;

public class LandingUrlContentHandler
implements UrlContentHandler {
    private String landingTitle;
    private String landingType;

    public LandingUrlContentHandler(String landingTitle, String landingType) {
        this.landingTitle = landingTitle;
        this.landingType = landingType;
    }

    @Override
    public String url() {
        return "/";
    }

    @Override
    public String buildContent(RoutingContext ctx, ReactJsBundle reactJsBundle) {
        List documentations = LandingDocEntriesProviders.provide().map(LandingDocEntry::toMap).collect(Collectors.toList());
        HtmlReactJsPage htmlReactJsPage = new HtmlReactJsPage(reactJsBundle);
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("documentations", documentations);
        props.put("type", this.landingType);
        props.put("title", this.landingTitle);
        HtmlPage htmlPage = htmlReactJsPage.create(this.landingTitle + " " + this.landingType, "Landing", props, () -> "", "/static/favicon/default.png");
        return htmlPage.render("");
    }
}

