/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.server.preview;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Stream;
import znaishaded.org.testingisdocumenting.znai.console.ConsoleOutputs;
import znaishaded.org.testingisdocumenting.znai.console.ansi.Color;
import znaishaded.org.testingisdocumenting.znai.html.DocPageReactProps;
import znaishaded.org.testingisdocumenting.znai.html.HtmlPageAndPageProps;
import znaishaded.org.testingisdocumenting.znai.reference.DocReferences;
import znaishaded.org.testingisdocumenting.znai.server.preview.FileChangeHandler;
import znaishaded.org.testingisdocumenting.znai.server.preview.PreviewWebSocketHandler;
import znaishaded.org.testingisdocumenting.znai.structure.DocMeta;
import znaishaded.org.testingisdocumenting.znai.structure.TocItem;
import znaishaded.org.testingisdocumenting.znai.utils.FileUtils;
import znaishaded.org.testingisdocumenting.znai.website.TocAddedAndRemovedPages;
import znaishaded.org.testingisdocumenting.znai.website.WebSite;

public class PreviewPushFileChangeHandler
implements FileChangeHandler {
    private PreviewWebSocketHandler previewSocket;
    private WebSite previewWebSite;

    public PreviewPushFileChangeHandler(PreviewWebSocketHandler previewSocket, WebSite previewWebSite) {
        this.previewSocket = previewSocket;
        this.previewWebSite = previewWebSite;
    }

    @Override
    public void onTocChange(Path tocPath) {
        ConsoleOutputs.out("toc changed: ", tocPath);
        this.execute(() -> {
            TocAddedAndRemovedPages tocAddedAndRemovedPages = this.previewWebSite.updateToc();
            this.previewSocket.sendToc(tocAddedAndRemovedPages.getTableOfContents());
            if (!tocAddedAndRemovedPages.getAddedPagesProps().isEmpty()) {
                this.previewSocket.sendPages(tocAddedAndRemovedPages.getAddedPagesProps().stream().map(HtmlPageAndPageProps::getProps));
            }
            if (!tocAddedAndRemovedPages.getRemovedTocItems().isEmpty()) {
                this.previewSocket.sendPagesRemove(tocAddedAndRemovedPages.getRemovedTocItems().stream());
            }
        });
    }

    @Override
    public void onGlobalDocReferencesChange(Path docReferencePath) {
        ConsoleOutputs.out("global doc references changed: ", docReferencePath);
        this.execute(() -> {
            DocReferences docReferences = this.previewWebSite.updateDocReferences();
            this.previewSocket.sendDocReferences(docReferences);
        });
    }

    @Override
    public void onDocMetaChange(Path metaPath) {
        ConsoleOutputs.out("meta changed: ", metaPath);
        this.execute(() -> {
            String metaJson = FileUtils.fileTextContent(metaPath);
            DocMeta newDocMeta = this.previewWebSite.getDocMeta().cloneWithNewJson(metaJson);
            this.previewSocket.sendMeta(newDocMeta);
        });
    }

    private HtmlPageAndPageProps regenerate(Path markupPath) {
        TocItem tocItem = this.previewWebSite.tocItemByPath(markupPath);
        if (tocItem == null) {
            return null;
        }
        return this.previewWebSite.regenerateAndValidatePageDeployTocAndAllPages(tocItem);
    }

    @Override
    public void onChange(Path path2) {
        ConsoleOutputs.out("file changed: ", path2);
        TocItem tocItem = this.previewWebSite.tocItemByPath(path2);
        if (tocItem == null) {
            ConsoleOutputs.out(path2 + " is not part of table of contents, checking dependent files");
            this.onDependentChange(path2);
        } else {
            this.onMarkupChange(path2);
        }
    }

    private void onMarkupChange(Path path2) {
        this.execute(() -> {
            HtmlPageAndPageProps htmlPageAndPageProps = this.regenerate(path2);
            if (htmlPageAndPageProps == null) {
                return;
            }
            this.previewSocket.sendPage(htmlPageAndPageProps.getProps());
            this.previewSocket.sendToc(this.previewWebSite.getToc());
        });
    }

    private void onDependentChange(Path path2) {
        this.execute(() -> {
            Set<TocItem> dependentTocItems = this.previewWebSite.dependentTocItems(path2);
            if (dependentTocItems.isEmpty()) {
                ConsoleOutputs.out(new Object[]{"no markup files depends on ", Color.BLUE, path2});
                return;
            }
            this.previewWebSite.redeployAuxiliaryFileIfRequired(path2);
            dependentTocItems.forEach(System.out::println);
            Stream<DocPageReactProps> generatedPages = dependentTocItems.stream().map(tocItem -> this.previewWebSite.regenerateAndValidatePageDeployTocAndAllPages((TocItem)tocItem).getProps());
            this.previewSocket.sendPages(generatedPages);
            this.previewSocket.sendToc(this.previewWebSite.getToc());
        });
    }

    private void execute(Runnable code) {
        try {
            code.run();
        }
        catch (Exception e) {
            ConsoleOutputs.err(e.getMessage());
            this.previewSocket.sendError(e.getMessage(), PreviewPushFileChangeHandler.renderStackTrace(e));
        }
    }

    private static String renderStackTrace(Throwable t) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter writer = new PrintWriter(stringWriter);
        t.printStackTrace(writer);
        return stringWriter.toString();
    }
}

