/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.server.upload;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.file.AsyncFile;
import znaishaded.io.vertx.core.file.OpenOptions;
import znaishaded.io.vertx.core.http.HttpServerRequest;
import znaishaded.io.vertx.core.streams.Pump;
import znaishaded.org.testingisdocumenting.znai.server.upload.OnUploadFinishedServerHandlers;

public class DocumentationUploadHandler
implements Handler<HttpServerRequest> {
    private Vertx vertx;
    private final String docId;
    private final Path destination;
    private final String actor;

    public DocumentationUploadHandler(Vertx vertx, String docId, Path deployRoot, String actor) {
        this.vertx = vertx;
        this.docId = docId;
        this.destination = deployRoot.resolve(docId + ".zip");
        this.actor = actor;
    }

    @Override
    public void handle(HttpServerRequest req) {
        req.pause();
        this.vertx.fileSystem().open(this.destination.toString(), new OpenOptions(), fh -> {
            AsyncFile file = (AsyncFile)fh.result();
            Pump pump = Pump.pump(req, file);
            req.endHandler(eh -> file.close(fch -> {
                req.response().end();
                OnUploadFinishedServerHandlers.onUploadFinished(this.docId, this.destination, this.actor);
                this.deleteUploadedFile();
            }));
            pump.start();
            req.resume();
        });
    }

    private void deleteUploadedFile() {
        try {
            Files.delete(this.destination);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

