/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.structure;

import java.time.Instant;
import java.util.List;
import java.util.stream.Collectors;
import znaishaded.org.testingisdocumenting.znai.parser.PageSectionIdTitle;
import znaishaded.org.testingisdocumenting.znai.parser.docelement.DocElement;
import znaishaded.org.testingisdocumenting.znai.structure.PageMeta;

public class Page {
    private final DocElement docElement;
    private final List<PageSectionIdTitle> pageSectionIdTitles;
    private final Instant lastModifiedTime;
    private final PageMeta pageMeta;

    public Page(DocElement docElement, Instant lastModifiedTime, PageMeta pageMeta) {
        this.docElement = docElement;
        this.pageSectionIdTitles = this.extractFirstLevelHeadings(docElement);
        this.lastModifiedTime = lastModifiedTime;
        this.pageMeta = pageMeta;
    }

    public DocElement getDocElement() {
        return this.docElement;
    }

    public Instant getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public PageMeta getPageMeta() {
        return this.pageMeta;
    }

    public List<PageSectionIdTitle> getPageSectionIdTitles() {
        return this.pageSectionIdTitles;
    }

    private List<PageSectionIdTitle> extractFirstLevelHeadings(DocElement docElement) {
        return docElement.getContent().stream().filter(e -> e.getType().equals("Section")).map(this::createSectionIdTitle).collect(Collectors.toList());
    }

    private PageSectionIdTitle createSectionIdTitle(DocElement docElement) {
        String title = docElement.getProp("title").toString();
        return new PageSectionIdTitle(title);
    }
}

