/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.structure;

import java.util.Arrays;
import java.util.List;
import znaishaded.org.testingisdocumenting.znai.structure.TableOfContents;
import znaishaded.org.testingisdocumenting.znai.structure.TocGenerator;

public class PlainTextTocGenerator
implements TocGenerator {
    @Override
    public TableOfContents generate(String textContent) {
        return new Parser(textContent).parse();
    }

    private static class Parser {
        public static final String INDENTATION = "    ";
        private List<String> nestedLines;
        private String currentSection;
        private TableOfContents toc;

        public Parser(String nestedText) {
            this.nestedLines = Arrays.asList(nestedText.replace("\r", "").split("\n"));
            this.toc = new TableOfContents();
        }

        public TableOfContents parse() {
            this.nestedLines.forEach(this::parse);
            return this.toc;
        }

        private void parse(String line) {
            String trimmedLine = line.trim();
            if (trimmedLine.isEmpty()) {
                return;
            }
            if (line.startsWith(INDENTATION)) {
                this.handlePageEntry(trimmedLine);
            } else if (line.startsWith(" ")) {
                this.handleSyntaxError();
            } else {
                this.handleSectionEntry(trimmedLine);
            }
        }

        private void handleSyntaxError() {
            throw new IllegalArgumentException("toc line should either start with " + INDENTATION.length() + " spaces to denote section name, or start without spaces to denote page file name");
        }

        private void handleSectionEntry(String trimmedLine) {
            this.currentSection = trimmedLine;
        }

        private void handlePageEntry(String line) {
            if (this.currentSection == null) {
                throw new IllegalArgumentException("section is not specified, use a line without indentation to specify a section");
            }
            this.toc.addTocItem(this.currentSection, line);
        }
    }
}

