/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.typescript;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import znaishaded.org.testingisdocumenting.znai.utils.JsonUtils;
import znaishaded.org.testingisdocumenting.znai.utils.ResourceUtils;

public class TypescriptNodeBasedParser {
    private final Process node = this.createProcess(this.tempParserCodeLocation());
    private final OutputStream outputStream;
    private final InputStream inputStream = this.node.getInputStream();

    public TypescriptNodeBasedParser() {
        this.outputStream = this.node.getOutputStream();
    }

    public List<Map<String, ?>> parsedFile(Path filePath) {
        this.write(filePath.toAbsolutePath().toString());
        String response = this.readResponse();
        return JsonUtils.deserializeAsList(response);
    }

    private Path tempParserCodeLocation() {
        String textContent = ResourceUtils.textContent("typeScriptParserBundle.js");
        try {
            Path path2 = Files.createTempFile("typescriptParser", ".js", new FileAttribute[0]);
            path2.toFile().deleteOnExit();
            Files.write(path2, textContent.getBytes(), new OpenOption[0]);
            return path2;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void write(String content) {
        try {
            this.outputStream.write((content + "\n").getBytes());
            this.outputStream.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String readResponse() {
        Scanner scanner = new Scanner(this.inputStream);
        return scanner.nextLine();
    }

    private Process createProcess(Path scriptPath) {
        try {
            String nodePath = this.getNodePath();
            return new ProcessBuilder(new String[0]).command(nodePath, scriptPath.toAbsolutePath().toString()).redirectErrorStream(true).start();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String getNodePath() {
        String nodeBin = System.getProperty("node.bin");
        return nodeBin != null ? nodeBin : "node";
    }

    public static void main(String[] args) {
        TypescriptNodeBasedParser parser = new TypescriptNodeBasedParser();
    }
}

