/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class FileUtils {
    private FileUtils() {
    }

    public static void writeTextContent(Path path2, String text) {
        try {
            Path parent = path2.toAbsolutePath().getParent();
            if (parent != null) {
                Files.createDirectories(parent, new FileAttribute[0]);
            }
            Files.write(path2, text.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String fileTextContent(Path path2) {
        if (!Files.exists(path2, new LinkOption[0])) {
            throw new RuntimeException(path2.toAbsolutePath() + " doesn't exist");
        }
        try {
            return Files.lines(path2).collect(Collectors.joining("\n"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] fileBinaryContent(Path path2) {
        if (!Files.exists(path2, new LinkOption[0])) {
            throw new RuntimeException(path2.toAbsolutePath() + " doesn't exist");
        }
        try {
            return Files.readAllBytes(path2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Path existingPathOrThrow(Path ... paths) {
        List nonNull = Arrays.stream(paths).filter(Objects::nonNull).collect(Collectors.toList());
        return nonNull.stream().filter(p -> Files.exists(p, new LinkOption[0])).findFirst().orElseThrow(() -> new RuntimeException("can't find any of the following files:\n" + nonNull.stream().map(Path::toString).collect(Collectors.joining("\n"))));
    }

    public static void symlinkAwareCreateDirs(Path path2) {
        try {
            Path dir = Files.isSymbolicLink(path2) ? Files.readSymbolicLink(path2) : path2;
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyFile(Path source, Path target) {
        try {
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            Files.copy(source, target, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

