/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.website;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import znaishaded.org.testingisdocumenting.znai.core.ResourcesResolver;
import znaishaded.org.testingisdocumenting.znai.web.WebResource;
import znaishaded.org.testingisdocumenting.znai.web.extensions.WebSiteResourcesProvider;

public class WebSiteUserExtensions
implements WebSiteResourcesProvider {
    private final List<WebResource> cssResources;
    private final List<WebResource> jsResources;
    private final List<WebResource> jsClientOnlyResources;
    private final List<WebResource> htmlHeadResources;
    private final List<WebResource> htmlBodyResources;
    private final List<WebResource> additionalFilesToDeploy;
    private final Map<String, ?> definition;
    private final ResourcesResolver resourcesResolver;

    public WebSiteUserExtensions(ResourcesResolver resourcesResolver, Map<String, ?> definition) {
        this.resourcesResolver = resourcesResolver;
        this.definition = definition;
        this.cssResources = this.extract("cssResources", "style.css");
        this.jsResources = this.extract("jsResources");
        this.jsClientOnlyResources = this.extract("jsClientOnlyResources");
        this.htmlBodyResources = this.extract("htmlResources");
        this.htmlHeadResources = this.extract("htmlHeadResources", "tracking.html");
        this.additionalFilesToDeploy = this.extract("additionalFilesToDeploy");
    }

    @Override
    public Stream<WebResource> cssResources() {
        return this.cssResources.stream();
    }

    @Override
    public Stream<WebResource> htmlHeadResources() {
        return this.htmlHeadResources.stream();
    }

    @Override
    public Stream<WebResource> htmlBodyResources() {
        return this.htmlBodyResources.stream();
    }

    @Override
    public Stream<WebResource> jsResources() {
        return this.jsResources.stream();
    }

    @Override
    public Stream<WebResource> jsClientOnlyResources() {
        return this.jsClientOnlyResources.stream();
    }

    @Override
    public Stream<WebResource> additionalFilesToDeploy() {
        return this.additionalFilesToDeploy.stream();
    }

    private List<WebResource> extract(String extensionsKey) {
        return this.extract(extensionsKey, "");
    }

    private List<WebResource> extract(String extensionsKey, String fileName) {
        Stream<WebResource> fromExtensions = this.extractFromExtensions(extensionsKey);
        Stream fromFile = fileName.isEmpty() ? Stream.empty() : this.extractFromFile(fileName);
        return Stream.concat(fromExtensions, fromFile).collect(Collectors.toList());
    }

    private Stream<WebResource> extractFromExtensions(String key) {
        List resources = (List)this.definition.get(key);
        return resources == null ? Stream.empty() : resources.stream().map(p -> WebResource.withPath(this.resourcesResolver.fullPath((String)p), p));
    }

    private Stream<WebResource> extractFromFile(String name) {
        if (!this.resourcesResolver.canResolve(name)) {
            return Stream.empty();
        }
        Path stylePath = this.resourcesResolver.fullPath(name);
        return Stream.of(WebResource.withPath(stylePath, name));
    }
}

