/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.website.markups;

import java.io.File;
import java.nio.file.Path;
import znaishaded.org.testingisdocumenting.znai.core.ComponentsRegistry;
import znaishaded.org.testingisdocumenting.znai.parser.MarkupParser;
import znaishaded.org.testingisdocumenting.znai.parser.MarkupParsingConfiguration;
import znaishaded.org.testingisdocumenting.znai.parser.commonmark.MarkdownParser;
import znaishaded.org.testingisdocumenting.znai.structure.PlainTextTocGenerator;
import znaishaded.org.testingisdocumenting.znai.structure.PlainTextTocPatcher;
import znaishaded.org.testingisdocumenting.znai.structure.TableOfContents;
import znaishaded.org.testingisdocumenting.znai.structure.TocItem;
import znaishaded.org.testingisdocumenting.znai.utils.FilePathUtils;

public class MarkdownParsingConfiguration
implements MarkupParsingConfiguration {
    public static final String TOC_PATCH_NAME = "toc-patch";

    @Override
    public String configurationName() {
        return "markdown";
    }

    @Override
    public TableOfContents createToc(ComponentsRegistry componentsRegistry) {
        TableOfContents toc = new PlainTextTocGenerator().generate(componentsRegistry.resourceResolver().textContent("toc"));
        toc.addIndex();
        if (componentsRegistry.resourceResolver().canResolve(TOC_PATCH_NAME)) {
            String patch = componentsRegistry.resourceResolver().textContent(TOC_PATCH_NAME);
            new PlainTextTocPatcher(toc).patch(patch);
        }
        return toc;
    }

    @Override
    public MarkupParser createMarkupParser(ComponentsRegistry componentsRegistry) {
        return new MarkdownParser(componentsRegistry);
    }

    @Override
    public String tocItemResourceName(TocItem tocItem) {
        return tocItem.getDirName() + (tocItem.getDirName().isEmpty() ? "" : File.separator) + tocItem.getFileNameWithoutExtension() + "." + this.filesExtension();
    }

    @Override
    public Path fullPath(ComponentsRegistry componentsRegistry, Path root, TocItem tocItem) {
        return componentsRegistry.resourceResolver().fullPath(this.tocItemResourceName(tocItem));
    }

    @Override
    public TocItem tocItemByPath(ComponentsRegistry componentsRegistry, TableOfContents toc, Path path2) {
        if (path2.getFileName().toString().startsWith("index.")) {
            return toc.getIndex();
        }
        return toc.findTocItem(path2.toAbsolutePath().getParent().getFileName().toString(), FilePathUtils.fileNameWithoutExtension(path2));
    }

    private String filesExtension() {
        return "md";
    }
}

