/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.testingisdocumenting.znai.website.markups;

import java.nio.file.Path;
import znaishaded.org.testingisdocumenting.znai.core.ComponentsRegistry;
import znaishaded.org.testingisdocumenting.znai.parser.MarkupParser;
import znaishaded.org.testingisdocumenting.znai.parser.MarkupParsingConfiguration;
import znaishaded.org.testingisdocumenting.znai.parser.sphinx.DocTreeTocGenerator;
import znaishaded.org.testingisdocumenting.znai.parser.sphinx.SphinxDocTreeParser;
import znaishaded.org.testingisdocumenting.znai.structure.TableOfContents;
import znaishaded.org.testingisdocumenting.znai.structure.TocItem;
import znaishaded.org.testingisdocumenting.znai.utils.FilePathUtils;

public class SphinxParsingConfiguration
implements MarkupParsingConfiguration {
    @Override
    public String configurationName() {
        return "sphinx";
    }

    @Override
    public TableOfContents createToc(ComponentsRegistry componentsRegistry) {
        return new DocTreeTocGenerator().generate(componentsRegistry.resourceResolver().textContent("index.xml"));
    }

    @Override
    public MarkupParser createMarkupParser(ComponentsRegistry componentsRegistry) {
        return new SphinxDocTreeParser(componentsRegistry);
    }

    @Override
    public String tocItemResourceName(TocItem tocItem) {
        return tocItem.getFileNameWithoutExtension() + "." + this.filesExtension();
    }

    @Override
    public Path fullPath(ComponentsRegistry componentsRegistry, Path root, TocItem tocItem) {
        return root.resolve(tocItem.getDirName()).resolve(this.tocItemResourceName(tocItem));
    }

    @Override
    public TocItem tocItemByPath(ComponentsRegistry componentsRegistry, TableOfContents toc, Path path2) {
        if (path2.getFileName().toString().startsWith("index.")) {
            return toc.getIndex();
        }
        return toc.findTocItem(path2.toAbsolutePath().getParent().getFileName().toString(), FilePathUtils.fileNameWithoutExtension(path2));
    }

    private String filesExtension() {
        return "xml";
    }
}

