/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.features.PluginFeature;
import org.testingisdocumenting.znai.extensions.file.SnippetContentProvider;

public class SnippetHighlightFeature
implements PluginFeature {
    private final ComponentsRegistry componentsRegistry;
    private final PluginParams pluginParams;
    private final Path highlightFileFullPath;
    private final String highlightPath;
    private final List<Object> highlight;
    private final SnippetContentProvider contentProvider;

    public SnippetHighlightFeature(ComponentsRegistry componentsRegistry, PluginParams pluginParams, SnippetContentProvider contentProvider) {
        this.componentsRegistry = componentsRegistry;
        this.pluginParams = pluginParams;
        this.highlightPath = pluginParams.getOpts().get("highlightPath", null);
        this.highlightFileFullPath = this.highlightPath != null ? componentsRegistry.resourceResolver().fullPath(this.highlightPath) : null;
        this.highlight = this.extractHighlight(pluginParams.getOpts().getList("highlight"));
        this.contentProvider = contentProvider;
    }

    private List<Object> extractHighlight(List<Object> highlight) {
        if (this.highlightFileFullPath == null) {
            return highlight;
        }
        String textContent = this.componentsRegistry.resourceResolver().textContent(this.highlightPath);
        List<Object> combined = Arrays.asList(textContent.split("\n"));
        combined.addAll(highlight);
        return combined;
    }

    @Override
    public void updateProps(Map<String, Object> props) {
        if (!this.highlightProvided()) {
            return;
        }
        this.validateHighlight(this.contentProvider.snippetContent());
        props.put("highlight", this.highlight);
    }

    private void validateHighlight(String snippetContent) {
        String[] lines = snippetContent.split("\n");
        for (Object idxOrText : this.highlight) {
            if (idxOrText instanceof Number) {
                this.validateIdx(lines, (Number)idxOrText);
                continue;
            }
            this.validateContains(lines, (String)idxOrText);
        }
    }

    private void validateIdx(String[] lines, Number idx) {
        int intValue = idx.intValue();
        if (intValue >= lines.length || intValue < 0) {
            throw new IllegalArgumentException("highlight idx is out of range: " + idx + this.exceptionIdMessage());
        }
    }

    private void validateContains(String[] lines, String partial) {
        if (Arrays.stream(lines).noneMatch(line -> line.contains(partial))) {
            throw new IllegalArgumentException("highlight text <" + partial + "> is not found" + this.exceptionIdMessage() + "\n" + this.contentProvider.snippetContent());
        }
    }

    private String exceptionIdMessage() {
        String id = this.contentProvider.snippetId();
        if (id.isEmpty()) {
            return "";
        }
        return "\ncheck: " + id;
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles() {
        return this.highlightFileFullPath != null ? Stream.of(AuxiliaryFile.builtTime(this.highlightFileFullPath)) : Stream.empty();
    }

    private boolean highlightProvided() {
        return !this.highlight.isEmpty();
    }
}

