/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.table;

import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.extensions.include.IncludePlugin;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.table.CsvParser;
import org.testingisdocumenting.znai.parser.table.MarkupTableData;
import org.testingisdocumenting.znai.search.SearchScore;
import org.testingisdocumenting.znai.search.SearchText;
import org.testingisdocumenting.znai.utils.JsonUtils;

public class TableIncludePlugin
implements IncludePlugin {
    private String textContent;
    private MarkupParser parser;
    private Path fullPath;
    private MarkupTableData rearrangedTable;

    @Override
    public String id() {
        return "table";
    }

    @Override
    public IncludePlugin create() {
        return new TableIncludePlugin();
    }

    @Override
    public PluginResult process(ComponentsRegistry componentsRegistry, ParserHandler parserHandler, Path markupPath, PluginParams pluginParams) {
        this.parser = componentsRegistry.defaultParser();
        String fileName = pluginParams.getFreeParam();
        this.fullPath = componentsRegistry.resourceResolver().fullPath(fileName);
        this.textContent = componentsRegistry.resourceResolver().textContent(fileName);
        MarkupTableData tableFromFile = this.isJson() ? this.tableFromJson() : CsvParser.parse(this.textContent);
        this.rearrangedTable = pluginParams.getOpts().has("columns") ? tableFromFile.withColumnsInOrder(pluginParams.getOpts().getList("columns")) : tableFromFile;
        Map<String, Object> tableAsMap = this.rearrangedTable.toMap();
        List columns = (List)tableAsMap.get("columns");
        pluginParams.getOpts().forEach((columnName, meta) -> {
            Optional<Map> column = columns.stream().filter(c -> c.get("title").equals(columnName)).findFirst();
            column.ifPresent(c -> c.putAll((Map)meta));
        });
        tableAsMap.put("data", this.parseMarkupInEachRow((List)tableAsMap.get("data")));
        LinkedHashMap<String, Map<String, Object>> props = new LinkedHashMap<String, Map<String, Object>>();
        props.put("table", tableAsMap);
        if (pluginParams.getOpts().has("title")) {
            props.put("title", (Map<String, Object>)pluginParams.getOpts().get("title"));
        }
        return PluginResult.docElement("Table", props);
    }

    private List<Object> parseMarkupInEachRow(List<List<Object>> rows) {
        return rows.stream().map(this::parseMarkupInCell).collect(Collectors.toList());
    }

    private List<Object> parseMarkupInCell(List<Object> row) {
        return row.stream().map(this::parseMarkupInCell).collect(Collectors.toList());
    }

    private List<Object> parseMarkupInCell(Object cell2) {
        if (cell2 == null) {
            return Collections.emptyList();
        }
        MarkupParserResult parserResult = this.parser.parse(this.fullPath, cell2.toString());
        return (List)parserResult.getDocElement().toMap().get("content");
    }

    private MarkupTableData tableFromJson() {
        MarkupTableData tableData = new MarkupTableData();
        List<?> rows = JsonUtils.deserializeAsList(this.textContent);
        if (rows.isEmpty()) {
            return tableData;
        }
        Map firstRowData = (Map)rows.get(0);
        firstRowData.keySet().forEach(tableData::addColumn);
        rows.forEach(tableData::addRow);
        return tableData;
    }

    private boolean isJson() {
        return this.textContent.trim().startsWith("[");
    }

    @Override
    public Stream<AuxiliaryFile> auxiliaryFiles(ComponentsRegistry componentsRegistry) {
        return Stream.of(AuxiliaryFile.builtTime(this.fullPath));
    }

    @Override
    public SearchText textForSearch() {
        return SearchScore.STANDARD.text(this.rearrangedTable.allText());
    }
}

