/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.resources;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.utils.ResourceUtils;

public class ClassPathResourceResolver
implements ResourcesResolver {
    private final ConcurrentHashMap<String, Path> fullPathByResourcePath = new ConcurrentHashMap();
    private final ConcurrentHashMap<Path, String> resourcePathByFullPath = new ConcurrentHashMap();

    @Override
    public void initialize(Stream<String> filteredLookupPaths) {
    }

    @Override
    public boolean supportsLookupPath(String lookupPath) {
        return false;
    }

    @Override
    public boolean canResolve(String resourcePath) {
        boolean canResolve;
        boolean bl = canResolve = ResourceUtils.resourceStream(resourcePath) != null;
        if (canResolve) {
            Path path2 = Paths.get(resourcePath, new String[0]);
            this.fullPathByResourcePath.put(resourcePath, path2);
            this.resourcePathByFullPath.put(path2, resourcePath);
        }
        return canResolve;
    }

    @Override
    public List<String> listOfTriedLocations(String path2) {
        return Collections.singletonList("<classpath>");
    }

    @Override
    public String textContent(String path2) {
        return ResourceUtils.textContent(path2);
    }

    @Override
    public BufferedImage imageContent(String path2) {
        try {
            return ImageIO.read(ResourceUtils.resourceStream(path2));
        }
        catch (IOException e) {
            throw new RuntimeException("Can't load image " + path2, e);
        }
    }

    @Override
    public String textContent(Path path2) {
        String resourcePath = this.resourcePathByFullPath.get(path2);
        return ResourceUtils.textContent(resourcePath);
    }

    @Override
    public Path fullPath(String path2) {
        return this.fullPathByResourcePath.get(path2);
    }

    @Override
    public Path docRootRelativePath(Path path2) {
        throw new UnsupportedOperationException("unsupported operation: docRootRelativePath(path)");
    }

    @Override
    public boolean isInsideDoc(Path path2) {
        return false;
    }

    @Override
    public boolean isLocalFile(String path2) {
        return false;
    }

    @Override
    public AuxiliaryFile runtimeAuxiliaryFile(String origin) {
        throw new UnsupportedOperationException("unsupported operation: runtimeAuxiliaryFile(origin)");
    }
}

