/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.resources;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.resources.HttpResource;
import org.testingisdocumenting.znai.resources.ResourcesResolver;

public class MultipleLocalLocationsResourceResolver
implements ResourcesResolver {
    private final Path docRootPath;
    private final List<Path> lookupPaths;
    private final ThreadLocal<Path> currentFilePath;
    private final Map<String, Path> outsideDocRequestedResources;

    public MultipleLocalLocationsResourceResolver(Path docRootPath) {
        this.docRootPath = docRootPath;
        this.lookupPaths = new ArrayList<Path>();
        this.currentFilePath = new ThreadLocal();
        this.outsideDocRequestedResources = new HashMap<String, Path>();
    }

    @Override
    public void initialize(Stream<String> filteredLookupPaths) {
        this.lookupPaths.clear();
        this.lookupPaths.addAll(filteredLookupPaths.map(this.docRootPath::resolve).collect(Collectors.toList()));
    }

    @Override
    public boolean supportsLookupPath(String lookupPath) {
        return !HttpResource.isHttpResource(lookupPath);
    }

    @Override
    public boolean canResolve(String path2) {
        return this.isLocalFile(path2);
    }

    @Override
    public List<String> listOfTriedLocations(String path2) {
        return this.allLocationsStream(path2).map(Path::toString).collect(Collectors.toList());
    }

    @Override
    public Path fullPath(String path2) {
        Path result = this.allLocationsStream(path2).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().orElseThrow(() -> new IllegalStateException("either file disappeared or canResolve implementation needs to be checked."));
        if (!Paths.get(path2, new String[0]).isAbsolute() && !this.isInsideDoc(result)) {
            this.outsideDocRequestedResources.put(path2, result);
        }
        return result;
    }

    public Map<String, Path> getOutsideDocRequestedResources() {
        return this.outsideDocRequestedResources;
    }

    @Override
    public Path docRootRelativePath(Path path2) {
        return this.docRootPath.relativize(path2);
    }

    @Override
    public boolean isInsideDoc(Path path2) {
        return path2.toAbsolutePath().startsWith(this.docRootPath);
    }

    @Override
    public boolean isLocalFile(String path2) {
        return this.allLocationsStream(path2).anyMatch(x$0 -> Files.exists(x$0, new LinkOption[0]));
    }

    private Stream<Path> allLocationsStream(String path2) {
        Path original = Paths.get(path2, new String[0]);
        Stream relativeToCurrent = this.currentFilePath.get() == null ? Stream.empty() : Stream.of(this.currentFilePath.get().getParent().resolve(path2));
        Stream<Object> absoluteLocation = original.isAbsolute() ? Stream.of(original) : Stream.empty();
        Stream<Path> lookedUpInLocations = this.lookupPaths.stream().map(p -> p.resolve(path2).normalize());
        return Stream.concat(relativeToCurrent, Stream.concat(absoluteLocation, lookedUpInLocations));
    }

    public void setCurrentFilePath(Path currentFilePath) {
        this.currentFilePath.set(currentFilePath);
    }
}

