/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.server;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.AnsiConsoleOutput;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.html.HtmlPage;
import org.testingisdocumenting.znai.html.reactjs.HtmlReactJsPage;
import org.testingisdocumenting.znai.html.reactjs.ReactJsBundle;
import org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationHandlers;
import org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationTestHandler;
import org.testingisdocumenting.znai.server.docpreparation.DocumentationPreparationWebSocketHandler;
import org.testingisdocumenting.znai.server.docpreparation.NoOpDocumentationPreparationProgress;
import org.testingisdocumenting.znai.server.landing.LandingDocEntriesProviders;
import org.testingisdocumenting.znai.server.landing.LandingDocEntry;
import org.testingisdocumenting.znai.server.landing.LandingUrlContentHandler;
import org.testingisdocumenting.znai.server.remove.DocumentationRemoveHandler;
import org.testingisdocumenting.znai.server.remove.OnRemoveFinishedServerHandlers;
import org.testingisdocumenting.znai.server.sockets.JsonWebSocketHandler;
import org.testingisdocumenting.znai.server.sockets.JsonWebSocketHandlerComposition;
import org.testingisdocumenting.znai.server.upload.DocumentationUploadHandler;
import org.testingisdocumenting.znai.server.upload.OnUploadFinishedServerHandlers;
import org.testingisdocumenting.znai.server.upload.UnzipTask;
import org.testingisdocumenting.znai.server.urlhandlers.UrlContentHandlers;
import org.testingisdocumenting.znai.utils.FileUtils;
import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.http.HttpServer;
import znaishaded.io.vertx.core.http.HttpServerOptions;
import znaishaded.io.vertx.ext.web.Router;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.handler.StaticHandler;
import znaishaded.io.vertx.ext.web.impl.RoutingContextDecorator;

public class DocumentationServer {
    private final JsonWebSocketHandlerComposition socketHandlers;
    private final Vertx vertx;
    private final ReactJsBundle reactJsBundle;
    private final Path deployRoot;

    public DocumentationServer(ReactJsBundle reactJsBundle, Path deployRoot) {
        this.reactJsBundle = reactJsBundle;
        this.deployRoot = deployRoot;
        System.setProperty("vertx.cwd", deployRoot.toString());
        System.setProperty("file.encoding", "UTF-8");
        FileUtils.symlinkAwareCreateDirs(deployRoot);
        this.vertx = Vertx.vertx();
        this.socketHandlers = new JsonWebSocketHandlerComposition();
        DocumentationPreparationWebSocketHandler socketHandler = new DocumentationPreparationWebSocketHandler(this.vertx);
        this.socketHandlers.add(socketHandler);
        OnUploadFinishedServerHandlers.add(this::unzip);
        OnRemoveFinishedServerHandlers.add(this::deleteCachedDocumentation);
    }

    public void addSocketHandler(JsonWebSocketHandler socketHandler) {
        this.socketHandlers.add(socketHandler);
    }

    public HttpServer create() {
        HttpServer server = this.vertx.createHttpServer(new HttpServerOptions().setCompressionSupported(true));
        Router router = Router.router(this.vertx);
        StaticHandler pagesStaticHandler = StaticHandler.create(".").setFilesReadOnly(false).setCachingEnabled(false);
        StaticHandler staticCommonResources = StaticHandler.create("static").setMaxAgeSeconds(600L);
        router.get("/:docId/static/*").handler(ctx -> {
            MultiMap params = ctx.request().params();
            staticCommonResources.handle(new RoutingContextDecorator(router.route("/" + params.get("docId") + "/static"), (RoutingContext)ctx));
        });
        router.delete("/:docId").handler(ctx -> {
            MultiMap params = ctx.request().params();
            String docId = params.get("docId");
            String actor = params.get("actor");
            new DocumentationRemoveHandler(docId, actor).handle(ctx.request());
        });
        router.route("/upload/:docId").handler(ctx -> {
            MultiMap params = ctx.request().params();
            String docId = params.get("docId");
            String actor = params.get("actor");
            new DocumentationUploadHandler(this.vertx, docId, this.deployRoot, actor).handle(ctx.request());
        });
        router.get("/static/*").handler(staticCommonResources);
        this.registerCustomHandlers(router);
        this.registerPagesHandler(router, pagesStaticHandler);
        server.websocketHandler(this.socketHandlers);
        server.requestHandler(router::accept);
        return server;
    }

    private void registerCustomHandlers(Router router) {
        UrlContentHandlers.urlContentHandlers().forEach(urlContentHandler -> router.get(urlContentHandler.url()).handler(ctx -> ctx.response().end(urlContentHandler.buildContent((RoutingContext)ctx, this.reactJsBundle))));
    }

    private void registerPagesHandler(Router router, StaticHandler pagesStaticHandler) {
        router.get("/*").handler(ctx -> {
            if (DocumentationServer.needToEndWithTrailingSlash(ctx)) {
                this.redirectToTrailingSlash((RoutingContext)ctx);
                return;
            }
            String docId = DocumentationServer.extractDocId(ctx);
            if (DocumentationPreparationHandlers.isReady(docId)) {
                pagesStaticHandler.handle(ctx);
            } else if (DocumentationServer.isNotDocPageRequest(ctx)) {
                this.vertx.executeBlocking(future -> {
                    DocumentationPreparationHandlers.prepare(docId, NoOpDocumentationPreparationProgress.INSTANCE);
                    future.complete();
                }, false, res -> pagesStaticHandler.handle(ctx));
            } else {
                this.serveDocumentationPreparationPage((RoutingContext)ctx, docId);
            }
        });
    }

    private void redirectToTrailingSlash(RoutingContext ctx) {
        ctx.response().putHeader("location", ctx.request().uri() + "/").setStatusCode(301).end();
    }

    private void serveDocumentationPreparationPage(RoutingContext ctx, String docId) {
        HtmlReactJsPage htmlReactJsPage = new HtmlReactJsPage(this.reactJsBundle);
        LinkedHashMap<String, Object> props = new LinkedHashMap<String, Object>();
        props.put("docId", docId);
        props.put("statusMessage", "checking documentation cache");
        props.put("progressPercent", 0);
        props.put("keyValues", Collections.emptyList());
        HtmlPage htmlPage = htmlReactJsPage.create("Preparing " + docId, "DocumentationPreparationScreen", props, () -> "", "/static/favicon/default.png");
        ctx.response().end(htmlPage.render(docId));
    }

    private static boolean needToEndWithTrailingSlash(RoutingContext ctx) {
        if (DocumentationServer.isNotDocPageRequest(ctx)) {
            return false;
        }
        return !ctx.request().uri().endsWith("/");
    }

    private static String extractDocId(RoutingContext ctx) {
        String uri = ctx.request().uri();
        String[] parts = uri.split("/");
        return parts.length < 2 ? "" : parts[1];
    }

    private static boolean isNotDocPageRequest(RoutingContext ctx) {
        String uri = ctx.request().uri();
        int dotIdx = uri.lastIndexOf(46);
        if (dotIdx == -1) {
            return false;
        }
        int slashIdx = uri.lastIndexOf(47);
        if (slashIdx > dotIdx) {
            return false;
        }
        String extension = uri.substring(dotIdx);
        return !extension.equals("html");
    }

    private void deleteCachedDocumentation(String docId, String actor) {
        Path docPath = this.deployRoot.resolve(docId);
        ConsoleOutputs.out(new Object[]{Color.BLUE, "deleting docs: ", Color.PURPLE, docId, Color.BLACK, " at ", Color.PURPLE, docPath});
        try {
            File docDirectory = docPath.toFile();
            if (docDirectory.exists()) {
                znaishaded.org.apache.commons.io.FileUtils.deleteDirectory(docDirectory);
            }
            ConsoleOutputs.out(new Object[]{Color.BLUE, "deleted docs: ", Color.PURPLE, docPath});
        }
        catch (IOException e) {
            ConsoleOutputs.out(new Object[]{Color.BLUE, "failed to delete docs: ", Color.PURPLE, docPath});
        }
    }

    private void unzip(String docId, Path path2, String actor) {
        Path unzipDest = this.deployRoot.resolve(docId);
        ConsoleOutputs.out(new Object[]{Color.BLUE, "unzipping docs: ", Color.PURPLE, path2, Color.BLACK, " to ", Color.PURPLE, unzipDest});
        UnzipTask unzipTask = new UnzipTask(this.deployRoot.resolve(path2), unzipDest);
        unzipTask.execute();
        ConsoleOutputs.out(new Object[]{Color.BLUE, "unzipped docs: ", Color.PURPLE, unzipDest});
    }

    public static void main(String[] args) {
        ConsoleOutputs.add(new AnsiConsoleOutput());
        ReactJsBundle reactJsBundle = new ReactJsBundle();
        DocumentationPreparationHandlers.add(new DocumentationPreparationTestHandler());
        LandingDocEntriesProviders.add(() -> Stream.of(new LandingDocEntry("znai", "Znai", "http://custom", "Documentation", "test desc")));
        UrlContentHandlers.add(new LandingUrlContentHandler("Company", "Guides"));
        HttpServer server = new DocumentationServer(reactJsBundle, Paths.get("", new String[0])).create();
        server.listen(3333);
        System.out.println("test server started");
    }
}

