/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.server.preview;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.file.Path;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.server.DocumentationServer;
import org.testingisdocumenting.znai.server.preview.FileWatcher;
import org.testingisdocumenting.znai.server.preview.PreviewPushFileChangeHandler;
import org.testingisdocumenting.znai.server.preview.PreviewWebSocketHandler;
import org.testingisdocumenting.znai.website.WebSite;
import znaishaded.io.vertx.core.http.HttpServer;

public class DocumentationPreview {
    private final Path deployRoot;

    public DocumentationPreview(Path deployRoot) {
        this.deployRoot = deployRoot;
    }

    public void start(WebSite webSite, int port2) {
        DocumentationServer documentationServer = new DocumentationServer(webSite.getReactJsBundle(), this.deployRoot);
        PreviewWebSocketHandler previewWebSocketHandler = new PreviewWebSocketHandler();
        documentationServer.addSocketHandler(previewWebSocketHandler);
        HttpServer server = documentationServer.create();
        this.reportPhase("starting server");
        PreviewPushFileChangeHandler fileChangeHandler = new PreviewPushFileChangeHandler(previewWebSocketHandler, webSite);
        server.listen(port2);
        this.reportPhase("initializing file watcher");
        FileWatcher fileWatcher = new FileWatcher(webSite.getCfg(), webSite.getAuxiliaryFilesRegistry().getAllPaths(), fileChangeHandler);
        this.reportHost(port2);
        webSite.getAuxiliaryFilesRegistry().registerListener(fileWatcher);
        fileWatcher.start();
    }

    private void reportHost(int port2) {
        try {
            ConsoleOutputs.out("http://", InetAddress.getLocalHost().getHostName(), ":", port2, "/preview");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    private void reportPhase(String phase) {
        ConsoleOutputs.out(new Object[]{Color.BLUE, phase});
    }
}

