/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.web;

import java.nio.file.Path;
import org.testingisdocumenting.znai.utils.FileUtils;
import org.testingisdocumenting.znai.utils.ResourceUtils;

public class WebResource {
    private final Path originPath;
    private final String path;
    private final byte[] resourceContent;

    private WebResource(Path originPath, String path2) {
        this.originPath = originPath;
        this.path = path2;
        this.resourceContent = null;
    }

    private WebResource(String resourcePath) {
        this.originPath = null;
        this.path = resourcePath;
        this.resourceContent = ResourceUtils.binaryContent(resourcePath);
    }

    private WebResource(String path2, byte[] content) {
        this.originPath = null;
        this.path = path2;
        this.resourceContent = content;
    }

    public static WebResource withPath(String path2) {
        return new WebResource(null, path2);
    }

    public static WebResource withPath(Path originPath, String webPath) {
        return new WebResource(originPath, webPath);
    }

    public static WebResource fromResource(String resourcePath) {
        return new WebResource(resourcePath);
    }

    public static WebResource withTextContent(String path2, String content) {
        return new WebResource(path2, content.getBytes());
    }

    public Path getOriginPath() {
        return this.originPath;
    }

    public String getPath() {
        return this.path;
    }

    public String generateCssLink(String documentationId) {
        return "<link rel=\"stylesheet\" type=\"text/css\" href=\"" + this.pathForHtml(documentationId) + "\">";
    }

    public String generateJavaScriptLink(String documentationId) {
        return "<script type=\"text/javascript\" src=\"" + this.pathForHtml(documentationId) + "\"></script>";
    }

    private String pathForHtml(String documentationId) {
        return "/" + (documentationId.isEmpty() ? "" : documentationId + "/") + this.path;
    }

    public byte[] getBinaryContent() {
        return this.resourceContent == null ? FileUtils.fileBinaryContent(this.originPath) : this.resourceContent;
    }

    public String getTextContent() {
        return new String(this.getBinaryContent());
    }

    public String toString() {
        return (this.resourceContent == null ? "FromDisk" : "FromResource") + "{originPath=" + this.originPath + ", path='" + this.path + '\'' + '}';
    }
}

