/*
 * Decompiled with CFR 0.152.
 */
package smetana.core.amiga;

import h.WithParent;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import smetana.core.Bucket;
import smetana.core.CFunction;
import smetana.core.CFunctionImpl;
import smetana.core.CString;
import smetana.core.HardcodedStruct;
import smetana.core.JUtils;
import smetana.core.MutableDoublePtr;
import smetana.core.OFFSET;
import smetana.core.StructureDefinition;
import smetana.core.UnsupportedC;
import smetana.core.__array_of_cstring__;
import smetana.core.__array_of_integer__;
import smetana.core.__array_of_ptr__;
import smetana.core.__array_of_struct__;
import smetana.core.__ptr__;
import smetana.core.__struct__;
import smetana.core.__struct_impl__;
import smetana.core.amiga.Area;
import smetana.core.amiga.AreaDouble;
import smetana.core.amiga.AreaInt;
import smetana.core.amiga.BucketToAreaFactory;
import smetana.core.amiga.InternalData;
import smetana.core.amiga.StarArrayOfCString;
import smetana.core.amiga.StarArrayOfInteger;
import smetana.core.amiga.StarArrayOfPtr;
import smetana.core.amiga.StarArrayOfStruct;
import smetana.core.amiga.StarStar;
import smetana.core.amiga.StarStruct;

public class StarStructImpl
extends UnsupportedC
implements StarStruct {
    public static int CPT = 0;
    private final int UID = CPT++;
    private final Map<String, Area> fields;
    private final Set<String> inlineFields = new HashSet<String>();
    private final StarStruct parent;
    private final Class theClass;

    public boolean isSameThan(StarStruct starStruct) {
        return this.UID == ((StarStructImpl)starStruct).UID;
    }

    public String toString() {
        return "StarStruct " + this.getUID36() + " " + this.theClass + " " + this.fields.keySet() + " {parent=" + this.parent + "}";
    }

    public Class getRealClass() {
        return this.theClass;
    }

    private int getIndexOf(Area area) {
        int n = 0;
        for (Area area2 : this.fields.values()) {
            if (area2 == area) {
                return n;
            }
            ++n;
        }
        throw new IllegalArgumentException();
    }

    private Area getAreaByIndex(int n) {
        int n2 = 0;
        for (Area area : this.fields.values()) {
            if (n2 == n) {
                return area;
            }
            ++n2;
        }
        throw new IllegalArgumentException();
    }

    public __struct__ getStruct() {
        return new __struct_impl__(this);
    }

    public StarStructImpl(Class clazz, StarStruct starStruct) {
        this.parent = starStruct;
        this.theClass = clazz;
        this.fields = new LinkedHashMap<String, Area>();
        JUtils.LOG("Creation Struct " + this.getUID36());
        if (this.getUID36().equals("1tq")) {
            JUtils.LOG("It's me");
        }
        StructureDefinition structureDefinition = StructureDefinition.from(clazz);
        Map<String, Bucket> map = structureDefinition.getBucketsMap();
        JUtils.LOG("FIELDS = " + clazz + " " + map.keySet());
        for (Map.Entry<String, Bucket> entry : map.entrySet()) {
            Bucket bucket = entry.getValue();
            this.fields.put(bucket.name, BucketToAreaFactory.createArea(bucket, this));
            if (!bucket.inlineStruct() || bucket.functionPointer()) continue;
            this.inlineFields.add(bucket.name);
        }
    }

    public Area getArea(String string) {
        if (!this.fields.containsKey(string)) {
            System.err.println("fields=" + this.fields.keySet());
            throw new IllegalArgumentException("No such field " + string);
        }
        Area area = this.fields.get(string);
        return area;
    }

    public String getUID36() {
        return Integer.toString(this.UID, 36);
    }

    public String getDebug(String string) {
        throw new UnsupportedOperationException();
    }

    public void setInt(String string, int n) {
        AreaInt areaInt = (AreaInt)this.getArea(string);
        areaInt.setInternal(n);
    }

    public void setBoolean(String string, boolean bl) {
        AreaInt areaInt = (AreaInt)this.getArea(string);
        areaInt.setInternal(bl ? 1 : 0);
    }

    public void setDouble(String string, double d) {
        AreaDouble areaDouble = (AreaDouble)this.getArea(string);
        areaDouble.setInternal(d);
    }

    public int getInt(String string) {
        AreaInt areaInt = (AreaInt)this.getArea(string);
        return areaInt.getInternal();
    }

    public double getDouble(String string) {
        AreaDouble areaDouble = (AreaDouble)this.getArea(string);
        return areaDouble.getInternal();
    }

    public boolean getBoolean(String string) {
        AreaInt areaInt = (AreaInt)this.getArea(string);
        if (areaInt == null) {
            return false;
        }
        return areaInt.getInternal() != 0;
    }

    public __ptr__ plus(int n) {
        JUtils.LOG("******************* plus =" + n);
        JUtils.LOG("me=" + this);
        if (this.parent != null) {
            int n2 = ((StarStructImpl)this.parent).getIndexOf(this);
            JUtils.LOG("idx=" + n2);
            Area area = ((StarStructImpl)this.parent).getAreaByIndex(n2 += n);
            JUtils.LOG("result=" + area);
            return (__ptr__)((Object)area);
        }
        throw new UnsupportedOperationException(this.getClass().toString());
    }

    public CString getCString(String string) {
        return (CString)this.getArea(string);
    }

    public __array_of_struct__ getArrayOfStruct(String string) {
        Area area = this.getArea(string);
        if (area instanceof StarArrayOfStruct) {
            return ((StarArrayOfStruct)area).getInternalArray();
        }
        return (__array_of_struct__)area;
    }

    public __array_of_ptr__ getArrayOfPtr(String string) {
        Area area = this.getArea(string);
        if (area instanceof StarStar) {
            return (__array_of_ptr__)((StarStar)area).getArea();
        }
        if (area instanceof StarArrayOfPtr) {
            return ((StarArrayOfPtr)area).getInternalArray();
        }
        return (__array_of_ptr__)area;
    }

    public __array_of_cstring__ getArrayOfCString(String string) {
        Area area = this.getArea(string);
        if (area instanceof StarArrayOfCString) {
            return ((StarArrayOfCString)area).getInternalArray();
        }
        return (__array_of_cstring__)area;
    }

    public __array_of_integer__ getArrayOfInteger(String string) {
        Area area = this.getArea(string);
        if (area instanceof StarArrayOfInteger) {
            return ((StarArrayOfInteger)area).getInternalArray();
        }
        return (__array_of_integer__)area;
    }

    public __struct__ getStruct(String string) {
        if (this.getArea(string) != null && !(this.getArea(string) instanceof __ptr__)) {
            throw new IllegalArgumentException("Issue in getStruct with " + string + " " + this.getArea(string).getClass());
        }
        __ptr__ __ptr__2 = (__ptr__)((Object)this.getArea(string));
        if (__ptr__2 instanceof HardcodedStruct) {
            return (__struct__)((Object)__ptr__2);
        }
        if (!(__ptr__2 instanceof StarStructImpl)) {
            throw new IllegalStateException(string + " " + __ptr__2.getClass().toString());
        }
        if (__ptr__2 instanceof StarStructImpl && !this.inlineFields.contains(string)) {
            throw new IllegalArgumentException(string + " is NOT inline!");
        }
        return new __struct_impl__((StarStructImpl)__ptr__2);
    }

    public __ptr__ getPtr(String string) {
        if (this.getArea(string) != null && !(this.getArea(string) instanceof __ptr__)) {
            throw new IllegalArgumentException("Issue in getStruct with " + string + " " + this.getArea(string).getClass());
        }
        __ptr__ __ptr__2 = (__ptr__)((Object)this.getArea(string));
        if (__ptr__2 == null) {
            return null;
        }
        if (!(__ptr__2 instanceof StarStruct || __ptr__2 instanceof CFunctionImpl || __ptr__2 instanceof CString || __ptr__2 instanceof StarStar || __ptr__2 instanceof StarArrayOfPtr || __ptr__2 instanceof StarArrayOfStruct || __ptr__2 instanceof StarArrayOfInteger || __ptr__2 instanceof MutableDoublePtr)) {
            throw new IllegalStateException(__ptr__2.getClass().toString());
        }
        if (__ptr__2 instanceof StarStructImpl && this.inlineFields.contains(string)) {
            throw new IllegalArgumentException(string + " is inline!");
        }
        return __ptr__2;
    }

    public void setStruct(String string, __struct__ __struct__2) {
        if (__struct__2 == null) {
            throw new IllegalArgumentException();
        }
        if (!this.inlineFields.contains(string)) {
            throw new UnsupportedOperationException("IMPOSSIBLE2 " + string);
        }
        Area area = this.fields.get(string);
        if (area == null) {
            throw new UnsupportedOperationException("IMPOSSIBLE3 " + string);
        }
        if (area instanceof HardcodedStruct) {
            ((HardcodedStruct)((Object)area)).copyDataFrom(__struct__2);
        } else {
            StarStructImpl starStructImpl = (StarStructImpl)area;
            starStructImpl.copyDataFrom(__struct__2);
        }
    }

    public void setCString(String string, CString cString) {
        if (cString == null) {
            this.fields.put(string, null);
        } else {
            this.fields.put(string, cString);
            cString.setMyFather(this);
        }
    }

    public __ptr__ setPtr(String string, __ptr__ __ptr__2) {
        if (__ptr__2 instanceof CFunction) {
            this.fields.put(string, (Area)((Object)__ptr__2));
            return __ptr__2;
        }
        if (this.inlineFields.contains(string)) {
            throw new UnsupportedOperationException("IMPOSSIBLE5 " + string);
        }
        if (__ptr__2 == null) {
            this.fields.put(string, null);
            return null;
        }
        if (__ptr__2 instanceof StarStruct) {
            if (this.inlineFields.contains(string)) {
                throw new UnsupportedOperationException("IMPOSSIBLE1");
            }
            this.fields.put(string, (Area)((Object)__ptr__2));
            return __ptr__2;
        }
        if (__ptr__2 instanceof CString) {
            this.fields.put(string, (Area)((Object)__ptr__2));
            ((CString)__ptr__2).setMyFather(this);
            return __ptr__2;
        }
        if (__ptr__2 instanceof StarArrayOfPtr) {
            this.fields.put(string, (Area)((Object)__ptr__2));
            return __ptr__2;
        }
        if (__ptr__2 instanceof StarArrayOfStruct) {
            this.fields.put(string, (Area)((Object)__ptr__2));
            return __ptr__2;
        }
        if (__ptr__2 instanceof StarStar) {
            this.fields.put(string, (Area)((Object)__ptr__2));
            return __ptr__2;
        }
        if (__ptr__2 instanceof StarArrayOfCString) {
            this.fields.put(string, (Area)((Object)__ptr__2));
            return __ptr__2;
        }
        if (__ptr__2 instanceof MutableDoublePtr) {
            this.fields.put(string, (Area)((Object)__ptr__2));
            return __ptr__2;
        }
        if (__ptr__2 instanceof StarArrayOfInteger) {
            this.fields.put(string, (Area)((Object)__ptr__2));
            return __ptr__2;
        }
        throw new UnsupportedOperationException("en cours1 ! " + __ptr__2.getClass());
    }

    public void memcopyFrom(Area area) {
        if (area instanceof StarArrayOfPtr) {
            __array_of_ptr__ __array_of_ptr__2 = ((StarArrayOfPtr)area).getInternalArray();
            this.copyDataFrom((StarStructImpl)__array_of_ptr__2.getInternal(0));
        } else if (area instanceof __struct__) {
            this.copyDataFrom((__struct__)area);
        } else {
            this.copyDataFrom((StarStructImpl)area);
        }
    }

    public void copyDataFrom(__struct__ __struct__2) {
        this.copyDataFrom(__struct__2.getInternalData());
    }

    public void setStruct(__struct__ __struct__2) {
        this.copyDataFrom(__struct__2);
    }

    public void copyDataFrom(__ptr__ __ptr__2) {
        JUtils.LOG("copyDataFrom I AM " + this);
        JUtils.LOG("other=" + __ptr__2);
        JUtils.LOG("FIELDS=" + this.fields.keySet());
        if (__ptr__2 instanceof InternalData) {
            this.copyDataFromInternal((InternalData)((Object)__ptr__2));
            return;
        }
        if (this.getClass() != __ptr__2.getClass()) {
            throw new UnsupportedOperationException(this.getClass().toString());
        }
        StarStructImpl starStructImpl = (StarStructImpl)__ptr__2;
        if (!this.fields.keySet().equals(starStructImpl.fields.keySet())) {
            throw new IllegalStateException();
        }
        this.copyDataFromInternal(starStructImpl);
    }

    private void copyDataFromInternal(InternalData internalData) {
        for (String string : new TreeSet<String>(this.fields.keySet())) {
            Area area = this.fields.get(string);
            Area area2 = internalData.getArea(string);
            if (area == null && area2 == null) continue;
            if (area == null) {
                if (area2 instanceof StarStructImpl && !this.inlineFields.contains(string)) {
                    this.fields.put(string, area2);
                    continue;
                }
                if (area2 instanceof CString) {
                    this.fields.put(string, area2);
                    continue;
                }
                if (area2 instanceof StarStar) {
                    this.fields.put(string, area2);
                    continue;
                }
                if (area2 instanceof StarArrayOfPtr) {
                    this.fields.put(string, area2);
                    continue;
                }
                if (area2 instanceof CFunction) {
                    this.fields.put(string, area2);
                    continue;
                }
                if (area2 instanceof StarArrayOfStruct) {
                    this.fields.put(string, area2);
                    continue;
                }
                System.err.println("XX otherField = " + area2);
                throw new UnsupportedOperationException(area2.getClass().toString());
            }
            if (area instanceof AreaInt) {
                area.memcopyFrom(area2);
                continue;
            }
            if (area instanceof AreaDouble) {
                area.memcopyFrom(area2);
                continue;
            }
            if (area instanceof CString) {
                area.memcopyFrom(area2);
                continue;
            }
            if (area instanceof StarStar) {
                if (area2 == null) {
                    this.fields.put(string, null);
                    continue;
                }
                area.memcopyFrom(area2);
                continue;
            }
            if (area instanceof StarStructImpl && this.inlineFields.contains(string)) {
                area.memcopyFrom(area2);
                continue;
            }
            if (area instanceof StarStructImpl && !this.inlineFields.contains(string)) {
                this.fields.put(string, area2);
                continue;
            }
            if (area instanceof StarArrayOfPtr) {
                area.memcopyFrom(area2);
                continue;
            }
            if (area instanceof HardcodedStruct) {
                area.memcopyFrom(area2);
                continue;
            }
            System.err.println("fieldName=" + string + " " + area);
            System.err.println("otherField = " + area2);
            throw new UnsupportedOperationException(area.getClass().toString());
        }
    }

    public Object call(String string, Object ... objectArray) {
        CFunction cFunction = (CFunction)((Object)this.getArea(string));
        return cFunction.exe(objectArray);
    }

    public __ptr__ castTo(Class clazz) {
        Object object;
        JUtils.LOG("******************* castTo =" + clazz);
        JUtils.LOG("me=" + this);
        if (this.theClass == clazz) {
            return this;
        }
        if (this.parent != null && ((StarStructImpl)this.parent).theClass == clazz) {
            JUtils.LOG("IT's my father!");
            return this.parent;
        }
        Area area = this.fields.values().iterator().next();
        JUtils.LOG("first=" + area);
        if (area instanceof StarStructImpl) {
            object = (StarStructImpl)area;
            JUtils.LOG("first.parent=" + ((StarStructImpl)object).parent);
            if (((StarStructImpl)object).parent != this) {
                throw new IllegalStateException();
            }
            if (clazz == ((StarStructImpl)object).theClass) {
                return object;
            }
        }
        if (area instanceof WithParent) {
            object = (WithParent)((Object)area);
            JUtils.LOG("first.parent=" + object.getParent());
            if (object.getParent() != this) {
                throw new IllegalStateException();
            }
            return (__ptr__)object;
        }
        throw new UnsupportedOperationException("first=" + area.getClass());
    }

    public Object addVirtualBytes(int n) {
        JUtils.LOG("#### addVirtualBytes " + n);
        if (n == 0) {
            return this;
        }
        JUtils.LOG("this=" + this.toString());
        if (n < 0) {
            OFFSET oFFSET = OFFSET.fromInt(-n);
            JUtils.LOG("OFFSET1=" + oFFSET);
            if (this.parent == null) {
                throw new UnsupportedOperationException("No father! How to go back?");
            }
            JUtils.LOG("father=" + this.parent);
            if (((StarStructImpl)this.parent).theClass != oFFSET.getTheClass()) {
                throw new UnsupportedOperationException("Bad class matching1!");
            }
            Object object = this.parent.addVirtualBytes(-n);
            JUtils.LOG("checking=" + object);
            if (object != this) {
                throw new UnsupportedOperationException("Cheking fail!");
            }
            return this.parent;
        }
        OFFSET oFFSET = OFFSET.fromInt(n);
        JUtils.LOG("OFFSET2=" + oFFSET);
        String string = oFFSET.getField();
        JUtils.LOG("field=" + string);
        JUtils.LOG("fields=" + this.fields.keySet());
        Area area = this.fields.get(string);
        if (area == null && this.parent != null) {
            return this.parent.addVirtualBytes(n);
        }
        if (area == null) {
            throw new UnsupportedOperationException();
        }
        return area;
    }
}

