/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.fasterxml.jackson.dataformat.xml.deser;

import java.io.IOException;
import znaishaded.com.fasterxml.jackson.core.JsonParser;
import znaishaded.com.fasterxml.jackson.core.JsonToken;
import znaishaded.com.fasterxml.jackson.databind.DeserializationContext;
import znaishaded.com.fasterxml.jackson.databind.JsonMappingException;
import znaishaded.com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import znaishaded.com.fasterxml.jackson.databind.jsontype.TypeDeserializer;

public class XmlStringDeserializer
extends StdScalarDeserializer<String> {
    private static final long serialVersionUID = 1L;

    public XmlStringDeserializer() {
        super(String.class);
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public Object getEmptyValue(DeserializationContext ctxt) throws JsonMappingException {
        return "";
    }

    @Override
    public String deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        if (p.hasToken(JsonToken.VALUE_STRING)) {
            return p.getText();
        }
        JsonToken t = p.getCurrentToken();
        if (t == JsonToken.START_ARRAY) {
            return (String)this._deserializeFromArray(p, ctxt);
        }
        if (t == JsonToken.VALUE_EMBEDDED_OBJECT) {
            Object ob = p.getEmbeddedObject();
            if (ob == null) {
                return null;
            }
            if (ob instanceof byte[]) {
                return ctxt.getBase64Variant().encode((byte[])ob, false);
            }
            return ob.toString();
        }
        String text = p.getValueAsString(null);
        if (text != null || t == JsonToken.VALUE_NULL) {
            return text;
        }
        return (String)ctxt.handleUnexpectedToken(this._valueClass, p);
    }

    @Override
    public String deserializeWithType(JsonParser p, DeserializationContext ctxt, TypeDeserializer typeDeserializer) throws IOException {
        return this.deserialize(p, ctxt);
    }
}

