/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.google.zxing.common.reedsolomon;

import java.util.Vector;
import znaishaded.com.google.zxing.common.reedsolomon.GF256;
import znaishaded.com.google.zxing.common.reedsolomon.GF256Poly;

public final class ReedSolomonEncoder {
    private final GF256 field;
    private final Vector cachedGenerators;

    public ReedSolomonEncoder(GF256 gF256) {
        if (!GF256.QR_CODE_FIELD.equals(gF256)) {
            throw new IllegalArgumentException("Only QR Code is supported at this time");
        }
        this.field = gF256;
        this.cachedGenerators = new Vector();
        this.cachedGenerators.addElement(new GF256Poly(gF256, new int[]{1}));
    }

    private GF256Poly buildGenerator(int n) {
        if (n >= this.cachedGenerators.size()) {
            GF256Poly gF256Poly = (GF256Poly)this.cachedGenerators.elementAt(this.cachedGenerators.size() - 1);
            for (int i = this.cachedGenerators.size(); i <= n; ++i) {
                GF256Poly gF256Poly2 = gF256Poly.multiply(new GF256Poly(this.field, new int[]{1, this.field.exp(i - 1)}));
                this.cachedGenerators.addElement(gF256Poly2);
                gF256Poly = gF256Poly2;
            }
        }
        return (GF256Poly)this.cachedGenerators.elementAt(n);
    }

    public void encode(int[] nArray, int n) {
        if (n == 0) {
            throw new IllegalArgumentException("No error correction bytes");
        }
        int n2 = nArray.length - n;
        if (n2 <= 0) {
            throw new IllegalArgumentException("No data bytes provided");
        }
        GF256Poly gF256Poly = this.buildGenerator(n);
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        GF256Poly gF256Poly2 = new GF256Poly(this.field, nArray2);
        gF256Poly2 = gF256Poly2.multiplyByMonomial(n, 1);
        GF256Poly gF256Poly3 = gF256Poly2.divide(gF256Poly)[1];
        int[] nArray3 = gF256Poly3.getCoefficients();
        int n3 = n - nArray3.length;
        for (int i = 0; i < n3; ++i) {
            nArray[n2 + i] = 0;
        }
        System.arraycopy(nArray3, 0, nArray, n2 + n3, nArray3.length);
    }
}

