/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import java.util.Queue;
import znaishaded.io.netty.buffer.ByteBuf;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.netty.channel.ChannelInboundHandlerAdapter;
import znaishaded.io.netty.channel.ChannelPipeline;
import znaishaded.io.netty.handler.codec.http.DefaultFullHttpResponse;
import znaishaded.io.netty.handler.codec.http.DefaultHttpContent;
import znaishaded.io.netty.handler.codec.http.DefaultHttpHeaders;
import znaishaded.io.netty.handler.codec.http.DefaultHttpRequest;
import znaishaded.io.netty.handler.codec.http.DefaultLastHttpContent;
import znaishaded.io.netty.handler.codec.http.FullHttpResponse;
import znaishaded.io.netty.handler.codec.http.HttpContent;
import znaishaded.io.netty.handler.codec.http.HttpContentDecompressor;
import znaishaded.io.netty.handler.codec.http.HttpHeaderNames;
import znaishaded.io.netty.handler.codec.http.HttpRequest;
import znaishaded.io.netty.handler.codec.http.HttpResponse;
import znaishaded.io.netty.handler.codec.http.HttpResponseStatus;
import znaishaded.io.netty.handler.codec.http.HttpUtil;
import znaishaded.io.netty.handler.codec.http.LastHttpContent;
import znaishaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import znaishaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import znaishaded.io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import znaishaded.io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import znaishaded.io.netty.handler.codec.http.websocketx.WebSocketVersion;
import znaishaded.io.netty.util.ReferenceCountUtil;
import znaishaded.io.netty.util.concurrent.GenericFutureListener;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Context;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.VertxException;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.http.HttpClientOptions;
import znaishaded.io.vertx.core.http.HttpHeaders;
import znaishaded.io.vertx.core.http.HttpMethod;
import znaishaded.io.vertx.core.http.HttpVersion;
import znaishaded.io.vertx.core.http.WebSocket;
import znaishaded.io.vertx.core.http.WebsocketRejectedException;
import znaishaded.io.vertx.core.http.WebsocketVersion;
import znaishaded.io.vertx.core.http.impl.AssembledFullHttpRequest;
import znaishaded.io.vertx.core.http.impl.AssembledHttpRequest;
import znaishaded.io.vertx.core.http.impl.HeadersAdaptor;
import znaishaded.io.vertx.core.http.impl.Http1xConnectionBase;
import znaishaded.io.vertx.core.http.impl.HttpClientConnection;
import znaishaded.io.vertx.core.http.impl.HttpClientImpl;
import znaishaded.io.vertx.core.http.impl.HttpClientRequestImpl;
import znaishaded.io.vertx.core.http.impl.HttpClientResponseImpl;
import znaishaded.io.vertx.core.http.impl.HttpClientStream;
import znaishaded.io.vertx.core.http.impl.HttpUtils;
import znaishaded.io.vertx.core.http.impl.WebSocketImpl;
import znaishaded.io.vertx.core.http.impl.pool.ConnectionListener;
import znaishaded.io.vertx.core.http.impl.ws.WebSocketFrameInternal;
import znaishaded.io.vertx.core.impl.ContextImpl;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.core.net.NetSocket;
import znaishaded.io.vertx.core.net.impl.ConnectionBase;
import znaishaded.io.vertx.core.net.impl.NetSocketImpl;
import znaishaded.io.vertx.core.net.impl.VertxNetHandler;
import znaishaded.io.vertx.core.spi.metrics.HttpClientMetrics;

class Http1xClientConnection
extends Http1xConnectionBase
implements HttpClientConnection {
    private static final Logger log = LoggerFactory.getLogger(Http1xClientConnection.class);
    private final ConnectionListener<HttpClientConnection> listener;
    private final HttpClientImpl client;
    private final HttpClientOptions options;
    private final boolean ssl;
    private final String peerHost;
    private final String host;
    private final int port;
    private final Object endpointMetric;
    private final HttpClientMetrics metrics;
    private final HttpVersion version;
    private WebSocketClientHandshaker handshaker;
    private WebSocketImpl ws;
    private final Deque<StreamImpl> pending = new ArrayDeque<StreamImpl>();
    private final Deque<StreamImpl> inflight = new ArrayDeque<StreamImpl>();
    private StreamImpl currentRequest;
    private StreamImpl currentResponse;
    private boolean paused;
    private Buffer pausedChunk;
    private boolean initialized;
    private int keepAliveTimeout;

    Http1xClientConnection(ConnectionListener<HttpClientConnection> listener, HttpVersion version, HttpClientImpl client, Object endpointMetric, ChannelHandlerContext channel2, boolean ssl, String peerHost, String host, int port2, ContextImpl context, HttpClientMetrics metrics) {
        super(client.getVertx(), channel2, context);
        this.listener = listener;
        this.client = client;
        this.options = client.getOptions();
        this.ssl = ssl;
        this.peerHost = peerHost;
        this.host = host;
        this.port = port2;
        this.metrics = metrics;
        this.version = version;
        this.endpointMetric = endpointMetric;
        this.keepAliveTimeout = this.options.getKeepAliveTimeout();
    }

    @Override
    public ChannelHandlerContext channelHandlerContext() {
        return this.chctx;
    }

    Object endpointMetric() {
        return this.endpointMetric;
    }

    ConnectionListener<HttpClientConnection> listener() {
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleResponse(HttpResponse resp) {
        HttpClientRequestImpl request;
        HttpClientResponseImpl response;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            StreamImpl requestForResponse = resp.status().code() == 100 ? this.inflight.peek() : this.inflight.poll();
            if (requestForResponse == null) {
                throw new IllegalStateException("No response handler");
            }
            this.currentResponse = requestForResponse;
            response = this.currentResponse.beginResponse(resp);
            request = this.currentResponse.request;
        }
        if (response != null) {
            request.handleResponse(response);
        } else {
            request.handleException(new IllegalStateException("Unsupported HTTP version: " + resp.protocolVersion()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleResponseChunk(Buffer buff) {
        HttpClientResponseImpl resp;
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (this.paused) {
                if (this.pausedChunk == null) {
                    this.pausedChunk = buff.copy();
                } else {
                    this.pausedChunk.appendBuffer(buff);
                }
                return;
            }
            if (this.pausedChunk != null) {
                buff = this.pausedChunk.appendBuffer(buff);
                this.pausedChunk = null;
            }
            if ((resp = this.currentResponse.response) == null) {
                return;
            }
        }
        resp.handleChunk(buff);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleResponseEnd(LastHttpContent trailer) {
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            StreamImpl resp = this.currentResponse;
            this.currentResponse = null;
            if (resp.response == null || resp.response.statusCode() != 100) {
                resp.endResponse(trailer);
            }
        }
    }

    @Override
    public HttpClientMetrics metrics() {
        return this.metrics;
    }

    synchronized void toWebSocket(String requestURI, MultiMap headers, WebsocketVersion vers, String subProtocols, int maxWebSocketFrameSize, Handler<WebSocket> wsConnect) {
        if (this.ws != null) {
            throw new IllegalStateException("Already websocket");
        }
        try {
            DefaultHttpHeaders nettyHeaders;
            URI wsuri = new URI(requestURI);
            if (!wsuri.isAbsolute()) {
                wsuri = new URI((this.ssl ? "https:" : "http:") + "//" + this.host + ":" + this.port + requestURI);
            }
            WebSocketVersion version = WebSocketVersion.valueOf((vers == null ? WebSocketVersion.V13 : vers).toString());
            if (headers != null) {
                nettyHeaders = new DefaultHttpHeaders();
                for (Map.Entry entry : headers) {
                    ((znaishaded.io.netty.handler.codec.http.HttpHeaders)nettyHeaders).add((String)entry.getKey(), entry.getValue());
                }
            } else {
                nettyHeaders = null;
            }
            this.handshaker = WebSocketClientHandshakerFactory.newHandshaker(wsuri, version, subProtocols, false, nettyHeaders, maxWebSocketFrameSize, !this.options.isSendUnmaskedFrames(), false);
            ChannelPipeline p = this.chctx.pipeline();
            p.addBefore("handler", "handshakeCompleter", new HandshakeInboundHandler(wsConnect, version != WebSocketVersion.V00));
            this.handshaker.handshake(this.chctx.channel()).addListener((GenericFutureListener<? extends znaishaded.io.netty.util.concurrent.Future<? super Void>>)((GenericFutureListener<znaishaded.io.netty.util.concurrent.Future>)future -> {
                Handler<Throwable> handler = this.exceptionHandler();
                if (!future.isSuccess() && handler != null) {
                    handler.handle(future.cause());
                }
            }));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public synchronized void handleInterestedOpsChanged() {
        if (!this.isNotWritable()) {
            if (this.currentRequest != null) {
                this.currentRequest.request.handleDrained();
            } else if (this.ws != null) {
                this.ws.writable();
            }
        }
    }

    @Override
    public void doPause() {
        super.doPause();
        this.paused = true;
    }

    @Override
    public void doResume() {
        super.doResume();
        this.paused = false;
        if (this.pausedChunk != null) {
            this.context.runOnContext(v -> {
                if (this.pausedChunk != null) {
                    Buffer chunk = this.pausedChunk;
                    this.pausedChunk = null;
                    this.currentResponse.response.handleChunk(chunk);
                }
            });
        }
    }

    synchronized void handleWsFrame(WebSocketFrameInternal frame) {
        if (this.ws != null) {
            this.ws.handleFrame(frame);
        }
    }

    private void retryPending() {
        StreamImpl stream;
        while ((stream = this.pending.poll()) != null) {
            Handler<AsyncResult<HttpClientStream>> handler = stream.handler;
            this.client.getConnectionForRequest(this.peerHost, this.ssl, this.port, this.host, ar1 -> {
                if (ar1.succeeded()) {
                    HttpClientConnection conn = (HttpClientConnection)ar1.result();
                    conn.createStream(ar2 -> {
                        if (ar2.succeeded()) {
                            handler.handle(Future.succeededFuture(ar2.result()));
                        } else {
                            handler.handle(Future.failedFuture(ar2.cause()));
                        }
                    });
                } else {
                    handler.handle(Future.failedFuture(ar1.cause()));
                }
            });
        }
    }

    @Override
    protected synchronized void handleClosed() {
        super.handleClosed();
        if (this.ws != null) {
            this.ws.handleClosed();
        }
        this.retryPending();
        VertxException e = ConnectionBase.CLOSED_EXCEPTION;
        if (this.metrics != null) {
            for (StreamImpl req : this.inflight) {
                this.metrics.requestReset(req.request.metric());
            }
            if (this.currentResponse != null) {
                this.metrics.requestReset(this.currentResponse.request.metric());
            }
        }
        for (StreamImpl req : this.inflight) {
            if (req == this.currentRequest) continue;
            req.request.handleException(e);
        }
        if (this.currentRequest != null) {
            this.currentRequest.request.handleException(e);
        } else if (this.currentResponse != null && this.currentResponse.response != null) {
            this.currentResponse.response.handleException(e);
        }
    }

    @Override
    public ContextImpl getContext() {
        return super.getContext();
    }

    @Override
    protected synchronized void handleException(Throwable e) {
        super.handleException(e);
        this.retryPending();
        if (this.ws != null) {
            this.ws.handleException(e);
        } else if (this.currentRequest != null) {
            this.currentRequest.request.handleException(e);
        } else {
            StreamImpl req = this.inflight.poll();
            if (req != null) {
                req.request.handleException(e);
            } else if (this.currentResponse != null && this.currentResponse.response != null) {
                this.currentResponse.response.handleException(e);
            }
        }
    }

    @Override
    public synchronized void close() {
        this.listener.onDiscard();
        if (this.handshaker == null) {
            super.close();
        } else {
            this.endReadAndFlush();
            this.handshaker.close(this.chctx.channel(), new CloseWebSocketFrame(true, 0, 1000, null));
        }
    }

    @Override
    public void closeWithPayload(ByteBuf byteBuf) {
        this.listener.onDiscard();
        if (this.handshaker == null) {
            super.close();
        } else {
            this.endReadAndFlush();
            this.handshaker.close(this.chctx.channel(), new CloseWebSocketFrame(true, 0, byteBuf));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createStream(Handler<AsyncResult<HttpClientStream>> handler) {
        StreamImpl stream = new StreamImpl(this, handler);
        Http1xClientConnection http1xClientConnection = this;
        synchronized (http1xClientConnection) {
            if (this.currentRequest != null) {
                this.pending.add(stream);
                return;
            }
            this.currentRequest = stream;
        }
        handler.handle(Future.succeededFuture(this.currentRequest));
    }

    @Override
    public void recycle() {
        long expiration = this.keepAliveTimeout == 0 ? 0L : System.currentTimeMillis() + (long)(this.keepAliveTimeout * 1000);
        this.listener.onRecycle(expiration);
    }

    @Override
    public synchronized boolean checkInitialized() {
        boolean ret = this.initialized;
        this.initialized = true;
        return ret;
    }

    private final class HandshakeInboundHandler
    extends ChannelInboundHandlerAdapter {
        private final boolean supportsContinuation;
        private final Handler<WebSocket> wsConnect;
        private final ContextImpl context;
        private final Queue<Object> buffered = new ArrayDeque<Object>();
        private FullHttpResponse response;
        private boolean handshaking = true;

        public HandshakeInboundHandler(Handler<WebSocket> wsConnect, boolean supportsContinuation) {
            this.supportsContinuation = supportsContinuation;
            this.wsConnect = wsConnect;
            this.context = Http1xClientConnection.this.vertx.getContext();
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            super.channelInactive(ctx);
            if (this.handshaking) {
                this.handleException(new WebSocketHandshakeException("Connection closed while handshake in process"));
            }
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (Http1xClientConnection.this.handshaker != null && this.handshaking) {
                if (msg instanceof HttpResponse) {
                    HttpResponse resp = (HttpResponse)msg;
                    HttpResponseStatus status = resp.status();
                    if (status.code() != 101) {
                        Http1xClientConnection.this.handshaker = null;
                        Http1xClientConnection.this.close();
                        this.handleException(new WebsocketRejectedException(status.code()));
                        return;
                    }
                    this.response = new DefaultFullHttpResponse(resp.protocolVersion(), status);
                    this.response.headers().add(resp.headers());
                }
                if (msg instanceof HttpContent && this.response != null) {
                    this.response.content().writeBytes(((HttpContent)msg).content());
                    if (msg instanceof LastHttpContent) {
                        this.response.trailingHeaders().add(((LastHttpContent)msg).trailingHeaders());
                        try {
                            Object m;
                            this.handshakeComplete(ctx, this.response);
                            Http1xClientConnection.this.chctx.pipeline().remove(this);
                            while ((m = this.buffered.poll()) != null) {
                                ctx.fireChannelRead(m);
                            }
                        }
                        catch (WebSocketHandshakeException e) {
                            Http1xClientConnection.this.close();
                            this.handleException(e);
                        }
                    }
                }
            } else {
                this.buffered.add(msg);
            }
        }

        private void handleException(Exception e) {
            this.handshaking = false;
            this.buffered.clear();
            Handler handler = Http1xClientConnection.this.exceptionHandler();
            if (handler != null) {
                this.context.executeFromIO(() -> handler.handle(e));
            } else {
                log.error((Object)"Error in websocket handshake", e);
            }
        }

        private void handshakeComplete(ChannelHandlerContext ctx, FullHttpResponse response) {
            this.handshaking = false;
            HttpContentDecompressor handler = ctx.pipeline().get(HttpContentDecompressor.class);
            if (handler != null) {
                ctx.pipeline().remove(handler);
            }
            ContextImpl.setContext(this.context);
            WebSocketImpl webSocket = new WebSocketImpl(Http1xClientConnection.this.vertx, Http1xClientConnection.this, this.supportsContinuation, Http1xClientConnection.this.options.getMaxWebsocketFrameSize(), Http1xClientConnection.this.options.getMaxWebsocketMessageSize());
            Http1xClientConnection.this.ws = webSocket;
            Http1xClientConnection.this.handshaker.finishHandshake(Http1xClientConnection.this.chctx.channel(), response);
            Http1xClientConnection.this.ws.subProtocol(Http1xClientConnection.this.handshaker.actualSubprotocol());
            this.context.executeFromIO(() -> {
                log.debug("WebSocket handshake complete");
                if (Http1xClientConnection.this.metrics != null) {
                    webSocket.setMetric(Http1xClientConnection.this.metrics.connected(Http1xClientConnection.this.endpointMetric, Http1xClientConnection.this.metric(), webSocket));
                }
                this.wsConnect.handle(webSocket);
            });
        }
    }

    private static class StreamImpl
    implements HttpClientStream {
        protected final Http1xClientConnection conn;
        protected final Handler<AsyncResult<HttpClientStream>> handler;
        protected HttpClientRequestImpl request;
        private HttpClientResponseImpl response;
        private boolean requestEnded;
        private boolean responseEnded;
        private boolean reset;
        private boolean close;
        private boolean upgraded;

        StreamImpl(Http1xClientConnection conn, Handler<AsyncResult<HttpClientStream>> handler) {
            this.conn = conn;
            this.handler = handler;
        }

        @Override
        public void reportBytesWritten(long numberOfBytes) {
            this.conn.reportBytesWritten(numberOfBytes);
        }

        @Override
        public void reportBytesRead(long numberOfBytes) {
            this.conn.reportBytesRead(numberOfBytes);
        }

        @Override
        public int id() {
            return -1;
        }

        @Override
        public HttpVersion version() {
            return this.conn.version;
        }

        @Override
        public HttpClientConnection connection() {
            return this.conn;
        }

        @Override
        public Context getContext() {
            return this.conn.context;
        }

        private HttpRequest createRequest(HttpVersion version, HttpMethod method, String rawMethod, String uri, MultiMap headers) {
            DefaultHttpRequest request = new DefaultHttpRequest(HttpUtils.toNettyHttpVersion(version), HttpUtils.toNettyHttpMethod(method, rawMethod), uri, false);
            if (headers != null) {
                for (Map.Entry header : headers) {
                    request.headers().add((String)header.getKey(), header.getValue());
                }
            }
            return request;
        }

        private void prepareHeaders(HttpRequest request, String hostHeader, boolean chunked) {
            znaishaded.io.netty.handler.codec.http.HttpHeaders headers = request.headers();
            headers.remove(HttpHeaders.TRANSFER_ENCODING);
            if (!headers.contains(HttpHeaders.HOST)) {
                request.headers().set(HttpHeaders.HOST, (Object)hostHeader);
            }
            if (chunked) {
                HttpUtil.setTransferEncodingChunked(request, true);
            }
            if (this.conn.options.isTryUseCompression() && request.headers().get(HttpHeaders.ACCEPT_ENCODING) == null) {
                request.headers().set(HttpHeaders.ACCEPT_ENCODING, (Object)HttpHeaders.DEFLATE_GZIP);
            }
            if (!this.conn.options.isKeepAlive() && this.conn.options.getProtocolVersion() == HttpVersion.HTTP_1_1) {
                request.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.CLOSE);
            } else if (this.conn.options.isKeepAlive() && this.conn.options.getProtocolVersion() == HttpVersion.HTTP_1_0) {
                request.headers().set(HttpHeaders.CONNECTION, (Object)HttpHeaders.KEEP_ALIVE);
            }
        }

        @Override
        public void writeHead(HttpMethod method, String rawMethod, String uri, MultiMap headers, String hostHeader, boolean chunked, ByteBuf buf, boolean end) {
            this.writeHead(this.conn.version, method, rawMethod, uri, headers, hostHeader, chunked, buf, end);
        }

        protected void writeHead(HttpVersion version, HttpMethod method, String rawMethod, String uri, MultiMap headers, String hostHeader, boolean chunked, ByteBuf buf, boolean end) {
            HttpRequest request = this.createRequest(version, method, rawMethod, uri, headers);
            this.prepareHeaders(request, hostHeader, chunked);
            if (end) {
                request = buf != null ? new AssembledFullHttpRequest(request, buf) : new AssembledFullHttpRequest(request);
            } else if (buf != null) {
                request = new AssembledHttpRequest(request, buf);
            }
            this.conn.writeToChannel(request);
        }

        @Override
        public void writeBuffer(ByteBuf buff, boolean end) {
            if (end) {
                if (buff != null && buff.isReadable()) {
                    this.conn.writeToChannel(new DefaultLastHttpContent(buff, false));
                } else {
                    this.conn.writeToChannel(LastHttpContent.EMPTY_LAST_CONTENT);
                }
            } else if (buff != null) {
                this.conn.writeToChannel(new DefaultHttpContent(buff));
            }
        }

        @Override
        public void writeFrame(int type, int flags, ByteBuf payload) {
            throw new IllegalStateException("Cannot write an HTTP/2 frame over an HTTP/1.x connection");
        }

        @Override
        public void doSetWriteQueueMaxSize(int size) {
            this.conn.doSetWriteQueueMaxSize(size);
        }

        @Override
        public boolean isNotWritable() {
            return this.conn.isNotWritable();
        }

        @Override
        public void doPause() {
            if (!this.responseEnded) {
                this.conn.doPause();
            }
        }

        @Override
        public void doResume() {
            if (!this.responseEnded) {
                this.conn.doResume();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void reset(long code) {
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                if (this.request == null) {
                    throw new IllegalStateException("Sanity check");
                }
                if (!this.reset) {
                    this.reset = true;
                    if (!this.responseEnded) {
                        this.conn.close();
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void beginRequest(HttpClientRequestImpl req) {
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                if (this.conn.currentRequest != this) {
                    throw new IllegalStateException("Connection is already writing another request");
                }
                this.request = req;
                if (this.conn.metrics != null) {
                    Object reqMetric = this.conn.metrics.requestBegin(this.conn.endpointMetric, this.conn.metric(), this.conn.localAddress(), this.conn.remoteAddress(), this.request);
                    this.request.metric(reqMetric);
                }
                this.conn.inflight.add(this.conn.currentRequest);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void endRequest() {
            StreamImpl next;
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                if (this.conn.currentRequest != this) {
                    throw new IllegalStateException("No write in progress");
                }
                if (this.conn.metrics != null) {
                    this.conn.metrics.requestEnd(((Http1xClientConnection)this.conn).currentRequest.request.metric());
                }
                this.requestEnded = true;
                this.checkLifecycle();
                next = this.conn.currentRequest = (StreamImpl)this.conn.pending.poll();
                if (next == null) {
                    return;
                }
            }
            next.handler.handle(Future.succeededFuture(next));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public NetSocket createNetSocket() {
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                if (this.responseEnded) {
                    throw new IllegalStateException("Request already ended");
                }
                if (this.upgraded) {
                    throw new IllegalStateException("Request already upgraded to NetSocket");
                }
                this.upgraded = true;
                NetSocketImpl socket = new NetSocketImpl(this.conn.vertx, this.conn.chctx, this.conn.context, this.conn.client.getSslHelper(), this.conn.metrics);
                socket.metric(this.conn.metric());
                this.conn.endReadAndFlush();
                ChannelPipeline pipeline = this.conn.chctx.pipeline();
                HttpContentDecompressor inflater = pipeline.get(HttpContentDecompressor.class);
                if (inflater != null) {
                    pipeline.remove(inflater);
                }
                pipeline.remove("codec");
                pipeline.replace("handler", "handler", new VertxNetHandler(socket){

                    @Override
                    public void channelRead(ChannelHandlerContext chctx, Object msg) throws Exception {
                        if (msg instanceof HttpContent) {
                            if (msg instanceof LastHttpContent) {
                                this.endResponse((LastHttpContent)msg);
                            }
                            ReferenceCountUtil.release(msg);
                            return;
                        }
                        super.channelRead(chctx, msg);
                    }

                    @Override
                    protected void handleMessage(NetSocketImpl connection, ContextImpl context, ChannelHandlerContext chctx, Object msg) throws Exception {
                        connection.handleMessageReceived(msg);
                    }
                }.removeHandler(sock -> this.conn.listener.onDiscard()));
                return socket;
            }
        }

        HttpClientResponseImpl beginResponse(HttpResponse resp) {
            HttpVersion version;
            if (this.conn.metrics != null) {
                this.conn.metrics.responseBegin(this.request.metric(), this.response);
            }
            if (resp.status().code() != 100 && this.request.method() != HttpMethod.CONNECT) {
                int timeout;
                String responseConnectionHeader = resp.headers().get("Connection");
                znaishaded.io.netty.handler.codec.http.HttpVersion protocolVersion = resp.protocolVersion();
                String requestConnectionHeader = this.request.headers().get("Connection");
                if ("close".equalsIgnoreCase(responseConnectionHeader) || "close".equalsIgnoreCase(requestConnectionHeader)) {
                    this.close = true;
                } else if (protocolVersion == znaishaded.io.netty.handler.codec.http.HttpVersion.HTTP_1_0 && !"keep-alive".equalsIgnoreCase(responseConnectionHeader)) {
                    this.close = true;
                }
                String keepAliveHeader = resp.headers().get(HttpHeaderNames.KEEP_ALIVE);
                if (keepAliveHeader != null && (timeout = HttpUtils.parseKeepAliveHeaderTimeout(keepAliveHeader)) != -1) {
                    this.conn.keepAliveTimeout = timeout;
                }
            }
            if ((version = HttpUtils.toVertxHttpVersion(resp.protocolVersion())) != null) {
                this.response = new HttpClientResponseImpl(this.request, version, this, resp.status().code(), resp.status().reasonPhrase(), new HeadersAdaptor(resp.headers()));
                return this.response;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void endResponse(LastHttpContent trailer) {
            Http1xClientConnection http1xClientConnection = this.conn;
            synchronized (http1xClientConnection) {
                if (this.conn.metrics != null) {
                    HttpClientRequestImpl req = this.request;
                    Object reqMetric = req.metric();
                    if (req.exceptionOccurred != null) {
                        this.conn.metrics.requestReset(reqMetric);
                    } else {
                        this.conn.metrics.responseEnd(reqMetric, this.response);
                    }
                }
                Buffer last = this.conn.pausedChunk;
                this.conn.pausedChunk = null;
                if (this.response != null) {
                    this.response.handleEnd(last, new HeadersAdaptor(trailer.trailingHeaders()));
                }
                this.responseEnded = true;
                this.conn.doResume();
                if (!this.conn.options.isKeepAlive()) {
                    this.close = true;
                }
                this.checkLifecycle();
            }
        }

        void checkLifecycle() {
            if (this.requestEnded && this.responseEnded && !this.upgraded) {
                if (this.close) {
                    this.conn.close();
                } else {
                    this.conn.recycle();
                }
            }
        }
    }
}

