/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.io.File;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import znaishaded.net.sourceforge.plantuml.Option;
import znaishaded.net.sourceforge.plantuml.OptionFlags;
import znaishaded.net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import znaishaded.net.sourceforge.plantuml.syntax.LanguageDescriptor;
import znaishaded.net.sourceforge.plantuml.version.License;
import znaishaded.net.sourceforge.plantuml.version.PSystemVersion;
import znaishaded.net.sourceforge.plantuml.version.Version;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionPrint {
    private static String hostname;

    public static void printTestDot() throws InterruptedException {
        for (String string : GraphvizUtils.getTestDotStrings(false)) {
            System.out.println(string);
        }
        OptionPrint.exit();
    }

    public static void printHelp() throws InterruptedException {
        String string = Charset.defaultCharset().displayName();
        System.out.println("Usage: java -jar plantuml.jar [options] -gui");
        System.out.println("\t(to execute the GUI)");
        System.out.println("    or java -jar plantuml.jar [options] [file/dir] [file/dir] [file/dir]");
        System.out.println("\t(to process files or directories)");
        System.out.println();
        System.out.println("You can use the following wildcards in files/dirs:");
        System.out.println("\t*\tmeans any characters but '" + File.separator + "'");
        System.out.println("\t?\tone and only one character but '" + File.separator + "'");
        System.out.println("\t**\tmeans any characters (used to recurse through directories)");
        System.out.println();
        System.out.println("where options include:");
        System.out.println("    -gui\t\tTo run the graphical user interface");
        System.out.println("    -tpng\t\tTo generate images using PNG format (default)");
        System.out.println("    -tsvg\t\tTo generate images using SVG format");
        System.out.println("    -teps\t\tTo generate images using EPS format");
        System.out.println("    -tpdf\t\tTo generate images using PDF format");
        System.out.println("    -tvdx\t\tTo generate images using VDX format");
        System.out.println("    -txmi\t\tTo generate XMI file for class diagram");
        System.out.println("    -tscxml\t\tTo generate SCXML file for state diagram");
        System.out.println("    -thtml\t\tTo generate HTML file for class diagram");
        System.out.println("    -ttxt\t\tTo generate images with ASCII art");
        System.out.println("    -tutxt\t\tTo generate images with ASCII art using Unicode characters");
        System.out.println("    -tlatex\t\tTo generate images using LaTeX/Tikz format");
        System.out.println("    -tlatex:nopreamble\tTo generate images using LaTeX/Tikz format without preamble");
        System.out.println("    -o[utput] \"dir\"\tTo generate images in the specified directory");
        System.out.println("    -DVAR1=value\tTo set a preprocessing variable as if '!define VAR1 value' were used");
        System.out.println("    -Sparam1=value\tTo set a skin parameter as if 'skinparam param1 value' were used");
        System.out.println("    -r[ecurse]\t\trecurse through directories");
        char c = File.separatorChar;
        System.out.println("    -I" + c + "path" + c + "to" + c + "file\tTo include file as if '!include file' were used");
        System.out.println("    -I" + c + "path" + c + "to" + c + "*.puml\tTo include files with pattern");
        System.out.println("    -charset xxx\tTo use a specific charset (default is " + string + ")");
        System.out.println("    -e[x]clude pattern\tTo exclude files that match the provided pattern");
        System.out.println("    -metadata\t\tTo retrieve PlantUML sources from PNG images");
        System.out.println("    -nometadata\t\tTo NOT export metadata in PNG/SVG generated files");
        System.out.println("    -version\t\tTo display information about PlantUML and Java versions");
        System.out.println("    -checkversion\tTo check if a newer version is available for download");
        System.out.println("    -v[erbose]\t\tTo have log information");
        System.out.println("    -quiet\t\tTo NOT print error message into the console");
        System.out.println("    -debugsvek\t\tTo generate intermediate svek files");
        System.out.println("    -h[elp]\t\tTo display this help message");
        System.out.println("    -testdot\t\tTo test the installation of graphviz");
        System.out.println("    -graphvizdot \"exe\"\tTo specify dot executable");
        System.out.println("    -p[ipe]\t\tTo use stdin for PlantUML source and stdout for PNG/SVG/EPS generation");
        System.out.println("    -encodesprite 4|8|16[z] \"file\"\tTo encode a sprite at gray level (z for compression) from an image");
        System.out.println("    -computeurl|-encodeurl\tTo compute the encoded URL of a PlantUML source file");
        System.out.println("    -decodeurl\t\tTo retrieve the PlantUML source from an encoded URL");
        System.out.println("    -syntax\t\tTo report any syntax error from standard input without generating images");
        System.out.println("    -language\t\tTo print the list of PlantUML keywords");
        System.out.println("    -nosuggestengine\tTo disable the suggest engine when errors in diagrams");
        System.out.println("    -checkonly\t\tTo check the syntax of files without generating images");
        System.out.println("    -failfast\t\tTo stop processing as soon as a syntax error in diagram occurs");
        System.out.println("    -failfast2\t\tTo do a first syntax check before processing files, to fail even faster");
        System.out.println("    -pattern\t\tTo print the list of Regular Expression used by PlantUML");
        System.out.println("    -duration\t\tTo print the duration of complete diagrams processing");
        System.out.println("    -nbthread N\t\tTo use (N) threads for processing");
        System.out.println("    -nbthread auto\tTo use " + Option.defaultNbThreads() + " threads for processing");
        System.out.println("    -timeout N\t\tProcessing timeout in (N) seconds. Defaults to 15 minutes (900 seconds).");
        System.out.println("    -author[s]\t\tTo print information about PlantUML authors");
        System.out.println("    -overwrite\t\tTo allow to overwrite read only files");
        System.out.println("    -printfonts\t\tTo print fonts available on your system");
        System.out.println("    -enablestats\tTo enable statistics computation");
        System.out.println("    -disablestats\tTo disable statistics computation (default)");
        System.out.println("    -htmlstats\t\tTo output general statistics in file plantuml-stats.html");
        System.out.println("    -xmlstats\t\tTo output general statistics in file plantuml-stats.xml");
        System.out.println("    -realtimestats\tTo generate statistics on the fly rather than at the end");
        System.out.println("    -loopstats\t\tTo continuously print statistics about usage");
        System.out.println("    -splash\t\tTo display a splash screen with some progress bar");
        System.out.println("    -progress\t\tTo display a textual progress bar in console");
        System.out.println("    -pipeimageindex N\tTo generate the Nth image with pipe option");
        System.out.println();
        System.out.println("If needed, you can setup the environment variable GRAPHVIZ_DOT.");
        OptionPrint.exit();
    }

    private static void exit() throws InterruptedException {
        if (OptionFlags.getInstance().isSystemExit()) {
            System.exit(0);
        }
        throw new InterruptedException("exit");
    }

    public static void printLicense() throws InterruptedException {
        for (String string : License.getCurrent().getText()) {
            System.out.println(string);
        }
        OptionPrint.exit();
    }

    public static void printVersion() throws InterruptedException {
        System.out.println("PlantUML version " + Version.versionString() + " (" + Version.compileTimeString() + ")");
        System.out.println("(" + (Object)((Object)License.getCurrent()) + " source distribution)");
        for (String string : OptionPrint.interestingProperties()) {
            System.out.println(string);
        }
        for (String string : OptionPrint.interestingValues()) {
            System.out.println(string);
        }
        System.out.println();
        for (String string : GraphvizUtils.getTestDotStrings(false)) {
            System.out.println(string);
        }
        OptionPrint.exit();
    }

    public static Collection<String> interestingProperties() {
        Properties properties = System.getProperties();
        List<String> list = OptionPrint.withIp() ? Arrays.asList("java.runtime.name", "Java Runtime", "java.vm.name", "JVM", "java.runtime.version", "Java Version", "os.name", "Operating System", "file.encoding", "Default Encoding", "user.language", "Language", "user.country", "Country") : Arrays.asList("java.runtime.name", "Java Runtime", "java.vm.name", "JVM", "java.runtime.version", "Java Version", "os.name", "Operating System", "os.version", "OS Version", "file.encoding", "Default Encoding", "user.language", "Language", "user.country", "Country");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); i += 2) {
            arrayList.add(list.get(i + 1) + ": " + properties.getProperty(list.get(i)));
        }
        return arrayList;
    }

    public static Collection<String> interestingValues() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!OptionPrint.withIp()) {
            arrayList.add("Machine: " + OptionPrint.getHostName());
        }
        arrayList.add("PLANTUML_LIMIT_SIZE: " + GraphvizUtils.getenvImageLimit());
        arrayList.add("Processors: " + Runtime.getRuntime().availableProcessors());
        long l = Runtime.getRuntime().freeMemory();
        long l2 = Runtime.getRuntime().maxMemory();
        long l3 = Runtime.getRuntime().totalMemory();
        long l4 = l3 - l;
        int n = Thread.activeCount();
        arrayList.add("Max Memory: " + OptionPrint.format(l2));
        arrayList.add("Total Memory: " + OptionPrint.format(l3));
        arrayList.add("Free Memory: " + OptionPrint.format(l));
        arrayList.add("Used Memory: " + OptionPrint.format(l4));
        arrayList.add("Thread Active Count: " + n);
        return Collections.unmodifiableCollection(arrayList);
    }

    private static boolean withIp() {
        return OptionPrint.getHostName().startsWith("ip-");
    }

    public static synchronized String getHostName() {
        if (hostname == null) {
            hostname = OptionPrint.getHostNameSlow();
        }
        return hostname;
    }

    private static String getHostNameSlow() {
        try {
            InetAddress inetAddress = InetAddress.getLocalHost();
            return inetAddress.getHostName();
        }
        catch (Throwable throwable) {
            Map<String, String> map = System.getenv();
            if (map.containsKey("COMPUTERNAME")) {
                return map.get("COMPUTERNAME");
            }
            if (map.containsKey("HOSTNAME")) {
                return map.get("HOSTNAME");
            }
            return "Unknown Computer";
        }
    }

    private static String format(long l) {
        return String.format(Locale.US, "%,d", l);
    }

    public static void checkVersion() throws InterruptedException {
        System.out.println("PlantUML version " + Version.versionString() + " (" + Version.compileTimeString() + ")");
        System.out.println();
        int n = PSystemVersion.extractDownloadableVersion(null, null);
        if (n == -1) {
            System.out.println("Error");
            System.out.println("Cannot connect to http://plantuml.com/");
            System.out.println("Maybe you should set your proxy ?");
        } else if (n == 0) {
            System.out.println("Error");
            System.out.println("Cannot retrieve last version from http://plantuml.com/");
        } else {
            System.out.println("Last available version for download : " + n);
            System.out.println();
            if (Version.version() >= n) {
                System.out.println("Your version is up to date.");
            } else {
                System.out.println("A newer version is available for download.");
            }
        }
        OptionPrint.exit();
    }

    public static void printAbout() throws InterruptedException {
        for (String string : PSystemVersion.getAuthorsStrings(false)) {
            System.out.println(string);
        }
        OptionPrint.exit();
    }

    public static void printLanguage() throws InterruptedException {
        new LanguageDescriptor().print(System.out);
        OptionPrint.exit();
    }
}

