/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command.note.sequence;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Note;
import znaishaded.net.sourceforge.plantuml.sequencediagram.NoteStyle;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactorySequenceNoteOverSeveralCommand
implements SingleMultiFactoryCommand<SequenceDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("VMERGE", "(/)?[%s]*"), new RegexLeaf("STYLE", "(note|hnote|rnote)[%s]+over[%s]+"), new RegexLeaf("P1", "([\\p{L}0-9_.@]+|[%g][^%g]+[%g])[%s]*\\,[%s]*"), new RegexLeaf("P2", "([\\p{L}0-9_.@]+|[%g][^%g]+[%g])[%s]*"), FactorySequenceNoteOverSeveralCommand.color().getRegex(), new RegexLeaf("URL", "[%s]*(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("VMERGE", "(/)?[%s]*"), new RegexLeaf("STYLE", "(note|hnote|rnote)[%s]+over[%s]+"), new RegexLeaf("P1", "([\\p{L}0-9_.@]+|[%g][^%g]+[%g])[%s]*\\,[%s]*"), new RegexLeaf("P2", "([\\p{L}0-9_.@]+|[%g][^%g]+[%g])[%s]*"), FactorySequenceNoteOverSeveralCommand.color().getRegex(), new RegexLeaf("URL", "[%s]*(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*:[%s]*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    public Command<SequenceDiagram> createSingleLine() {
        return new SingleLineCommand2<SequenceDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(SequenceDiagram sequenceDiagram, RegexResult regexResult) {
                BlocLines blocLines = BlocLines.getWithNewlines(regexResult.get("NOTE", 0));
                return FactorySequenceNoteOverSeveralCommand.this.executeInternal(sequenceDiagram, regexResult, blocLines);
            }
        };
    }

    @Override
    public Command<SequenceDiagram> createMultiLine(boolean bl) {
        return new CommandMultilines2<SequenceDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^end[%s]?(note|hnote|rnote)$";
            }

            @Override
            public CommandExecutionResult executeNow(SequenceDiagram sequenceDiagram, BlocLines blocLines) {
                RegexResult regexResult = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
                blocLines = blocLines.subExtract(1, 1);
                blocLines = blocLines.removeEmptyColumns();
                return FactorySequenceNoteOverSeveralCommand.this.executeInternal(sequenceDiagram, regexResult, blocLines);
            }
        };
    }

    private CommandExecutionResult executeInternal(SequenceDiagram sequenceDiagram, RegexResult regexResult, BlocLines blocLines) {
        Participant participant = sequenceDiagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("P1", 0)));
        Participant participant2 = sequenceDiagram.getOrCreateParticipant(StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("P2", 0)));
        if (blocLines.size() > 0) {
            boolean bl = regexResult.get("VMERGE", 0) != null;
            Note note = new Note(participant, participant2, blocLines.toDisplay());
            Colors colors = FactorySequenceNoteOverSeveralCommand.color().getColor(regexResult, sequenceDiagram.getSkinParam().getIHtmlColorSet());
            note.setColors(colors);
            note.setStyle(NoteStyle.getNoteStyle(regexResult.get("STYLE", 0)));
            if (regexResult.get("URL", 0) != null) {
                UrlBuilder urlBuilder = new UrlBuilder(sequenceDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
                Url url = urlBuilder.getUrl(regexResult.get("URL", 0));
                note.setUrl(url);
            }
            sequenceDiagram.addNote(note, bl);
        }
        return CommandExecutionResult.ok();
    }
}

