/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole;

import znaishaded.net.sourceforge.plantuml.command.regex.Matcher2;
import znaishaded.net.sourceforge.plantuml.command.regex.MyPattern;
import znaishaded.net.sourceforge.plantuml.command.regex.Pattern2;
import znaishaded.net.sourceforge.plantuml.creole.Command;
import znaishaded.net.sourceforge.plantuml.creole.StripeSimple;
import znaishaded.net.sourceforge.plantuml.math.ScientificEquationSafe;

public class CommandCreoleMath
implements Command {
    private final Pattern2 pattern;
    private final double scale;

    private CommandCreoleMath(String string, double d) {
        this.pattern = MyPattern.cmpile(string);
        this.scale = d;
    }

    public static Command create(double d) {
        return new CommandCreoleMath("^(?i)(\\<math\\>(.+?)\\</math\\>)", d);
    }

    public int matchingSize(String string) {
        Matcher2 matcher2 = this.pattern.matcher(string);
        if (!matcher2.find()) {
            return 0;
        }
        return matcher2.group(1).length();
    }

    public String executeAndGetRemaining(String string, StripeSimple stripeSimple) {
        Matcher2 matcher2 = this.pattern.matcher(string);
        if (!matcher2.find()) {
            throw new IllegalStateException();
        }
        String string2 = matcher2.group(2);
        stripeSimple.addMath(ScientificEquationSafe.fromAsciiMath(string2), this.scale);
        return string.substring(matcher2.group(1).length());
    }
}

