/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.dedication;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.code.AsciiEncoder;
import znaishaded.net.sourceforge.plantuml.dedication.QBlock;

public class QBlocks {
    private final List<QBlock> all = new ArrayList<QBlock>();

    private QBlocks() {
    }

    public static QBlocks readFrom(InputStream inputStream, int n) throws IOException {
        QBlocks qBlocks = new QBlocks();
        QBlock qBlock;
        while ((qBlock = QBlock.read(inputStream, n)) != null) {
            qBlocks.all.add(qBlock);
        }
        return qBlocks;
    }

    public QBlocks change(BigInteger bigInteger, BigInteger bigInteger2) {
        QBlocks qBlocks = new QBlocks();
        for (QBlock qBlock : this.all) {
            qBlocks.all.add(qBlock.change(bigInteger, bigInteger2));
        }
        return qBlocks;
    }

    public void writeTo(OutputStream outputStream, int n) throws IOException {
        for (QBlock qBlock : this.all) {
            qBlock.write(outputStream, n);
        }
    }

    public String encodeAscii() {
        StringBuilder stringBuilder = new StringBuilder();
        AsciiEncoder asciiEncoder = new AsciiEncoder();
        for (QBlock qBlock : this.all) {
            stringBuilder.append(asciiEncoder.encode(qBlock.getData()));
            stringBuilder.append("!");
        }
        return stringBuilder.toString();
    }

    public static QBlocks descodeAscii(String string) {
        QBlocks qBlocks = new QBlocks();
        AsciiEncoder asciiEncoder = new AsciiEncoder();
        for (String string2 : string.split("!")) {
            BigInteger bigInteger = new BigInteger(asciiEncoder.decode(string2));
            qBlocks.all.add(new QBlock(bigInteger));
        }
        return qBlocks;
    }
}

