/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.geom.Point2DInt;
import znaishaded.net.sourceforge.plantuml.geom.PolylineBreakeable;
import znaishaded.net.sourceforge.plantuml.geom.SpiderWeb;
import znaishaded.net.sourceforge.plantuml.graph.ALink;
import znaishaded.net.sourceforge.plantuml.graph.Board;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Galaxy4 {
    private final Board board;
    private final Map<ALink, PolylineBreakeable> lines = new LinkedHashMap<ALink, PolylineBreakeable>();
    private final SpiderWeb spiderWeb;

    public Galaxy4(Board board, int n, int n2) {
        this.spiderWeb = new SpiderWeb(n, n2);
        this.board = board;
    }

    public Point2DInt getMainPoint(int n, int n2) {
        return this.spiderWeb.getMainPoint(n, n2);
    }

    public PolylineBreakeable getPolyline(ALink aLink) {
        return this.lines.get(aLink);
    }

    public void addLink(ALink aLink) {
        int n = aLink.getNode1().getRow();
        int n2 = aLink.getNode2().getRow();
        int n3 = this.board.getCol(aLink.getNode1());
        int n4 = this.board.getCol(aLink.getNode2());
        PolylineBreakeable polylineBreakeable = this.spiderWeb.addPolyline(n, n3, n2, n4);
        Log.info("link=" + aLink + " polyline=" + polylineBreakeable);
        if (polylineBreakeable == null) {
            Log.info("PENDING " + aLink + " " + polylineBreakeable);
        } else {
            this.lines.put(aLink, polylineBreakeable);
        }
    }

    public final Board getBoard() {
        return this.board;
    }

    public final Map<ALink, PolylineBreakeable> getLines() {
        return Collections.unmodifiableMap(this.lines);
    }
}

