/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.logo;

import java.util.HashMap;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.logo.LogoToken;

class LogoScanner {
    private final Map<String, Integer> keywordTable = new HashMap<String, Integer>();
    private char[] sourceString;
    private int sourceLength;
    private int i;

    public LogoScanner() {
        this.keywordTable.put("forward", new Integer(260));
        this.keywordTable.put("fd", new Integer(260));
        this.keywordTable.put("back", new Integer(261));
        this.keywordTable.put("bk", new Integer(261));
        this.keywordTable.put("right", new Integer(263));
        this.keywordTable.put("rt", new Integer(263));
        this.keywordTable.put("left", new Integer(262));
        this.keywordTable.put("lt", new Integer(262));
        this.keywordTable.put("penup", new Integer(264));
        this.keywordTable.put("pu", new Integer(264));
        this.keywordTable.put("pendown", new Integer(265));
        this.keywordTable.put("pd", new Integer(265));
        this.keywordTable.put("hideturtle", new Integer(266));
        this.keywordTable.put("ht", new Integer(266));
        this.keywordTable.put("showturtle", new Integer(267));
        this.keywordTable.put("st", new Integer(267));
        this.keywordTable.put("clearscreen", new Integer(268));
        this.keywordTable.put("cs", new Integer(268));
        this.keywordTable.put("repeat", new Integer(269));
        this.keywordTable.put("rep", new Integer(269));
        this.keywordTable.put("to", new Integer(271));
        this.keywordTable.put("setpc", new Integer(272));
        this.keywordTable.put("pc", new Integer(272));
    }

    public int getPosition() {
        return this.i;
    }

    public void setPosition(int n) {
        this.i = this.i >= 0 && this.i <= this.sourceLength ? n : this.sourceLength;
    }

    public void setSourceString(String string) {
        this.sourceLength = string.length();
        this.sourceString = string.concat("\u0000").toCharArray();
        this.i = 0;
    }

    public String getSourceString() {
        return new String(this.sourceString);
    }

    public String getRestAsString() {
        this.skipWhitespace();
        String string = new String(this.sourceString, this.i, this.sourceLength - this.i + 1);
        this.i = this.sourceLength;
        return string;
    }

    void skipWhitespace() {
        char c;
        while ((c = this.sourceString[this.i++]) == ' ' || c == '\t') {
        }
        --this.i;
    }

    public LogoToken getToken() {
        LogoToken logoToken = new LogoToken();
        StringBuffer stringBuffer = new StringBuffer();
        if (this.i >= this.sourceLength) {
            logoToken.kind = 256;
            return logoToken;
        }
        this.skipWhitespace();
        char c = this.sourceString[this.i++];
        if (c == '[' || c == ']') {
            logoToken.kind = c;
            logoToken.lexeme = String.valueOf(c);
        } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
            do {
                stringBuffer.append(c);
            } while ((c = this.sourceString[this.i++]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z');
            --this.i;
            logoToken.lexeme = stringBuffer.toString();
            logoToken.kind = 258;
            Integer n = this.keywordTable.get(logoToken.lexeme);
            if (n != null) {
                logoToken.kind = n;
            }
        } else if (c >= '0' && c <= '9') {
            do {
                stringBuffer.append(c);
            } while ((c = this.sourceString[this.i++]) >= '0' && c <= '9');
            boolean bl = false;
            if (c == '.') {
                do {
                    stringBuffer.append(c);
                } while ((c = this.sourceString[this.i++]) >= '0' && c <= '9');
                bl = true;
            }
            --this.i;
            logoToken.lexeme = stringBuffer.toString();
            logoToken.value = Float.valueOf(logoToken.lexeme).floatValue();
            if (bl) {
                logoToken.kind = 259;
            } else {
                logoToken.kind = 270;
                logoToken.intValue = Integer.valueOf(logoToken.lexeme);
            }
        } else if (c == '\u0000') {
            --this.i;
            logoToken.kind = 256;
        } else {
            --this.i;
            logoToken.kind = 257;
        }
        return logoToken;
    }
}

