/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project3;

import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.project3.Complement;
import znaishaded.net.sourceforge.plantuml.project3.ComplementPattern;
import znaishaded.net.sourceforge.plantuml.project3.DayAsDate;
import znaishaded.net.sourceforge.plantuml.project3.Failable;
import znaishaded.net.sourceforge.plantuml.project3.GanttDiagram;
import znaishaded.net.sourceforge.plantuml.project3.Month;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplementDate
implements ComplementPattern {
    @Override
    public IRegex toRegex(String string) {
        return new RegexOr(this.toRegexA(string), this.toRegexB(string), this.toRegexC(string));
    }

    private IRegex toRegexA(String string) {
        return new RegexConcat(new RegexLeaf("ADAY" + string, "([\\d]+)"), new RegexLeaf("[\\w, ]*?"), new RegexLeaf("AMONTH" + string, "(" + Month.getRegexString() + ")"), new RegexLeaf("[\\w, ]*?"), new RegexLeaf("AYEAR" + string, "([\\d]{4})"));
    }

    private IRegex toRegexB(String string) {
        return new RegexConcat(new RegexLeaf("BYEAR" + string, "([\\d]{4})"), new RegexLeaf("\\D"), new RegexLeaf("BMONTH" + string, "([\\d]{1,2})"), new RegexLeaf("\\D"), new RegexLeaf("BDAY" + string, "([\\d]{1,2})"));
    }

    private IRegex toRegexC(String string) {
        return new RegexConcat(new RegexLeaf("CMONTH" + string, "(" + Month.getRegexString() + ")"), new RegexLeaf("[\\w, ]*?"), new RegexLeaf("CDAY" + string, "([\\d]+)"), new RegexLeaf("[\\w, ]*?"), new RegexLeaf("CYEAR" + string, "([\\d]{4})"));
    }

    @Override
    public Failable<Complement> getComplement(GanttDiagram ganttDiagram, RegexResult regexResult, String string) {
        if (regexResult.get("ADAY" + string, 0) != null) {
            return Failable.ok(this.resultA(regexResult, string));
        }
        if (regexResult.get("BDAY" + string, 0) != null) {
            return Failable.ok(this.resultB(regexResult, string));
        }
        if (regexResult.get("CDAY" + string, 0) != null) {
            return Failable.ok(this.resultC(regexResult, string));
        }
        throw new IllegalStateException();
    }

    private Complement resultA(RegexResult regexResult, String string) {
        int n = Integer.parseInt(regexResult.get("ADAY" + string, 0));
        String string2 = regexResult.get("AMONTH" + string, 0);
        int n2 = Integer.parseInt(regexResult.get("AYEAR" + string, 0));
        return DayAsDate.create(n2, string2, n);
    }

    private Complement resultB(RegexResult regexResult, String string) {
        int n = Integer.parseInt(regexResult.get("BDAY" + string, 0));
        int n2 = Integer.parseInt(regexResult.get("BMONTH" + string, 0));
        int n3 = Integer.parseInt(regexResult.get("BYEAR" + string, 0));
        return DayAsDate.create(n3, n2, n);
    }

    private Complement resultC(RegexResult regexResult, String string) {
        int n = Integer.parseInt(regexResult.get("CDAY" + string, 0));
        String string2 = regexResult.get("CMONTH" + string, 0);
        int n2 = Integer.parseInt(regexResult.get("CYEAR" + string, 0));
        return DayAsDate.create(n2, string2, n);
    }
}

