/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.project3;

import znaishaded.net.sourceforge.plantuml.Direction;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.graphic.UDrawable;
import znaishaded.net.sourceforge.plantuml.project3.Arrows;
import znaishaded.net.sourceforge.plantuml.project3.TaskAttribute;
import znaishaded.net.sourceforge.plantuml.project3.TaskDraw;
import znaishaded.net.sourceforge.plantuml.project3.TaskInstant;
import znaishaded.net.sourceforge.plantuml.project3.TimeScale;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class GanttArrow
implements UDrawable {
    private final TimeScale timeScale;
    private final Direction atStart;
    private final TaskInstant source;
    private final Direction atEnd;
    private final TaskInstant dest;

    public GanttArrow(TimeScale timeScale, TaskInstant taskInstant, TaskInstant taskInstant2) {
        this.timeScale = timeScale;
        this.source = taskInstant;
        this.dest = taskInstant2;
        if (taskInstant.getAttribute() == TaskAttribute.END && taskInstant2.getAttribute() == TaskAttribute.START) {
            this.atStart = Direction.DOWN;
            this.atEnd = Direction.RIGHT;
        } else if (taskInstant.getAttribute() == TaskAttribute.END && taskInstant2.getAttribute() == TaskAttribute.END) {
            this.atStart = Direction.RIGHT;
            this.atEnd = Direction.LEFT;
        } else if (taskInstant.getAttribute() == TaskAttribute.START && taskInstant2.getAttribute() == TaskAttribute.START) {
            this.atStart = Direction.LEFT;
            this.atEnd = Direction.RIGHT;
        } else if (taskInstant.getAttribute() == TaskAttribute.START && taskInstant2.getAttribute() == TaskAttribute.END) {
            this.atStart = Direction.DOWN;
            this.atEnd = Direction.LEFT;
        } else {
            throw new IllegalArgumentException();
        }
    }

    public void drawU(UGraphic uGraphic) {
        uGraphic = uGraphic.apply(new UChangeBackColor(HtmlColorUtils.RED_DARK)).apply(new UChangeColor(HtmlColorUtils.RED_DARK)).apply(new UStroke(1.5));
        TaskDraw taskDraw = this.source.getTask().getTaskDraw();
        TaskDraw taskDraw2 = this.dest.getTask().getTaskDraw();
        double d = this.getX(this.source.withDelta(0), this.atStart);
        double d2 = taskDraw.getY(this.atStart);
        double d3 = this.getX(this.dest, this.atEnd.getInv());
        double d4 = taskDraw2.getY(this.atEnd);
        if (this.atStart == Direction.DOWN && this.atEnd == Direction.RIGHT) {
            if (d3 > d) {
                this.drawLine(uGraphic, d, d2, d, d4, d3, d4);
            } else {
                d = this.getX(this.source.withDelta(0), Direction.RIGHT);
                d2 = taskDraw.getY(Direction.RIGHT);
                this.drawLine(uGraphic, d, d2, d + 6.0, d2, d + 6.0, d2 + 8.0, d3 - 8.0, d2 + 8.0, d3 - 8.0, d4, d3, d4);
            }
        } else if (this.atStart == Direction.RIGHT && this.atEnd == Direction.LEFT) {
            double d5 = Math.max(d, d3) + 8.0;
            this.drawLine(uGraphic, d, d2, d5, d2, d5, d4, d3, d4);
        } else if (this.atStart == Direction.LEFT && this.atEnd == Direction.RIGHT) {
            double d6 = Math.min(d, d3) - 8.0;
            this.drawLine(uGraphic, d, d2, d6, d2, d6, d4, d3, d4);
        } else if (this.atStart == Direction.DOWN && this.atEnd == Direction.LEFT) {
            this.drawLine(uGraphic, d, d2, d, d4, d3, d4);
        } else {
            throw new IllegalArgumentException();
        }
        uGraphic.apply(new UTranslate(d3, d4)).draw(Arrows.asTo(this.atEnd));
    }

    private void drawLine(UGraphic uGraphic, double ... dArray) {
        for (int i = 0; i < dArray.length - 2; i += 2) {
            double d = dArray[i];
            double d2 = dArray[i + 1];
            double d3 = dArray[i + 2];
            double d4 = dArray[i + 3];
            uGraphic.apply(new UTranslate(d, d2)).draw(new ULine(d3 - d, d4 - d2));
        }
    }

    private double getX(TaskInstant taskInstant, Direction direction) {
        double d = this.timeScale.getStartingPosition(taskInstant.getInstantTheorical());
        double d2 = this.timeScale.getStartingPosition(taskInstant.getInstantTheorical().increment());
        if (direction == Direction.LEFT) {
            return d;
        }
        if (direction == Direction.RIGHT) {
            return d2;
        }
        return (d + d2) / 2.0;
    }
}

