/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.VerticalAlignment;
import znaishaded.net.sourceforge.plantuml.real.Real;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Message;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.LivingSpace;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileWithCallbackY;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.TileWithUpdateStairs;
import znaishaded.net.sourceforge.plantuml.skin.Area;
import znaishaded.net.sourceforge.plantuml.skin.ArrowComponent;
import znaishaded.net.sourceforge.plantuml.skin.ArrowConfiguration;
import znaishaded.net.sourceforge.plantuml.skin.Component;
import znaishaded.net.sourceforge.plantuml.skin.ComponentType;
import znaishaded.net.sourceforge.plantuml.skin.Context2D;
import znaishaded.net.sourceforge.plantuml.skin.Skin;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class CommunicationTile
implements TileWithUpdateStairs,
TileWithCallbackY {
    private final LivingSpace livingSpace1;
    private final LivingSpace livingSpace2;
    private final Message message;
    private final Skin skin;
    private final ISkinParam skinParam;
    public static final double LIVE_DELTA_SIZE = 5.0;

    public Event getEvent() {
        return this.message;
    }

    public CommunicationTile(LivingSpace livingSpace, LivingSpace livingSpace2, Message message, Skin skin, ISkinParam iSkinParam) {
        if (livingSpace == livingSpace2) {
            throw new IllegalArgumentException();
        }
        this.livingSpace1 = livingSpace;
        this.livingSpace2 = livingSpace2;
        this.message = message;
        this.skin = skin;
        this.skinParam = iSkinParam;
        if (message.isCreate()) {
            livingSpace2.goCreate();
        }
    }

    public boolean isReverse(StringBounder stringBounder) {
        Real real = this.livingSpace1.getPosC(stringBounder);
        Real real2 = this.livingSpace2.getPosC(stringBounder);
        return real.getCurrentValue() > real2.getCurrentValue();
    }

    private boolean isCreate() {
        return this.message.isCreate();
    }

    private Component getComponent(StringBounder stringBounder) {
        ArrowConfiguration arrowConfiguration = this.message.getArrowConfiguration();
        if (this.isReverse(stringBounder)) {
            arrowConfiguration = arrowConfiguration.reverse();
        }
        Component component = this.skin.createComponent(ComponentType.ARROW, arrowConfiguration, this.skinParam, this.message.getLabelNumbered());
        return component;
    }

    public void updateStairs(StringBounder stringBounder, double d) {
        ArrowComponent arrowComponent = (ArrowComponent)this.getComponent(stringBounder);
        Dimension2D dimension2D = arrowComponent.getPreferredDimension(stringBounder);
        double d2 = arrowComponent.getStartPoint(stringBounder, dimension2D).getY();
        this.livingSpace1.addStepForLivebox(this.getEvent(), d + d2);
        this.livingSpace2.addStepForLivebox(this.getEvent(), d + d2);
    }

    public void drawU(UGraphic uGraphic) {
        Area area;
        StringBounder stringBounder = uGraphic.getStringBounder();
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = this.getPoint1(stringBounder).getCurrentValue();
        double d2 = this.getPoint2(stringBounder).getCurrentValue();
        if (this.isReverse(stringBounder)) {
            int n = this.livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            int n2 = this.livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            if (n > 0) {
                d -= 5.0;
            }
            area = new Area(d - (d2 += 5.0 * (double)n2), dimension2D.getHeight());
            uGraphic = uGraphic.apply(new UTranslate(d2, 0.0));
            if (this.isCreate()) {
                this.livingSpace2.drawHead(uGraphic, (Context2D)((Object)uGraphic), VerticalAlignment.TOP, HorizontalAlignment.RIGHT);
            }
        } else {
            int n = this.livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            int n3 = this.livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            if (n3 > 0) {
                n3 -= 2;
            }
            area = new Area((d2 += 5.0 * (double)n3) - (d += 5.0 * (double)n), dimension2D.getHeight());
            uGraphic = uGraphic.apply(new UTranslate(d, 0.0));
            if (this.isCreate()) {
                this.livingSpace2.drawHead(uGraphic.apply(new UTranslate(area.getDimensionToUse().getWidth(), 0.0)), (Context2D)((Object)uGraphic), VerticalAlignment.TOP, HorizontalAlignment.LEFT);
            }
        }
        component.drawU(uGraphic, area, (Context2D)((Object)uGraphic));
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = dimension2D.getHeight();
        if (this.isCreate()) {
            d = Math.max(d, this.livingSpace2.getHeadPreferredDimension(stringBounder).getHeight());
        }
        return d;
    }

    public void addConstraints(StringBounder stringBounder) {
        Component component = this.getComponent(stringBounder);
        Dimension2D dimension2D = component.getPreferredDimension(stringBounder);
        double d = dimension2D.getWidth();
        Real real = this.getPoint1(stringBounder);
        Real real2 = this.getPoint2(stringBounder);
        if (this.isReverse(stringBounder)) {
            int n = this.livingSpace1.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            int n2 = this.livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            if (n > 0) {
                real = real.addFixed(-5.0);
            }
            real2 = real2.addFixed((double)n2 * 5.0);
            real.ensureBiggerThan(real2.addFixed(d));
        } else {
            int n = this.livingSpace2.getLevelAt(this, EventsHistoryMode.IGNORE_FUTURE_DEACTIVATE);
            if (n > 0) {
                real2 = real2.addFixed(-5.0);
            }
            real2.ensureBiggerThan(real.addFixed(d));
        }
    }

    private Real getPoint1(StringBounder stringBounder) {
        return this.livingSpace1.getPosC(stringBounder);
    }

    private Real getPoint2(StringBounder stringBounder) {
        if (this.message.isCreate()) {
            if (this.isReverse(stringBounder)) {
                return this.livingSpace2.getPosD(stringBounder);
            }
            return this.livingSpace2.getPosB();
        }
        return this.livingSpace2.getPosC(stringBounder);
    }

    public Real getMinX(StringBounder stringBounder) {
        if (this.isReverse(stringBounder)) {
            return this.getPoint2(stringBounder);
        }
        return this.getPoint1(stringBounder);
    }

    public Real getMaxX(StringBounder stringBounder) {
        if (this.isReverse(stringBounder)) {
            return this.getPoint1(stringBounder);
        }
        return this.getPoint2(stringBounder);
    }

    public void callbackY(double d) {
        if (this.message.isCreate()) {
            this.livingSpace2.goCreate(d);
        }
    }
}

