/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Event;
import znaishaded.net.sourceforge.plantuml.sequencediagram.LifeEvent;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Message;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Note;
import znaishaded.net.sourceforge.plantuml.sequencediagram.Participant;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.EventsHistoryMode;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.Stairs2;
import znaishaded.net.sourceforge.plantuml.sequencediagram.teoz.StairsPosition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventsHistory {
    private final Participant p;
    private final List<Event> events;
    private final Map<Event, Double> ys3 = new HashMap<Event, Double>();

    public EventsHistory(Participant participant, List<Event> list) {
        this.p = participant;
        this.events = list;
    }

    public void addStepForLivebox(Event event, double d) {
        this.ys3.put(event, d);
    }

    public Participant getParticipant() {
        return this.p;
    }

    public int getLevelAt(Event event, EventsHistoryMode eventsHistoryMode) {
        int n = this.getLevelAtInternal(event, eventsHistoryMode);
        return n;
    }

    private int getLevelAtInternal(Event event, EventsHistoryMode eventsHistoryMode) {
        int n = 0;
        Iterator<Event> iterator = this.events.iterator();
        while (iterator.hasNext()) {
            Event event2;
            Event event3 = iterator.next();
            if (event3 instanceof LifeEvent) {
                event2 = (LifeEvent)event3;
                if (((LifeEvent)event2).getParticipant() == this.p && ((LifeEvent)event2).isActivate()) {
                    ++n;
                }
                if (((LifeEvent)event2).getParticipant() == this.p && ((LifeEvent)event2).isDeactivateOrDestroy()) {
                    --n;
                }
            }
            if (event != event3) continue;
            if (event3 instanceof AbstractMessage && (event2 = this.nextButSkippingNotes(iterator)) instanceof LifeEvent) {
                LifeEvent lifeEvent = (LifeEvent)event2;
                AbstractMessage abstractMessage = (AbstractMessage)event3;
                if (eventsHistoryMode != EventsHistoryMode.IGNORE_FUTURE_ACTIVATE && lifeEvent.isActivate() && abstractMessage.dealWith(this.p) && lifeEvent.getParticipant() == this.p) {
                    ++n;
                }
                if (eventsHistoryMode == EventsHistoryMode.CONSIDERE_FUTURE_DEACTIVATE && lifeEvent.isDeactivateOrDestroy() && abstractMessage.dealWith(this.p) && lifeEvent.getParticipant() == this.p) {
                    --n;
                }
            }
            if (n < 0) {
                return 0;
            }
            return n;
        }
        throw new IllegalArgumentException();
    }

    private boolean isNextEventADestroy(Event event) {
        Iterator<Event> iterator = this.events.iterator();
        while (iterator.hasNext()) {
            Event event2;
            Event event3 = iterator.next();
            if (event != event3) continue;
            if (event3 instanceof Message && (event2 = this.nextButSkippingNotes(iterator)) instanceof LifeEvent) {
                LifeEvent lifeEvent = (LifeEvent)event2;
                return lifeEvent.isDestroy(this.p);
            }
            return false;
        }
        return false;
    }

    private SymbolContext getActivateColor(Event event) {
        Iterator<Event> iterator = this.events.iterator();
        while (iterator.hasNext()) {
            Event event2;
            Event event3 = iterator.next();
            if (event != event3) continue;
            if (event3 instanceof Message && (event2 = this.nextButSkippingNotes(iterator)) instanceof LifeEvent) {
                LifeEvent lifeEvent = (LifeEvent)event2;
                if (lifeEvent.isActivate()) {
                    return lifeEvent.getSpecificColors();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    private Event nextButSkippingNotes(Iterator<Event> iterator) {
        Event event;
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while ((event = iterator.next()) instanceof Note);
        return event;
    }

    public Stairs2 getStairs(double d, double d2) {
        Stairs2 stairs2 = new Stairs2();
        int n = 0;
        for (Event event : this.events) {
            Double d3 = this.ys3.get(event);
            if (d3 == null) continue;
            assert (d3 <= d2) : "position=" + d3 + " totalHeight=" + d2;
            n = this.getLevelAt(event, EventsHistoryMode.CONSIDERE_FUTURE_DEACTIVATE);
            stairs2.addStep(new StairsPosition(Math.max(d, d3), this.isNextEventADestroy(event)), n, this.getActivateColor(event));
        }
        stairs2.addStep(new StairsPosition(d2, false), n, null);
        return stairs2;
    }

    public int getMaxValue() {
        int n = 0;
        int n2 = 0;
        for (Event event : this.events) {
            if (!(event instanceof LifeEvent)) continue;
            LifeEvent lifeEvent = (LifeEvent)event;
            if (lifeEvent.getParticipant() == this.p && lifeEvent.isActivate()) {
                ++n2;
            }
            if (n2 > n) {
                n = n2;
            }
            if (lifeEvent.getParticipant() != this.p || !lifeEvent.isDeactivateOrDestroy()) continue;
            --n2;
        }
        return n;
    }
}

