/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockEmpty;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.utils.MathUtils;

public class HeaderLayout {
    private final TextBlock name;
    private final TextBlock stereo;
    private final TextBlock generic;
    private final TextBlock circledCharacter;

    public HeaderLayout(TextBlock textBlock, TextBlock textBlock2, TextBlock textBlock3, TextBlock textBlock4) {
        this.circledCharacter = HeaderLayout.protectAgaintNull(textBlock);
        this.stereo = HeaderLayout.protectAgaintNull(textBlock2);
        this.name = HeaderLayout.protectAgaintNull(textBlock3);
        this.generic = HeaderLayout.protectAgaintNull(textBlock4);
    }

    private static TextBlock protectAgaintNull(TextBlock textBlock) {
        if (textBlock == null) {
            return new TextBlockEmpty();
        }
        return textBlock;
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.generic.calculateDimension(stringBounder);
        Dimension2D dimension2D3 = this.stereo.calculateDimension(stringBounder);
        Dimension2D dimension2D4 = this.circledCharacter.calculateDimension(stringBounder);
        double d = dimension2D4.getWidth() + Math.max(dimension2D3.getWidth(), dimension2D.getWidth()) + dimension2D2.getWidth();
        double d2 = MathUtils.max(dimension2D4.getHeight(), dimension2D3.getHeight() + dimension2D.getHeight() + 10.0, dimension2D2.getHeight());
        return new Dimension2DDouble(d, d2);
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.generic.calculateDimension(stringBounder);
        Dimension2D dimension2D3 = this.stereo.calculateDimension(stringBounder);
        Dimension2D dimension2D4 = this.circledCharacter.calculateDimension(stringBounder);
        double d3 = Math.max(dimension2D3.getWidth(), dimension2D.getWidth());
        double d4 = d - dimension2D4.getWidth() - d3 - dimension2D2.getWidth();
        assert (d4 >= 0.0);
        double d5 = Math.min(dimension2D4.getWidth() / 4.0, d4 * 0.1);
        double d6 = (d4 - d5) / 2.0;
        assert (d6 >= 0.0);
        assert (d5 >= 0.0);
        double d7 = d6;
        double d8 = (d2 - dimension2D4.getHeight()) / 2.0;
        this.circledCharacter.drawU(uGraphic.apply(new UTranslate(d7, d8)));
        double d9 = d2 - dimension2D3.getHeight() - dimension2D.getHeight();
        double d10 = dimension2D4.getWidth() + (d3 - dimension2D3.getWidth()) / 2.0 + d6 + d5;
        double d11 = d9 / 2.0;
        this.stereo.drawU(uGraphic.apply(new UTranslate(d10, d11)));
        double d12 = dimension2D4.getWidth() + (d3 - dimension2D.getWidth()) / 2.0 + d6 + d5;
        double d13 = d9 / 2.0 + dimension2D3.getHeight();
        this.name.drawU(uGraphic.apply(new UTranslate(d12, d13)));
        if (dimension2D2.getWidth() > 0.0) {
            double d14 = d - dimension2D2.getWidth() + 4.0;
            this.generic.drawU(uGraphic.apply(new UTranslate(d14, -4.0)));
        }
    }
}

