/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Snake;
import znaishaded.net.sourceforge.plantuml.graphic.UGraphicDelegator;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChange;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UGraphicForSnake
extends UGraphicDelegator {
    private final double dx;
    private final double dy;
    private final List<PendingSnake> snakes;

    public UTranslate getTranslation() {
        return new UTranslate(this.dx, this.dy);
    }

    public UGraphicForSnake(UGraphic uGraphic) {
        this(uGraphic, 0.0, 0.0, new ArrayList<PendingSnake>());
    }

    private UGraphicForSnake(UGraphic uGraphic, double d, double d2, List<PendingSnake> list) {
        super(uGraphic);
        this.dx = d;
        this.dy = d2;
        this.snakes = list;
    }

    @Override
    public void draw(UShape uShape) {
        if (uShape instanceof Snake) {
            Snake snake = (Snake)uShape;
            this.addPendingSnake(snake);
        } else {
            this.getUg().draw(uShape);
        }
    }

    private void addPendingSnake(Snake snake) {
        PendingSnake pendingSnake = new PendingSnake(snake, this.getUg(), this.dx, this.dy);
        for (int i = 0; i < this.snakes.size(); ++i) {
            PendingSnake pendingSnake2 = this.snakes.get(i).merge(pendingSnake);
            if (pendingSnake2 == null) continue;
            this.snakes.set(i, pendingSnake2);
            return;
        }
        this.snakes.add(pendingSnake);
    }

    @Override
    public void flushUg() {
        for (PendingSnake pendingSnake : this.snakes) {
            pendingSnake.removeEndDecorationIfTouches(this.snakes);
            pendingSnake.drawInternal();
        }
        this.snakes.clear();
    }

    @Override
    public UGraphic apply(UChange uChange) {
        double d = this.dx;
        double d2 = this.dy;
        if (uChange instanceof UTranslate) {
            d += ((UTranslate)uChange).getDx();
            d2 += ((UTranslate)uChange).getDy();
        }
        return new UGraphicForSnake(this.getUg().apply(uChange), d, d2, this.snakes);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PendingSnake {
        private final Snake snake;
        private final UGraphic ug;
        private final double dx;
        private final double dy;

        private PendingSnake(Snake snake, UGraphic uGraphic, double d, double d2) {
            this.snake = snake;
            this.ug = uGraphic;
            this.dx = d;
            this.dy = d2;
        }

        public void drawInternal() {
            this.snake.drawInternal(this.ug);
        }

        public void removeEndDecorationIfTouches(List<PendingSnake> list) {
            for (PendingSnake pendingSnake : list) {
                if (!this.moved().touches(pendingSnake.moved())) continue;
                this.snake.removeEndDecoration();
                return;
            }
        }

        private Snake moved() {
            return this.snake.move(this.dx, this.dy);
        }

        public String toString() {
            return "dx=" + this.dx + " dy=" + this.dy + " " + this.snake.move(this.dx, this.dy).toString();
        }

        public PendingSnake merge(PendingSnake pendingSnake) {
            Snake snake;
            Snake snake2 = this.snake.move(this.dx, this.dy);
            Snake snake3 = snake2.merge(snake = pendingSnake.snake.move(pendingSnake.dx, pendingSnake.dy), this.ug.getStringBounder());
            if (snake3 == null) {
                return null;
            }
            return new PendingSnake(snake3.move(-this.dx, -this.dy), this.ug, this.dx, this.dy);
        }
    }
}

