/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineParam;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityPortion;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.PortionShower;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.Cluster;
import znaishaded.net.sourceforge.plantuml.svek.ClusterDecoration;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageEmptyPackage
extends AbstractEntityImage {
    private final TextBlock desc;
    private static final int MARGIN = 10;
    private final HtmlColor specificBackColor;
    private final ISkinParam skinParam;
    private final Stereotype stereotype;
    private final TextBlock stereoBlock;
    private final Url url;

    public EntityImageEmptyPackage(ILeaf iLeaf, ISkinParam iSkinParam, PortionShower portionShower) {
        super(iLeaf, iSkinParam);
        this.skinParam = iSkinParam;
        this.specificBackColor = iLeaf.getColors(iSkinParam).getColor(ColorType.BACK);
        this.stereotype = iLeaf.getStereotype();
        this.desc = iLeaf.getDisplay().create(new FontConfiguration(this.getSkinParam(), FontParam.PACKAGE, this.stereotype), HorizontalAlignment.CENTER, iSkinParam);
        this.url = iLeaf.getUrl99();
        this.stereoBlock = this.stereotype == null || this.stereotype.getLabel(false) == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, iLeaf) ? TextBlockUtils.empty(0.0, 0.0) : TextBlockUtils.withMargin(Display.create(this.stereotype.getLabels(iSkinParam.useGuillemet())).create(new FontConfiguration(this.getSkinParam(), FontParam.PACKAGE_STEREOTYPE, this.stereotype), HorizontalAlignment.CENTER, iSkinParam), 1.0, 0.0);
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.desc.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = TextBlockUtils.mergeTB(this.desc, this.stereoBlock, HorizontalAlignment.LEFT).calculateDimension(stringBounder);
        dimension2D2 = Dimension2DDouble.atLeast(dimension2D2, 0.0, 2.0 * dimension2D.getHeight());
        return Dimension2DDouble.delta(dimension2D2, 20.0, 20.0);
    }

    private UStroke getStroke() {
        UStroke uStroke = this.getSkinParam().getThickness(LineParam.packageBorder, this.getStereo());
        if (uStroke == null) {
            uStroke = new UStroke(2.0);
        }
        return uStroke;
    }

    public final void drawU(UGraphic uGraphic) {
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.calculateDimension(stringBounder);
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        HtmlColor htmlColor = Cluster.getBackColor(this.specificBackColor, this.skinParam, this.stereotype);
        ClusterDecoration clusterDecoration = new ClusterDecoration(this.getSkinParam().getPackageStyle(), null, this.desc, this.stereoBlock, 0.0, 0.0, d, d2, this.getStroke());
        clusterDecoration.drawU(uGraphic, htmlColor, SkinParamUtils.getColor(this.getSkinParam(), ColorParam.packageBorder, this.getStereo()), this.getSkinParam().shadowing(), 0.0);
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }
}

