/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.apache.ant.compress.taskdefs;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import znaishaded.org.apache.ant.compress.taskdefs.ExpandBase;
import znaishaded.org.apache.ant.compress.util.SevenZStreamFactory;
import znaishaded.org.apache.commons.compress.archivers.sevenz.SevenZArchiveEntry;
import znaishaded.org.apache.commons.compress.archivers.sevenz.SevenZFile;
import znaishaded.org.apache.tools.ant.BuildException;
import znaishaded.org.apache.tools.ant.util.FileNameMapper;
import znaishaded.org.apache.tools.ant.util.FileUtils;

public class Un7z
extends ExpandBase {
    public Un7z() {
        super(new SevenZStreamFactory());
    }

    @Override
    protected void expandFile(FileUtils fileUtils, File srcF, File dir) {
        if (!srcF.exists()) {
            throw new BuildException("Unable to expand " + srcF + " as the file does not exist", this.getLocation());
        }
        this.log("Expanding: " + srcF + " into " + dir, 2);
        FileNameMapper mapper = this.getMapper();
        SevenZFile outer = null;
        try {
            final SevenZFile zf = outer = new SevenZFile(srcF);
            boolean empty = true;
            SevenZArchiveEntry ze = zf.getNextEntry();
            while (ze != null) {
                empty = false;
                this.log("extracting " + ze.getName(), 4);
                try (InputStream is = new InputStream(){

                    @Override
                    public int read() throws IOException {
                        return zf.read();
                    }

                    @Override
                    public int read(byte[] b) throws IOException {
                        return zf.read(b);
                    }
                };){
                    this.extractFile(fileUtils, srcF, dir, is, ze.getName(), ze.getLastModifiedDate(), ze.isDirectory(), mapper);
                }
                ze = zf.getNextEntry();
            }
            if (empty && this.getFailOnEmptyArchive()) {
                throw new BuildException("archive '" + srcF + "' is empty");
            }
            this.log("expand complete", 3);
        }
        catch (IOException ioe) {
            throw new BuildException("Error while expanding " + srcF.getPath() + "\n" + ioe.toString(), ioe);
        }
        finally {
            if (outer != null) {
                try {
                    outer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

