/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.file;

import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.testingisdocumenting.znai.extensions.PluginParamsOpts;
import org.testingisdocumenting.znai.utils.StringUtils;

class FilePlugin {
    private FilePlugin() {
    }

    public static String extractText(String fileContent, PluginParamsOpts opts) {
        if (opts.isEmpty()) {
            return fileContent;
        }
        Text text = new Text(fileContent);
        Text croppedAtStart = FilePlugin.cropStart(text, opts);
        Text croppedAtEnd = FilePlugin.cropEnd(croppedAtStart, opts);
        Text withExcludedLines = FilePlugin.exclude(croppedAtEnd, opts);
        Text withIncludeRegexp = FilePlugin.includeRegexp(withExcludedLines, opts);
        return StringUtils.stripIndentation(withIncludeRegexp.toString());
    }

    private static Text cropStart(Text text, PluginParamsOpts opts) {
        String startLine = (String)opts.get("startLine");
        if (startLine == null) {
            return text;
        }
        return text.startingWithLineContaining(startLine);
    }

    private static Text cropEnd(Text text, PluginParamsOpts opts) {
        Number numberOfLines = (Number)opts.get("numberOfLines");
        if (numberOfLines != null) {
            return text.limitTo(numberOfLines);
        }
        String endLine = (String)opts.get("endLine");
        if (endLine != null) {
            return text.limitToLineContaining(endLine);
        }
        return text;
    }

    private static Text exclude(Text text, PluginParamsOpts opts) {
        Boolean exclude = opts.get("exclude", false);
        if (!exclude.booleanValue()) {
            return text;
        }
        return text.cropOneLineFromStartAndEnd();
    }

    private static Text includeRegexp(Text text, PluginParamsOpts opts) {
        String includeRegexp = (String)opts.get("includeRegexp");
        if (includeRegexp == null) {
            return text;
        }
        return text.includeRegexp(Pattern.compile(includeRegexp));
    }

    private static class Text {
        private final List<String> lines;

        public Text(String text) {
            this.lines = Arrays.asList(text.split("\n"));
        }

        public Text(List<String> lines) {
            this.lines = lines;
        }

        Text startingWithLineContaining(String subLine) {
            int lineIdx = this.findLineIdxContaining(subLine);
            return new Text(this.lines.subList(lineIdx, this.lines.size()));
        }

        Text limitToLineContaining(String subLine) {
            int lineIdx = this.findLineIdxContaining(subLine);
            return new Text(this.lines.subList(0, lineIdx + 1));
        }

        Text limitTo(Number numberOfLines) {
            return new Text(this.lines.subList(0, numberOfLines.intValue()));
        }

        Text cropOneLineFromStartAndEnd() {
            return new Text(this.lines.subList(1, this.lines.size() - 1));
        }

        Text includeRegexp(Pattern regexp) {
            return new Text(this.lines.stream().filter(l -> regexp.matcher((CharSequence)l).find()).collect(Collectors.toList()));
        }

        private int findLineIdxContaining(String subLine) {
            for (int i = 0; i < this.lines.size(); ++i) {
                if (!this.lines.get(i).contains(subLine)) continue;
                return i;
            }
            throw new IllegalArgumentException("<there is no line containing " + subLine + " in:\n" + this.toString());
        }

        public String toString() {
            return String.join((CharSequence)"\n", this.lines);
        }
    }
}

