/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.resources;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.resources.ResourcesResolver;
import org.testingisdocumenting.znai.utils.ResourceUtils;
import znaishaded.org.apache.commons.io.IOUtils;

public class ClassPathResourceResolver
implements ResourcesResolver {
    private final ConcurrentHashMap<String, Path> fullPathByResourcePath = new ConcurrentHashMap();

    @Override
    public void initialize(Stream<String> filteredLookupPaths) {
    }

    @Override
    public boolean supportsLookupPath(String lookupPath) {
        return false;
    }

    @Override
    public boolean canResolve(String resourcePath) {
        boolean canResolve;
        boolean bl = canResolve = ResourceUtils.resourceStream(resourcePath) != null;
        if (canResolve) {
            Path path2 = this.createTempFile(resourcePath);
            this.fullPathByResourcePath.put(resourcePath, path2);
        }
        return canResolve;
    }

    @Override
    public List<String> listOfTriedLocations(String path2) {
        return Collections.singletonList("<classpath>");
    }

    @Override
    public String textContent(String path2) {
        return ResourceUtils.textContent(path2);
    }

    @Override
    public Path fullPath(String path2) {
        return this.fullPathByResourcePath.get(path2);
    }

    @Override
    public Path docRootRelativePath(Path path2) {
        throw new UnsupportedOperationException("unsupported operation: docRootRelativePath(path)");
    }

    @Override
    public boolean isInsideDoc(Path path2) {
        return false;
    }

    @Override
    public boolean isLocalFile(String path2) {
        return false;
    }

    @Override
    public AuxiliaryFile runtimeAuxiliaryFile(String origin) {
        throw new UnsupportedOperationException("unsupported operation: runtimeAuxiliaryFile(origin)");
    }

    private Path createTempFile(String resourcePath) {
        try {
            Path tempFile = Files.createTempFile("classpath", "", new FileAttribute[0]);
            tempFile.toFile().deleteOnExit();
            InputStream inputStream = ResourceUtils.resourceStream(resourcePath);
            Files.write(tempFile, IOUtils.toByteArray(inputStream), new OpenOption[0]);
            return tempFile;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

