/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.website;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.core.AuxiliaryFile;
import org.testingisdocumenting.znai.core.AuxiliaryFilesRegistry;
import org.testingisdocumenting.znai.html.Deployer;
import org.testingisdocumenting.znai.html.DocPageReactProps;
import org.testingisdocumenting.znai.html.HtmlPageAndPageProps;
import org.testingisdocumenting.znai.html.PageToHtmlPageConverter;
import org.testingisdocumenting.znai.html.RenderSupplier;
import org.testingisdocumenting.znai.html.ServerSideSimplifiedRenderer;
import org.testingisdocumenting.znai.html.reactjs.ReactJsBundle;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.parser.MarkupParserResult;
import org.testingisdocumenting.znai.parser.MarkupParsingConfiguration;
import org.testingisdocumenting.znai.parser.MarkupParsingConfigurations;
import org.testingisdocumenting.znai.parser.commonmark.MarkdownParser;
import org.testingisdocumenting.znai.reference.DocReferences;
import org.testingisdocumenting.znai.reference.GlobalDocReferences;
import org.testingisdocumenting.znai.resources.ClassPathResourceResolver;
import org.testingisdocumenting.znai.resources.HttpBasedResourceResolver;
import org.testingisdocumenting.znai.resources.MultipleLocalLocationsResourceResolver;
import org.testingisdocumenting.znai.resources.ResourcesResolverChain;
import org.testingisdocumenting.znai.resources.UnresolvedResourceException;
import org.testingisdocumenting.znai.search.GlobalSearchEntries;
import org.testingisdocumenting.znai.search.GlobalSearchEntry;
import org.testingisdocumenting.znai.search.LocalSearchEntries;
import org.testingisdocumenting.znai.search.PageSearchEntries;
import org.testingisdocumenting.znai.search.PageSearchEntry;
import org.testingisdocumenting.znai.structure.DocMeta;
import org.testingisdocumenting.znai.structure.DocUrl;
import org.testingisdocumenting.znai.structure.Footer;
import org.testingisdocumenting.znai.structure.Page;
import org.testingisdocumenting.znai.structure.PageMeta;
import org.testingisdocumenting.znai.structure.TableOfContents;
import org.testingisdocumenting.znai.structure.TocItem;
import org.testingisdocumenting.znai.utils.FileUtils;
import org.testingisdocumenting.znai.utils.JsonUtils;
import org.testingisdocumenting.znai.website.ProgressReporter;
import org.testingisdocumenting.znai.website.TocAddedAndRemovedPages;
import org.testingisdocumenting.znai.website.WebResource;
import org.testingisdocumenting.znai.website.WebSiteComponentsRegistry;
import org.testingisdocumenting.znai.website.WebSiteDocStructure;
import org.testingisdocumenting.znai.website.WebSiteGlobalOverridePlaceholderExtension;
import org.testingisdocumenting.znai.website.WebSiteLogoExtension;
import org.testingisdocumenting.znai.website.WebSiteResourcesProviders;
import org.testingisdocumenting.znai.website.WebSiteUserExtensions;
import org.testingisdocumenting.znai.website.modifiedtime.FileBasedPageModifiedTime;
import org.testingisdocumenting.znai.website.modifiedtime.PageModifiedTimeStrategy;

public class WebSite {
    private static final String SEARCH_INDEX_FILE_NAME = "search-index.js";
    private PageToHtmlPageConverter pageToHtmlPageConverter;
    private MarkupParser markupParser;
    private final Deployer deployer;
    private final DocMeta docMeta;
    private final Configuration cfg;
    private Map<TocItem, Page> pageByTocItem;
    private GlobalSearchEntries globalSearchEntries;
    private LocalSearchEntries localSearchEntries;
    private TableOfContents toc;
    private final GlobalDocReferences globalDocReferences;
    private WebSiteDocStructure docStructure;
    private Footer footer;
    private Map<TocItem, DocPageReactProps> pagePropsByTocItem;
    private List<WebResource> registeredExtraJavaScripts;
    private List<WebResource> extraJavaScriptsInFront;
    private List<WebResource> extraJavaScriptsInBack;
    private final WebSiteComponentsRegistry componentsRegistry;
    private final AuxiliaryFilesRegistry auxiliaryFilesRegistry;
    private final ReactJsBundle reactJsBundle;
    private final WebResource tocJavaScript;
    private final WebResource globalAssetsJavaScript;
    private final WebResource globalDocReferencesJavaScript;
    private final WebResource searchIndexJavaScript;
    private final MultipleLocalLocationsResourceResolver localResourceResolver;
    private final ResourcesResolverChain resourceResolver;
    private final MarkupParsingConfiguration markupParsingConfiguration;
    private final Map<AuxiliaryFile, Long> auxiliaryFilesLastUpdateTime;
    private final PageModifiedTimeStrategy pageModifiedTimeStrategy;

    private WebSite(Configuration siteConfig) {
        this.cfg = siteConfig;
        this.deployer = new Deployer(siteConfig.deployPath);
        this.docMeta = siteConfig.docMeta;
        this.pageModifiedTimeStrategy = siteConfig.pageModifiedTimeStrategy != null ? siteConfig.pageModifiedTimeStrategy : new FileBasedPageModifiedTime();
        this.registeredExtraJavaScripts = siteConfig.registeredExtraJavaScripts;
        this.componentsRegistry = new WebSiteComponentsRegistry();
        this.resourceResolver = new ResourcesResolverChain();
        this.reactJsBundle = siteConfig.reactJsBundle;
        this.tocJavaScript = WebResource.withPath("toc.js");
        this.globalAssetsJavaScript = WebResource.withPath("assets.js");
        this.globalDocReferencesJavaScript = WebResource.withPath("documentation-references.js");
        this.searchIndexJavaScript = WebResource.withPath(SEARCH_INDEX_FILE_NAME);
        this.auxiliaryFilesRegistry = new AuxiliaryFilesRegistry();
        this.markupParsingConfiguration = MarkupParsingConfigurations.byName(this.cfg.documentationType);
        this.globalSearchEntries = new GlobalSearchEntries();
        this.localSearchEntries = new LocalSearchEntries();
        this.auxiliaryFilesLastUpdateTime = new HashMap<AuxiliaryFile, Long>();
        this.globalDocReferences = new GlobalDocReferences(this.componentsRegistry, this.cfg.globalReferencesPath);
        this.docMeta.setId(siteConfig.id);
        if (siteConfig.isPreviewEnabled) {
            this.docMeta.setPreviewEnabled(true);
        }
        this.componentsRegistry.setResourcesResolver(this.resourceResolver);
        this.localResourceResolver = new MultipleLocalLocationsResourceResolver(siteConfig.docRootPath);
        this.resourceResolver.addResolver(this.localResourceResolver);
        this.resourceResolver.addResolver(new ClassPathResourceResolver());
        this.resourceResolver.addResolver(new HttpBasedResourceResolver());
        this.resourceResolver.initialize(this.findLookupLocations(siteConfig));
        WebSiteResourcesProviders.add(new WebSiteLogoExtension(siteConfig.docRootPath));
        WebSiteResourcesProviders.add(new WebSiteGlobalOverridePlaceholderExtension());
        WebSiteResourcesProviders.add(this.initFileBasedWebSiteExtension(siteConfig));
        this.reset();
    }

    public Configuration getCfg() {
        return this.cfg;
    }

    public static Configuration withRoot(Path path2) {
        Configuration configuration = new Configuration();
        configuration.withRootPath(path2);
        return configuration;
    }

    public void regenerate() {
        this.reset();
        this.parseAndDeploy();
    }

    public AuxiliaryFilesRegistry getAuxiliaryFilesRegistry() {
        return this.auxiliaryFilesRegistry;
    }

    public Path getDeployRoot() {
        return this.cfg.deployPath;
    }

    public DocMeta getDocMeta() {
        return this.docMeta;
    }

    public ReactJsBundle getReactJsBundle() {
        return this.reactJsBundle;
    }

    public Map<String, Path> getOutsideDocsRequestedResources() {
        return this.resourceResolver.getOutsideDocRequestedResources();
    }

    public void parseAndDeploy() {
        this.parse();
        this.deploy();
    }

    public void parse() {
        this.createTopLevelToc();
        this.createDocStructure();
        this.parseGlobalDocReference();
        this.validateTocItemsPresence();
        this.parseMarkupsMeta();
        this.parseMarkups();
        this.parseFooter();
        this.updateTocWithPageSections();
        this.validateCollectedLinks();
    }

    public void deploy() {
        ProgressReporter.reportPhase("deploying documentation");
        this.generatePages();
        this.generateSearchIndex();
        this.deployToc();
        this.deployMeta();
        this.deployGlobalAssets();
        this.deployGlobalDocReferences();
        this.deployAuxiliaryFiles();
        this.deployResources();
    }

    public TocItem tocItemByPath(Path path2) {
        return this.markupParsingConfiguration.tocItemByPath(this.componentsRegistry, this.toc, path2);
    }

    public HtmlPageAndPageProps regenerateAndValidatePageDeployTocAndAllPages(TocItem tocItem) {
        this.removeLinksForTocItem(tocItem);
        HtmlPageAndPageProps pageProps = this.regeneratePageOnly(tocItem);
        this.deployToc();
        this.docStructure.validateCollectedLinks();
        this.buildJsonOfAllPages();
        return pageProps;
    }

    public void removeLinksForTocItem(TocItem tocItem) {
        try {
            Path markupPath = this.markupPath(tocItem);
            this.docStructure.removeGlobalAnchorsForPath(markupPath);
            this.docStructure.removeLocalAnchorsForTocItem(tocItem);
            this.docStructure.removeLinksForPath(markupPath);
        }
        catch (UnresolvedResourceException unresolvedResourceException) {
            // empty catch block
        }
    }

    public HtmlPageAndPageProps regeneratePageOnly(TocItem tocItem) {
        this.parseMarkupAndUpdateTocItemAndSearch(tocItem);
        Page page = this.pageByTocItem.get(tocItem);
        tocItem.setPageSectionIdTitles(page.getPageSectionIdTitles());
        HtmlPageAndPageProps pageProps = this.generatePage(tocItem, page);
        this.auxiliaryFilesRegistry.auxiliaryFilesByTocItem(tocItem).stream().filter(AuxiliaryFile::isDeploymentRequired).forEach(this::deployAuxiliaryFileIfOutdated);
        return pageProps;
    }

    public Set<TocItem> dependentTocItems(Path auxiliaryFile) {
        return this.auxiliaryFilesRegistry.tocItemsByPath(auxiliaryFile);
    }

    public TableOfContents getToc() {
        return this.toc;
    }

    public TocAddedAndRemovedPages updateToc() {
        TableOfContents previousToc = this.toc;
        this.createTopLevelToc();
        this.docStructure.updateToc(this.toc);
        this.validateTocItemsPresence();
        List<TocItem> newTocItems = previousToc.detectNewTocItems(this.toc);
        List<TocItem> removedTocItems = previousToc.detectRemovedTocItems(this.toc);
        removedTocItems.forEach(this::removeLinksForTocItem);
        List<HtmlPageAndPageProps> newPages = newTocItems.stream().map(tocItem -> {
            this.parseMarkupAndUpdateTocItemAndSearch((TocItem)tocItem);
            return this.regeneratePageOnly((TocItem)tocItem);
        }).collect(Collectors.toList());
        this.updateTocWithPageSections();
        this.docStructure.validateCollectedLinks();
        this.deployToc();
        return new TocAddedAndRemovedPages(this.toc, newPages, removedTocItems);
    }

    public DocReferences updateDocReferences() {
        this.docStructure.removeLinksForPath(this.globalDocReferences.getGlobalReferencesPath());
        this.globalDocReferences.load();
        this.deployGlobalDocReferences();
        this.validateCollectedLinks();
        return this.globalDocReferences.getDocReferences();
    }

    public void redeployAuxiliaryFileIfRequired(Path path2) {
        if (this.auxiliaryFilesRegistry.requiresDeployment(path2)) {
            this.deployAuxiliaryFile(this.auxiliaryFilesRegistry.auxiliaryFileByPath(path2));
        }
    }

    private WebSiteUserExtensions initFileBasedWebSiteExtension(Configuration cfg) {
        if (cfg.extensionsDefPath == null || !Files.exists(cfg.extensionsDefPath, new LinkOption[0])) {
            return new WebSiteUserExtensions(this.resourceResolver, Collections.emptyMap());
        }
        String json = FileUtils.fileTextContent(cfg.extensionsDefPath);
        return new WebSiteUserExtensions(this.resourceResolver, JsonUtils.deserializeAsMap(json));
    }

    private void reset() {
        this.pageToHtmlPageConverter = new PageToHtmlPageConverter(this.docMeta, this.reactJsBundle);
        this.markupParser = this.markupParsingConfiguration.createMarkupParser(this.componentsRegistry);
        this.pageByTocItem = new LinkedHashMap<TocItem, Page>();
        this.pagePropsByTocItem = new HashMap<TocItem, DocPageReactProps>();
        this.extraJavaScriptsInFront = new ArrayList<WebResource>(this.registeredExtraJavaScripts);
        this.extraJavaScriptsInFront.add(this.globalAssetsJavaScript);
        if (this.globalDocReferences.isPresent()) {
            this.extraJavaScriptsInFront.add(this.globalDocReferencesJavaScript);
        }
        this.extraJavaScriptsInFront.add(this.tocJavaScript);
        this.extraJavaScriptsInBack = new ArrayList<WebResource>(this.registeredExtraJavaScripts);
        this.extraJavaScriptsInBack.add(this.searchIndexJavaScript);
        this.componentsRegistry.setDefaultParser(this.markupParser);
        this.componentsRegistry.setMarkdownParser(new MarkdownParser(this.componentsRegistry));
    }

    private void deployResources() {
        ProgressReporter.reportPhase("deploying resources");
        this.reactJsBundle.deploy(this.deployer);
        WebSiteResourcesProviders.cssResources().forEach(this.deployer::deploy);
        WebSiteResourcesProviders.jsResources().forEach(this.deployer::deploy);
        WebSiteResourcesProviders.jsClientOnlyResources().forEach(this.deployer::deploy);
        WebSiteResourcesProviders.additionalFilesToDeploy().forEach(this.deployer::deploy);
        this.cfg.webResources.forEach(this.deployer::deploy);
    }

    private void createTopLevelToc() {
        ProgressReporter.reportPhase("creating table of contents");
        this.toc = this.markupParsingConfiguration.createToc(this.componentsRegistry);
    }

    private void createDocStructure() {
        this.docStructure = new WebSiteDocStructure(this.componentsRegistry, this.docMeta, this.toc, this.markupParsingConfiguration);
        this.componentsRegistry.setDocStructure(this.docStructure);
    }

    private void parseGlobalDocReference() {
        ProgressReporter.reportPhase("parsing global doc references");
        this.globalDocReferences.load();
    }

    private void updateTocWithPageSections() {
        this.forEachPage((tocItem, page) -> tocItem.setPageSectionIdTitles(page.getPageSectionIdTitles()));
    }

    private void deployToc() {
        ProgressReporter.reportPhase("deploying table of contents");
        String tocJson = JsonUtils.serializePrettyPrint(this.toc.toListOfMaps());
        this.deployer.deploy(this.tocJavaScript, "toc = " + tocJson);
    }

    private void deployMeta() {
        ProgressReporter.reportPhase("deploying meta");
        this.deployer.deploy("meta.json", JsonUtils.serializePrettyPrint(this.docMeta.toMap()));
    }

    private void deployGlobalAssets() {
        ProgressReporter.reportPhase("deploying global plugin assets");
        String globalAssetsJson = JsonUtils.serializePrettyPrint(this.componentsRegistry.globalAssetsRegistry().getAssets());
        this.deployer.deploy(this.globalAssetsJavaScript, "globalAssets = " + globalAssetsJson);
    }

    private void deployGlobalDocReferences() {
        if (!this.globalDocReferences.isPresent()) {
            return;
        }
        ProgressReporter.reportPhase("deploying global documentation references");
        String globalReferences = JsonUtils.serializePrettyPrint(this.globalDocReferences.getDocReferences().toMap());
        this.deployer.deploy(this.globalDocReferencesJavaScript, "docReferences = " + globalReferences);
    }

    private void validateTocItemsPresence() {
        ProgressReporter.reportPhase("validate TOC items presence");
        List missingTocItems = this.toc.getTocItems().stream().filter(this::isTocItemMissing).collect(Collectors.toList());
        if (!missingTocItems.isEmpty()) {
            String renderedMissingTocItems = "    " + missingTocItems.stream().map(tocItem -> tocItem.toString() + ": can't find " + this.markupParsingConfiguration.tocItemResourceName((TocItem)tocItem)).collect(Collectors.joining("\n    "));
            throw new RuntimeException("\nFollowing Table of Contents entries are missing associated files:\n\n" + renderedMissingTocItems + "\n");
        }
    }

    private boolean isTocItemMissing(TocItem tocItem) {
        try {
            this.markupPath(tocItem);
        }
        catch (UnresolvedResourceException e) {
            return true;
        }
        return false;
    }

    private void parseMarkupsMeta() {
        ProgressReporter.reportPhase("parsing markup files meta");
        this.toc.getTocItems().forEach(this::parseMarkupMetaOnlyAndUpdateTocItem);
    }

    private void parseMarkups() {
        ProgressReporter.reportPhase("parsing markup files");
        this.toc.getTocItems().forEach(this::parseMarkupAndUpdateTocItemAndSearch);
    }

    private void parseFooter() {
        Path markupPath = this.cfg.footerPath;
        if (!Files.exists(markupPath, new LinkOption[0])) {
            return;
        }
        ProgressReporter.reportPhase("parsing footer");
        this.localResourceResolver.setCurrentFilePath(markupPath);
        MarkupParserResult parserResult = this.markupParser.parse(markupPath, FileUtils.fileTextContent(markupPath));
        this.footer = new Footer(parserResult.getDocElement());
    }

    private void parseMarkupMetaOnlyAndUpdateTocItem(TocItem tocItem) {
        Path markupPath = null;
        try {
            markupPath = this.markupPath(tocItem);
            PageMeta pageMeta = this.markupParser.parsePageMetaOnly(FileUtils.fileTextContent(markupPath));
            this.updateTocItemWithPageMeta(tocItem, pageMeta);
        }
        catch (Exception e) {
            WebSite.throwParsingErrorMessage(tocItem, markupPath, e);
        }
    }

    private void parseMarkupAndUpdateTocItemAndSearch(TocItem tocItem) {
        Path markupPath = null;
        try {
            markupPath = this.markupPath(tocItem);
            Path relativePathToLog = this.cfg.docRootPath.relativize(markupPath);
            ConsoleOutputs.out(new Object[]{"parsing ", Color.PURPLE, relativePathToLog});
            this.localResourceResolver.setCurrentFilePath(markupPath);
            MarkupParserResult parserResult = this.markupParser.parse(markupPath, FileUtils.fileTextContent(markupPath));
            this.updateFilesAssociation(tocItem, parserResult.getAuxiliaryFiles());
            Instant lastModifiedTime = this.pageModifiedTimeStrategy.lastModifiedTime(tocItem, markupPath);
            Page page = new Page(parserResult.getDocElement(), lastModifiedTime, parserResult.getPageMeta());
            this.pageByTocItem.put(tocItem, page);
            this.updateTocItemWithPageMeta(tocItem, page.getPageMeta());
            tocItem.setPageSectionIdTitles(page.getPageSectionIdTitles());
            this.updateSearchEntries(tocItem, parserResult);
        }
        catch (Exception e) {
            WebSite.throwParsingErrorMessage(tocItem, markupPath, e);
        }
    }

    private static void throwParsingErrorMessage(TocItem tocItem, Path markupPath, Throwable e) {
        throw new RuntimeException("\nmarkup parsing error:\n    TOC item: " + tocItem + "\n    full path: " + markupPath + "\n\n" + e.getMessage() + "\n", e);
    }

    private void updateTocItemWithPageMeta(TocItem tocItem, PageMeta pageMeta) {
        tocItem.setPageMeta(pageMeta);
        if (pageMeta.hasValue("title")) {
            tocItem.setPageTitle((String)pageMeta.getSingleValue("title"));
        }
    }

    private void updateSearchEntries(TocItem tocItem, MarkupParserResult parserResult) {
        List<GlobalSearchEntry> siteSearchEntries = parserResult.getSearchEntries().stream().map(pageSearchEntry -> new GlobalSearchEntry(this.searchEntryUrl(tocItem, (PageSearchEntry)pageSearchEntry), this.searchEntryTitle(tocItem, (PageSearchEntry)pageSearchEntry), pageSearchEntry.getSearchText())).collect(Collectors.toList());
        this.globalSearchEntries.addAll(siteSearchEntries);
        this.localSearchEntries.add(new PageSearchEntries(tocItem, parserResult.getSearchEntries()));
    }

    private String searchEntryUrl(TocItem tocItem, PageSearchEntry pageSearchEntry) {
        DocUrl docUrl = tocItem.isIndex() ? DocUrl.indexUrl() : new DocUrl(tocItem.getDirName(), tocItem.getFileNameWithoutExtension(), pageSearchEntry.getPageSectionId());
        return this.docStructure.createUrl(null, docUrl);
    }

    private String searchEntryTitle(TocItem tocItem, PageSearchEntry pageSearchEntry) {
        if (tocItem.isIndex()) {
            return this.docMeta.getTitle() + " " + (pageSearchEntry.getPageSectionTitle().isEmpty() ? this.docMeta.getType() : pageSearchEntry.getPageSectionTitle());
        }
        return this.docMeta.getTitle() + ": " + tocItem.getPageTitle() + ", " + pageSearchEntry.getPageSectionTitle() + " [" + tocItem.getSectionTitle() + "]";
    }

    private void updateFilesAssociation(TocItem tocItem, List<AuxiliaryFile> newAuxiliaryFiles) {
        newAuxiliaryFiles.forEach(af -> this.auxiliaryFilesRegistry.updateFileAssociations(tocItem, (AuxiliaryFile)af));
    }

    private Path markupPath(TocItem tocItem) {
        return this.markupParsingConfiguration.fullPath(this.componentsRegistry, this.cfg.docRootPath, tocItem);
    }

    private void generatePages() {
        ProgressReporter.reportPhase("generating the rest of HTML pages");
        this.forEachPage(this::generatePage);
        this.buildJsonOfAllPages();
    }

    private void generateSearchIndex() {
        ProgressReporter.reportPhase("generating search index");
        String jsIndexScript = this.localSearchEntries.buildIndexScript();
        this.deployer.deploy(SEARCH_INDEX_FILE_NAME, jsIndexScript);
        String xmlExternalIndex = this.globalSearchEntries.toXml();
        this.deployer.deploy("search-entries.xml", xmlExternalIndex);
    }

    private void buildJsonOfAllPages() {
        List listOfMaps = this.pagePropsByTocItem.values().stream().map(DocPageReactProps::toMap).collect(Collectors.toList());
        String json = JsonUtils.serialize(listOfMaps);
        this.deployer.deploy("all-pages.json", json);
    }

    private HtmlPageAndPageProps generatePage(TocItem tocItem, Page page) {
        try {
            HtmlPageAndPageProps htmlAndProps = this.pageToHtmlPageConverter.convert(tocItem, page, this.createServerSideRenderer(tocItem), this.footer);
            this.pagePropsByTocItem.put(tocItem, htmlAndProps.getProps());
            this.extraJavaScriptsInFront.forEach(htmlAndProps.getHtmlPage()::addJavaScriptInFront);
            this.extraJavaScriptsInBack.forEach(htmlAndProps.getHtmlPage()::addJavaScript);
            String html = htmlAndProps.getHtmlPage().render(this.docMeta.getId());
            Path pagePath = tocItem.isIndex() ? Paths.get("index.html", new String[0]) : Paths.get(tocItem.getDirName(), new String[0]).resolve(tocItem.getFileNameWithoutExtension()).resolve("index.html");
            Path originalPathForLogging = this.cfg.docRootPath.relativize(this.markupParsingConfiguration.fullPath(this.componentsRegistry, this.cfg.docRootPath, tocItem).toAbsolutePath());
            this.deployer.deploy(originalPathForLogging, pagePath, html);
            return htmlAndProps;
        }
        catch (Exception e) {
            throw new RuntimeException("error during rendering of " + tocItem.getFileNameWithoutExtension() + ": " + e.getMessage(), e);
        }
    }

    private RenderSupplier createServerSideRenderer(TocItem tocItem) {
        PageSearchEntries pageSearchEntries = this.localSearchEntries.searchEntriesByTocItem(tocItem);
        if (tocItem.isIndex()) {
            return () -> ServerSideSimplifiedRenderer.renderPageTextContent(pageSearchEntries) + ServerSideSimplifiedRenderer.renderToc(this.toc);
        }
        return () -> ServerSideSimplifiedRenderer.renderPageTextContent(pageSearchEntries);
    }

    private void deployAuxiliaryFiles() {
        ProgressReporter.reportPhase("deploying auxiliary files (e.g. images)");
        this.auxiliaryFilesRegistry.getAuxiliaryFilesForDeployment().forEach(this::deployAuxiliaryFile);
    }

    private void deployAuxiliaryFileIfOutdated(AuxiliaryFile auxiliaryFile) {
        Long savedLastModifiedTime = this.auxiliaryFilesLastUpdateTime.get(auxiliaryFile);
        try {
            FileTime lastModifiedTime = Files.getLastModifiedTime(auxiliaryFile.getPath(), new LinkOption[0]);
            if (savedLastModifiedTime != null && savedLastModifiedTime.longValue() == lastModifiedTime.toMillis()) {
                return;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.deployAuxiliaryFile(auxiliaryFile);
    }

    private void deployAuxiliaryFile(AuxiliaryFile auxiliaryFile) {
        try {
            this.deployer.deploy(auxiliaryFile.getDeployRelativePath(), Files.readAllBytes(auxiliaryFile.getPath()));
            FileTime lastModifiedTime = Files.getLastModifiedTime(auxiliaryFile.getPath(), new LinkOption[0]);
            this.auxiliaryFilesLastUpdateTime.put(auxiliaryFile, lastModifiedTime.toMillis());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void forEachPage(PageConsumer consumer) {
        this.toc.getTocItems().forEach(tocItem -> {
            Page page = this.pageByTocItem.get(tocItem);
            consumer.consume((TocItem)tocItem, page);
        });
    }

    private <E> Stream<E> mapEachTocItemWithoutPage(Function<TocItem, E> func) {
        return this.toc.getTocItems().stream().filter(tocItem -> this.pageByTocItem.containsKey(tocItem)).map(func);
    }

    private void validateCollectedLinks() {
        ProgressReporter.reportPhase("validating links");
        this.docStructure.validateCollectedLinks();
    }

    private Stream<String> findLookupLocations(Configuration cfg) {
        Stream<String> root = Stream.of(cfg.docRootPath.toString());
        if (cfg.fileWithLookupPaths == null) {
            return root;
        }
        return Stream.concat(root, this.readLocationsFromFile(cfg.fileWithLookupPaths));
    }

    private Stream<String> readLocationsFromFile(String filesLookupFilePath) {
        Path lookupFilePath = this.cfg.docRootPath.resolve(filesLookupFilePath);
        if (!Files.exists(lookupFilePath, new LinkOption[0])) {
            return Stream.empty();
        }
        String fileContent = FileUtils.fileTextContent(lookupFilePath);
        return Arrays.stream(fileContent.split("[;\n]")).map(String::trim).filter(e -> !e.isEmpty());
    }

    public static class Configuration {
        private Path deployPath;
        private Path docRootPath;
        private Path footerPath;
        private Path extensionsDefPath;
        private Path globalReferencesPath;
        private List<WebResource> webResources;
        private String id;
        private String title;
        private String type;
        private String fileWithLookupPaths;
        private String logoRelativePath;
        private List<WebResource> registeredExtraJavaScripts;
        private boolean isPreviewEnabled;
        private String documentationType = "markdown";
        private DocMeta docMeta = new DocMeta(Collections.emptyMap());
        private ReactJsBundle reactJsBundle;
        private PageModifiedTimeStrategy pageModifiedTimeStrategy;

        private Configuration() {
            this.webResources = new ArrayList<WebResource>();
            this.registeredExtraJavaScripts = new ArrayList<WebResource>();
        }

        public Configuration withDocumentationType(String documentationType) {
            this.documentationType = documentationType;
            return this;
        }

        public Configuration withRootPath(Path path2) {
            this.docRootPath = path2.toAbsolutePath();
            return this;
        }

        public Configuration withFooterPath(Path path2) {
            this.footerPath = path2.toAbsolutePath();
            return this;
        }

        public Configuration withReactJsBundle(ReactJsBundle reactJsBundle) {
            this.reactJsBundle = reactJsBundle;
            return this;
        }

        public Configuration withExtensionsDefPath(Path path2) {
            this.extensionsDefPath = path2.toAbsolutePath();
            return this;
        }

        public Configuration withGlobalReferencesPath(Path path2) {
            this.globalReferencesPath = path2.toAbsolutePath();
            return this;
        }

        public Configuration withWebResources(WebResource ... resources) {
            this.webResources.addAll(Arrays.asList(resources));
            return this;
        }

        public Configuration withExtraJavaScripts(WebResource ... webResources) {
            this.registeredExtraJavaScripts.addAll(Arrays.asList(webResources));
            return this;
        }

        public Configuration withPageModifiedTimeStrategy(PageModifiedTimeStrategy modifiedTimeStrategy) {
            this.pageModifiedTimeStrategy = modifiedTimeStrategy;
            return this;
        }

        public Configuration withId(String id) {
            this.id = id;
            return this;
        }

        public Configuration withTitle(String title) {
            this.title = title;
            return this;
        }

        public Configuration withType(String type) {
            this.type = type;
            return this;
        }

        public Configuration withFileWithLookupPaths(String fileWithLookupPaths) {
            this.fileWithLookupPaths = fileWithLookupPaths;
            return this;
        }

        public Configuration withMetaFromJsonFile(Path path2) {
            String json = FileUtils.fileTextContent(path2);
            this.docMeta = new DocMeta(json);
            this.withTitle(this.docMeta.getTitle());
            this.withType(this.docMeta.getType());
            return this;
        }

        public Configuration withLogoRelativePath(String logoRelativePath) {
            this.logoRelativePath = logoRelativePath;
            return this;
        }

        public Configuration withEnabledPreview(boolean isPreviewEnabled) {
            this.isPreviewEnabled = isPreviewEnabled;
            return this;
        }

        public Path getGlobalReferencesPath() {
            return this.globalReferencesPath;
        }

        public Path getDocRootPath() {
            return this.docRootPath;
        }

        public WebSite deployTo(Path path2) {
            WebSite webSite = this.createWebSiteInstance(path2);
            webSite.parseAndDeploy();
            return webSite;
        }

        public WebSite parseOnly() {
            WebSite webSite = this.createWebSiteInstance(Paths.get("", new String[0]));
            webSite.parse();
            return webSite;
        }

        private WebSite createWebSiteInstance(Path path2) {
            this.deployPath = path2.toAbsolutePath();
            return new WebSite(this);
        }
    }

    private static interface TocItemConsumer {
        public void consume(TocItem var1);
    }

    private static interface PageConsumer {
        public void consume(TocItem var1, Page var2);
    }
}

