/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.ctreber.acearth.plugins.markers;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.List;
import znaishaded.com.ctreber.acearth.gui.PixelCanvas;
import znaishaded.com.ctreber.acearth.projection.Projection;
import znaishaded.com.ctreber.acearth.projection.ProjectionOrtho;
import znaishaded.com.ctreber.acearth.util.Coordinate;
import znaishaded.com.ctreber.acearth.util.Point2D;
import znaishaded.com.ctreber.acearth.util.Point3D;
import znaishaded.com.ctreber.acearth.util.StringParser;

public class Marker {
    private static final int MARKER_SIZE = 4;
    private static final int MarkerAlignDefault = 0;
    private static final int MarkerAlignLeft = 1;
    private static final int MarkerAlignRight = 2;
    private static final int MarkerAlignAbove = 3;
    private static final int MarkerAlignBelow = 4;
    private Coordinate fCoordinate;
    private String fLabel;
    private int fAlign;

    private Marker(Coordinate coordinate, String string, int n) {
        this.fCoordinate = coordinate;
        this.fLabel = string;
        this.fAlign = n;
    }

    private static Marker createFromLine(String string) {
        Object object;
        List list = StringParser.parse(string);
        double d = Double.parseDouble((String)list.get(0));
        double d2 = Double.parseDouble((String)list.get(1));
        String string2 = (String)list.get(2);
        int n = 0;
        if (list.size() >= 4) {
            object = (String)list.get(3);
            if (((String)object).equalsIgnoreCase("left")) {
                n = 1;
            }
            if (((String)object).equalsIgnoreCase("right")) {
                n = 2;
            }
            if (((String)object).equalsIgnoreCase("above")) {
                n = 3;
            }
            if (((String)object).equalsIgnoreCase("below")) {
                n = 4;
            }
        }
        if (!((Coordinate)(object = new Coordinate(d, d2))).check()) {
            return null;
        }
        return new Marker((Coordinate)object, string2, n);
    }

    public String toString() {
        return this.fLabel + " (" + this.fCoordinate + "), align: " + this.fAlign;
    }

    public void render(PixelCanvas pixelCanvas, Projection projection) {
        Point3D point3D = projection.rotate(this.fCoordinate.getPoint3D());
        if (projection instanceof ProjectionOrtho && point3D.getZ() <= 0.0) {
            return;
        }
        Point2D point2D = projection.finalize(projection.project2D(point3D));
        int n = (int)point2D.getX();
        int n2 = (int)point2D.getY();
        Graphics2D graphics2D = pixelCanvas.getGraphics2D();
        graphics2D.setColor(Color.red);
        graphics2D.drawOval(n, n2, 4, 4);
        if (this.fLabel != null) {
            switch (this.fAlign) {
                case 1: {
                    break;
                }
                case 0: 
                case 2: {
                    graphics2D.setFont(new Font("", 0, 9));
                    graphics2D.drawString(this.fLabel, n + 4 + 1, n2 + 2);
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
    }

    public static Marker loadMarkerFile(String string) {
        return Marker.createFromLine(string);
    }
}

