/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.cache;

import znaishaded.freemarker.template.MalformedTemplateNameException;
import znaishaded.freemarker.template.utility.StringUtil;

public abstract class TemplateNameFormat {
    public static final TemplateNameFormat DEFAULT_2_3_0 = new Default020300();
    public static final TemplateNameFormat DEFAULT_2_4_0 = new Default020400();

    private TemplateNameFormat() {
    }

    abstract String toAbsoluteName(String var1, String var2) throws MalformedTemplateNameException;

    abstract String normalizeAbsoluteName(String var1) throws MalformedTemplateNameException;

    private static void checkNameHasNoNullCharacter(String name) throws MalformedTemplateNameException {
        if (name.indexOf(0) != -1) {
            throw new MalformedTemplateNameException(name, "Null character (\\u0000) in the name; possible attack attempt");
        }
    }

    private static MalformedTemplateNameException newRootLeavingException(String name) {
        return new MalformedTemplateNameException(name, "Backing out from the root directory is not allowed");
    }

    private static final class Default020400
    extends TemplateNameFormat {
        private Default020400() {
        }

        String toAbsoluteName(String baseName, String targetName) {
            if (baseName == null) {
                return targetName;
            }
            if (this.findSchemeSectionEnd(targetName) != 0) {
                return targetName;
            }
            if (targetName.startsWith("/")) {
                String targetNameAsRelative = targetName.substring(1);
                int schemeSectionEnd = this.findSchemeSectionEnd(baseName);
                if (schemeSectionEnd == 0) {
                    return targetNameAsRelative;
                }
                return baseName.substring(0, schemeSectionEnd) + targetNameAsRelative;
            }
            if (!baseName.endsWith("/")) {
                int baseEnd = baseName.lastIndexOf("/") + 1;
                if (baseEnd == 0) {
                    baseEnd = this.findSchemeSectionEnd(baseName);
                }
                baseName = baseName.substring(0, baseEnd);
            }
            return baseName + targetName;
        }

        String normalizeAbsoluteName(String name) throws MalformedTemplateNameException {
            String path2;
            String scheme;
            TemplateNameFormat.checkNameHasNoNullCharacter(name);
            if (name.indexOf(92) != -1) {
                throw new MalformedTemplateNameException(name, "Backslash (\"\\\") is not allowed in template names. Use slash (\"/\") instead.");
            }
            int schemeSectionEnd = this.findSchemeSectionEnd(name);
            if (schemeSectionEnd == 0) {
                scheme = null;
                path2 = name;
            } else {
                scheme = name.substring(0, schemeSectionEnd);
                path2 = name.substring(schemeSectionEnd);
            }
            if (path2.indexOf(58) != -1) {
                throw new MalformedTemplateNameException(name, "The ':' character can only be used after the scheme name (if there's any), not in the path part");
            }
            path2 = this.removeRedundantSlashes(path2);
            path2 = this.removeDotSteps(path2);
            path2 = this.resolveDotDotSteps(path2, name);
            path2 = this.removeRedundantStarSteps(path2);
            return scheme == null ? path2 : scheme + path2;
        }

        private int findSchemeSectionEnd(String name) {
            int schemeColonIdx = name.indexOf(":");
            if (schemeColonIdx == -1 || name.lastIndexOf(47, schemeColonIdx - 1) != -1) {
                return 0;
            }
            if (schemeColonIdx + 2 < name.length() && name.charAt(schemeColonIdx + 1) == '/' && name.charAt(schemeColonIdx + 2) == '/') {
                return schemeColonIdx + 3;
            }
            return schemeColonIdx + 1;
        }

        private String removeRedundantSlashes(String path2) {
            String prevName;
            while ((prevName = path2) != (path2 = StringUtil.replace(path2, "//", "/"))) {
            }
            return path2.startsWith("/") ? path2.substring(1) : path2;
        }

        /*
         * WARNING - void declaration
         */
        private String removeDotSteps(String path2) {
            int nextFromIdx = path2.length() - 1;
            int dotIdx;
            while ((dotIdx = path2.lastIndexOf(46, nextFromIdx)) >= 0) {
                void var4_4;
                boolean slashRight;
                nextFromIdx = dotIdx - 1;
                if (dotIdx != 0 && path2.charAt(dotIdx - 1) != '/') continue;
                if (dotIdx + 1 == path2.length()) {
                    slashRight = false;
                } else {
                    if (path2.charAt(dotIdx + 1) != '/') continue;
                    slashRight = true;
                }
                if (var4_4 != false) {
                    path2 = path2.substring(0, dotIdx) + path2.substring(dotIdx + 2);
                    continue;
                }
                path2 = path2.substring(0, path2.length() - 1);
            }
            return path2;
        }

        private String resolveDotDotSteps(String path2, String name) throws MalformedTemplateNameException {
            int nextFromIdx = 0;
            int dotDotIdx;
            while ((dotDotIdx = path2.indexOf("..", nextFromIdx)) >= 0) {
                int previousSlashIdx;
                boolean slashRight;
                if (dotDotIdx == 0) {
                    throw TemplateNameFormat.newRootLeavingException(name);
                }
                if (path2.charAt(dotDotIdx - 1) != '/') {
                    nextFromIdx = dotDotIdx + 3;
                    continue;
                }
                if (dotDotIdx + 2 == path2.length()) {
                    slashRight = false;
                } else if (path2.charAt(dotDotIdx + 2) == '/') {
                    slashRight = true;
                } else {
                    nextFromIdx = dotDotIdx + 3;
                    continue;
                }
                boolean skippedStarStep = false;
                int searchSlashBacwardsFrom = dotDotIdx - 2;
                while (true) {
                    if (searchSlashBacwardsFrom == -1) {
                        throw TemplateNameFormat.newRootLeavingException(name);
                    }
                    previousSlashIdx = path2.lastIndexOf(47, searchSlashBacwardsFrom);
                    if (previousSlashIdx == -1) {
                        if (searchSlashBacwardsFrom != 0 || path2.charAt(0) != '*') break;
                        throw TemplateNameFormat.newRootLeavingException(name);
                    }
                    if (path2.charAt(previousSlashIdx + 1) != '*' || path2.charAt(previousSlashIdx + 2) != '/') break;
                    skippedStarStep = true;
                    searchSlashBacwardsFrom = previousSlashIdx - 1;
                }
                path2 = path2.substring(0, previousSlashIdx + 1) + (skippedStarStep ? "*/" : "") + path2.substring(dotDotIdx + (slashRight ? 3 : 2));
                nextFromIdx = previousSlashIdx + 1;
            }
            return path2;
        }

        private String removeRedundantStarSteps(String path2) {
            int supiciousIdx;
            while ((supiciousIdx = path2.indexOf("*/*")) != -1) {
                String prevName = path2;
                if (!(supiciousIdx != 0 && path2.charAt(supiciousIdx - 1) != '/' || supiciousIdx + 3 != path2.length() && path2.charAt(supiciousIdx + 3) != '/')) {
                    path2 = path2.substring(0, supiciousIdx) + path2.substring(supiciousIdx + 2);
                }
                if (prevName != path2) continue;
            }
            if (path2.startsWith("*")) {
                if (path2.length() == 1) {
                    path2 = "";
                } else if (path2.charAt(1) == '/') {
                    path2 = path2.substring(2);
                }
            }
            return path2;
        }

        public String toString() {
            return "TemplateNameFormat.DEFAULT_2_4_0";
        }
    }

    private static final class Default020300
    extends TemplateNameFormat {
        private Default020300() {
        }

        String toAbsoluteName(String baseName, String targetName) {
            if (baseName == null) {
                return targetName;
            }
            if (targetName.indexOf("://") > 0) {
                return targetName;
            }
            if (targetName.startsWith("/")) {
                int schemeSepIdx = baseName.indexOf("://");
                if (schemeSepIdx > 0) {
                    return baseName.substring(0, schemeSepIdx + 2) + targetName;
                }
                return targetName.substring(1);
            }
            if (!baseName.endsWith("/")) {
                baseName = baseName.substring(0, baseName.lastIndexOf("/") + 1);
            }
            return baseName + targetName;
        }

        String normalizeAbsoluteName(String name) throws MalformedTemplateNameException {
            TemplateNameFormat.checkNameHasNoNullCharacter(name);
            String path2 = name;
            while (true) {
                int parentDirPathLoc;
                if ((parentDirPathLoc = path2.indexOf("/../")) == 0) {
                    throw TemplateNameFormat.newRootLeavingException(name);
                }
                if (parentDirPathLoc == -1) {
                    if (!path2.startsWith("../")) break;
                    throw TemplateNameFormat.newRootLeavingException(name);
                }
                int previousSlashLoc = path2.lastIndexOf(47, parentDirPathLoc - 1);
                path2 = path2.substring(0, previousSlashLoc + 1) + path2.substring(parentDirPathLoc + "/../".length());
            }
            while (true) {
                int currentDirPathLoc;
                if ((currentDirPathLoc = path2.indexOf("/./")) == -1) {
                    if (!path2.startsWith("./")) break;
                    path2 = path2.substring("./".length());
                    break;
                }
                path2 = path2.substring(0, currentDirPathLoc) + path2.substring(currentDirPathLoc + "/./".length() - 1);
            }
            if (path2.length() > 1 && path2.charAt(0) == '/') {
                path2 = path2.substring(1);
            }
            return path2;
        }

        public String toString() {
            return "TemplateNameFormat.DEFAULT_2_3_0";
        }
    }
}

