/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.core;

import java.util.Arrays;
import java.util.Date;
import znaishaded.freemarker.core.Environment;
import znaishaded.freemarker.core.Expression;
import znaishaded.freemarker.core.FMParserTokenManager;
import znaishaded.freemarker.core.Macro;
import znaishaded.freemarker.core.ParameterRole;
import znaishaded.freemarker.core.ParseException;
import znaishaded.freemarker.core.Token;
import znaishaded.freemarker.core._CoreStringUtils;
import znaishaded.freemarker.core._MiscTemplateException;
import znaishaded.freemarker.template.Configuration;
import znaishaded.freemarker.template.SimpleDate;
import znaishaded.freemarker.template.SimpleScalar;
import znaishaded.freemarker.template.TemplateException;
import znaishaded.freemarker.template.TemplateHashModel;
import znaishaded.freemarker.template.TemplateModel;
import znaishaded.freemarker.template.TemplateModelException;
import znaishaded.freemarker.template._TemplateAPI;
import znaishaded.freemarker.template.utility.StringUtil;

final class BuiltinVariable
extends Expression {
    static final String TEMPLATE_NAME_CC = "templateName";
    static final String TEMPLATE_NAME = "template_name";
    static final String MAIN_TEMPLATE_NAME_CC = "mainTemplateName";
    static final String MAIN_TEMPLATE_NAME = "main_template_name";
    static final String CURRENT_TEMPLATE_NAME_CC = "currentTemplateName";
    static final String CURRENT_TEMPLATE_NAME = "current_template_name";
    static final String NAMESPACE = "namespace";
    static final String MAIN = "main";
    static final String GLOBALS = "globals";
    static final String LOCALS = "locals";
    static final String DATA_MODEL_CC = "dataModel";
    static final String DATA_MODEL = "data_model";
    static final String LANG = "lang";
    static final String LOCALE = "locale";
    static final String LOCALE_OBJECT_CC = "localeObject";
    static final String LOCALE_OBJECT = "locale_object";
    static final String CURRENT_NODE_CC = "currentNode";
    static final String CURRENT_NODE = "current_node";
    static final String NODE = "node";
    static final String PASS = "pass";
    static final String VARS = "vars";
    static final String VERSION = "version";
    static final String ERROR = "error";
    static final String OUTPUT_ENCODING_CC = "outputEncoding";
    static final String OUTPUT_ENCODING = "output_encoding";
    static final String URL_ESCAPING_CHARSET_CC = "urlEscapingCharset";
    static final String URL_ESCAPING_CHARSET = "url_escaping_charset";
    static final String NOW = "now";
    static final String[] SPEC_VAR_NAMES = new String[]{"currentNode", "currentTemplateName", "current_node", "current_template_name", "dataModel", "data_model", "error", "globals", "lang", "locale", "localeObject", "locale_object", "locals", "main", "mainTemplateName", "main_template_name", "namespace", "node", "now", "outputEncoding", "output_encoding", "pass", "templateName", "template_name", "urlEscapingCharset", "url_escaping_charset", "vars", "version"};
    private final String name;

    BuiltinVariable(Token nameTk, FMParserTokenManager tokenManager) throws ParseException {
        String name = nameTk.image;
        if (Arrays.binarySearch(SPEC_VAR_NAMES, name) < 0) {
            StringBuffer sb = new StringBuffer();
            sb.append("Unknown special variable name: ");
            sb.append(StringUtil.jQuote(name)).append(".");
            int namingConvention = tokenManager.namingConvention;
            int shownNamingConvention = namingConvention != 10 ? namingConvention : 11;
            sb.append(" The allowed special variable names are: ");
            boolean first = true;
            for (int i = 0; i < SPEC_VAR_NAMES.length; ++i) {
                String correctName = SPEC_VAR_NAMES[i];
                int correctNameNamingConvetion = _CoreStringUtils.getIdentifierNamingConvention(correctName);
                if (!(shownNamingConvention == 12 ? correctNameNamingConvetion != 11 : correctNameNamingConvetion != 12)) continue;
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(correctName);
            }
            throw new ParseException(sb.toString(), null, nameTk);
        }
        this.name = name.intern();
    }

    TemplateModel _eval(Environment env) throws TemplateException {
        if (this.name == NAMESPACE) {
            return env.getCurrentNamespace();
        }
        if (this.name == MAIN) {
            return env.getMainNamespace();
        }
        if (this.name == GLOBALS) {
            return env.getGlobalVariables();
        }
        if (this.name == LOCALS) {
            Macro.Context ctx = env.getCurrentMacroContext();
            return ctx == null ? null : ctx.getLocals();
        }
        if (this.name == DATA_MODEL || this.name == DATA_MODEL_CC) {
            return env.getDataModel();
        }
        if (this.name == VARS) {
            return new VarsHash(env);
        }
        if (this.name == LOCALE) {
            return new SimpleScalar(env.getLocale().toString());
        }
        if (this.name == LOCALE_OBJECT || this.name == LOCALE_OBJECT_CC) {
            return env.getObjectWrapper().wrap(env.getLocale());
        }
        if (this.name == LANG) {
            return new SimpleScalar(env.getLocale().getLanguage());
        }
        if (this.name == CURRENT_NODE || this.name == NODE || this.name == CURRENT_NODE_CC) {
            return env.getCurrentVisitorNode();
        }
        if (this.name == TEMPLATE_NAME || this.name == TEMPLATE_NAME_CC) {
            return env.getConfiguration().getIncompatibleImprovements().intValue() >= _TemplateAPI.VERSION_INT_2_3_23 ? new SimpleScalar(env.getTemplate230().getName()) : new SimpleScalar(env.getTemplate().getName());
        }
        if (this.name == MAIN_TEMPLATE_NAME || this.name == MAIN_TEMPLATE_NAME_CC) {
            return SimpleScalar.newInstanceOrNull(env.getMainTemplate().getName());
        }
        if (this.name == CURRENT_TEMPLATE_NAME || this.name == CURRENT_TEMPLATE_NAME_CC) {
            return SimpleScalar.newInstanceOrNull(env.getCurrentTemplate().getName());
        }
        if (this.name == PASS) {
            return Macro.DO_NOTHING_MACRO;
        }
        if (this.name == VERSION) {
            return new SimpleScalar(Configuration.getVersionNumber());
        }
        if (this.name == OUTPUT_ENCODING || this.name == OUTPUT_ENCODING_CC) {
            String s = env.getOutputEncoding();
            return SimpleScalar.newInstanceOrNull(s);
        }
        if (this.name == URL_ESCAPING_CHARSET || this.name == URL_ESCAPING_CHARSET_CC) {
            String s = env.getURLEscapingCharset();
            return SimpleScalar.newInstanceOrNull(s);
        }
        if (this.name == ERROR) {
            return new SimpleScalar(env.getCurrentRecoveredErrorMessage());
        }
        if (this.name == NOW) {
            return new SimpleDate(new Date(), 3);
        }
        throw new _MiscTemplateException((Expression)this, new Object[]{"Invalid built-in variable: ", this.name});
    }

    public String toString() {
        return "." + this.name;
    }

    public String getCanonicalForm() {
        return "." + this.name;
    }

    String getNodeTypeSymbol() {
        return this.getCanonicalForm();
    }

    boolean isLiteral() {
        return false;
    }

    protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        return this;
    }

    int getParameterCount() {
        return 0;
    }

    Object getParameterValue(int idx) {
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        throw new IndexOutOfBoundsException();
    }

    static class VarsHash
    implements TemplateHashModel {
        Environment env;

        VarsHash(Environment env) {
            this.env = env;
        }

        public TemplateModel get(String key) throws TemplateModelException {
            return this.env.getVariable(key);
        }

        public boolean isEmpty() {
            return false;
        }
    }
}

