/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.core;

import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import znaishaded.freemarker.core.BlockAssignment;
import znaishaded.freemarker.core.Environment;
import znaishaded.freemarker.core.Macro;
import znaishaded.freemarker.core.MixedContent;
import znaishaded.freemarker.core.ParseException;
import znaishaded.freemarker.core.TemplateObject;
import znaishaded.freemarker.core._ArrayEnumeration;
import znaishaded.freemarker.template.SimpleSequence;
import znaishaded.freemarker.template.TemplateException;
import znaishaded.freemarker.template.TemplateNodeModel;
import znaishaded.freemarker.template.TemplateSequenceModel;

public abstract class TemplateElement
extends TemplateObject
implements TreeNode {
    private static final int INITIAL_REGULATED_CHILD_BUFFER_CAPACITY = 6;
    private TemplateElement parent;
    private TemplateElement nestedBlock;
    private TemplateElement[] regulatedChildBuffer;
    private int regulatedChildCount;
    private int index;

    abstract void accept(Environment var1) throws TemplateException, IOException;

    public final String getDescription() {
        return this.dump(false);
    }

    public final String getCanonicalForm() {
        return this.dump(true);
    }

    boolean isShownInStackTrace() {
        return true;
    }

    abstract boolean isNestedBlockRepeater();

    protected abstract String dump(boolean var1);

    public TemplateNodeModel getParentNode() {
        return null;
    }

    public String getNodeNamespace() {
        return null;
    }

    public String getNodeType() {
        return "element";
    }

    public TemplateSequenceModel getChildNodes() {
        if (this.regulatedChildBuffer != null) {
            SimpleSequence seq = new SimpleSequence(this.regulatedChildCount);
            for (int i = 0; i < this.regulatedChildCount; ++i) {
                seq.add(this.regulatedChildBuffer[i]);
            }
            return seq;
        }
        SimpleSequence result = new SimpleSequence(1);
        if (this.nestedBlock != null) {
            result.add(this.nestedBlock);
        }
        return result;
    }

    public String getNodeName() {
        String classname = this.getClass().getName();
        int shortNameOffset = classname.lastIndexOf(46) + 1;
        return classname.substring(shortNameOffset);
    }

    public boolean isLeaf() {
        return this.nestedBlock == null && this.regulatedChildCount == 0;
    }

    public boolean getAllowsChildren() {
        return !this.isLeaf();
    }

    public int getIndex(TreeNode node) {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.getIndex(node);
        }
        if (this.nestedBlock != null) {
            if (node == this.nestedBlock) {
                return 0;
            }
        } else {
            for (int i = 0; i < this.regulatedChildCount; ++i) {
                if (!this.regulatedChildBuffer[i].equals(node)) continue;
                return i;
            }
        }
        return -1;
    }

    public int getChildCount() {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.getChildCount();
        }
        if (this.nestedBlock != null) {
            return 1;
        }
        return this.regulatedChildCount;
    }

    public Enumeration children() {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.children();
        }
        if (this.nestedBlock != null) {
            return Collections.enumeration(Collections.singletonList(this.nestedBlock));
        }
        if (this.regulatedChildBuffer != null) {
            return new _ArrayEnumeration(this.regulatedChildBuffer, this.regulatedChildCount);
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public TreeNode getChildAt(int index) {
        if (this.nestedBlock instanceof MixedContent) {
            return this.nestedBlock.getChildAt(index);
        }
        if (this.nestedBlock != null) {
            if (index == 0) {
                return this.nestedBlock;
            }
            throw new ArrayIndexOutOfBoundsException("invalid index");
        }
        if (this.regulatedChildCount != 0) {
            try {
                return this.regulatedChildBuffer[index];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.regulatedChildCount);
            }
        }
        throw new ArrayIndexOutOfBoundsException("Template element has no children");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setChildAt(int index, TemplateElement element) {
        if (this.nestedBlock instanceof MixedContent) {
            this.nestedBlock.setChildAt(index, element);
            return;
        } else if (this.nestedBlock != null) {
            if (index != 0) throw new IndexOutOfBoundsException("invalid index");
            this.nestedBlock = element;
            element.index = 0;
            element.parent = this;
            return;
        } else {
            if (this.regulatedChildBuffer == null) throw new IndexOutOfBoundsException("element has no children");
            this.regulatedChildBuffer[index] = element;
            element.index = index;
            element.parent = this;
        }
    }

    public TreeNode getParent() {
        return this.parent;
    }

    final void setRegulatedChildBufferCapacity(int capacity) {
        int ln = this.regulatedChildCount;
        TemplateElement[] newRegulatedChildBuffer = new TemplateElement[capacity];
        for (int i = 0; i < ln; ++i) {
            newRegulatedChildBuffer[i] = this.regulatedChildBuffer[i];
        }
        this.regulatedChildBuffer = newRegulatedChildBuffer;
    }

    final void addRegulatedChild(TemplateElement nestedElement) {
        this.addRegulatedChild(this.regulatedChildCount, nestedElement);
    }

    final void addRegulatedChild(int index, TemplateElement nestedElement) {
        int lRegulatedChildCount = this.regulatedChildCount;
        TemplateElement[] lRegulatedChildBuffer = this.regulatedChildBuffer;
        if (lRegulatedChildBuffer == null) {
            this.regulatedChildBuffer = lRegulatedChildBuffer = new TemplateElement[6];
        } else if (lRegulatedChildCount == lRegulatedChildBuffer.length) {
            this.setRegulatedChildBufferCapacity(lRegulatedChildCount != 0 ? lRegulatedChildCount * 2 : 1);
            lRegulatedChildBuffer = this.regulatedChildBuffer;
        }
        for (int i = lRegulatedChildCount; i > index; --i) {
            TemplateElement movedElement = lRegulatedChildBuffer[i - 1];
            movedElement.index = i;
            lRegulatedChildBuffer[i] = movedElement;
        }
        nestedElement.index = index;
        nestedElement.parent = this;
        lRegulatedChildBuffer[index] = nestedElement;
        this.regulatedChildCount = lRegulatedChildCount + 1;
    }

    final int getRegulatedChildCount() {
        return this.regulatedChildCount;
    }

    final TemplateElement getRegulatedChild(int index) {
        return this.regulatedChildBuffer[index];
    }

    final int getIndex() {
        return this.index;
    }

    final TemplateElement getParentElement() {
        return this.parent;
    }

    final TemplateElement getNestedBlock() {
        return this.nestedBlock;
    }

    final void setNestedBlock(TemplateElement nestedBlock) {
        if (nestedBlock != null) {
            nestedBlock.parent = this;
            nestedBlock.index = 0;
        }
        this.nestedBlock = nestedBlock;
    }

    final void setFieldsForRootElement() {
        this.index = 0;
        this.parent = null;
    }

    TemplateElement postParseCleanup(boolean stripWhitespace) throws ParseException {
        int regulatedChildCount = this.regulatedChildCount;
        if (regulatedChildCount != 0) {
            TemplateElement te;
            int i = 0;
            while (i < regulatedChildCount) {
                te = this.regulatedChildBuffer[i];
                this.regulatedChildBuffer[i] = te = te.postParseCleanup(stripWhitespace);
                te.parent = this;
                te.index = i++;
            }
            if (stripWhitespace) {
                for (i = 0; i < regulatedChildCount; ++i) {
                    te = this.regulatedChildBuffer[i];
                    if (!te.isIgnorable()) continue;
                    --regulatedChildCount;
                    int j = i;
                    while (j < regulatedChildCount) {
                        TemplateElement te2;
                        this.regulatedChildBuffer[j] = te2 = this.regulatedChildBuffer[j + 1];
                        te2.index = j++;
                    }
                    this.regulatedChildBuffer[regulatedChildCount] = null;
                    this.regulatedChildCount = regulatedChildCount;
                    --i;
                }
            }
            if (regulatedChildCount < this.regulatedChildBuffer.length && regulatedChildCount <= this.regulatedChildBuffer.length * 3 / 4) {
                TemplateElement[] trimmedregulatedChildBuffer = new TemplateElement[regulatedChildCount];
                for (int i2 = 0; i2 < regulatedChildCount; ++i2) {
                    trimmedregulatedChildBuffer[i2] = this.regulatedChildBuffer[i2];
                }
                this.regulatedChildBuffer = trimmedregulatedChildBuffer;
            }
        } else if (this.nestedBlock != null) {
            this.nestedBlock = this.nestedBlock.postParseCleanup(stripWhitespace);
            if (this.nestedBlock.isIgnorable()) {
                this.nestedBlock = null;
            } else {
                this.nestedBlock.parent = this;
            }
        }
        return this;
    }

    boolean isIgnorable() {
        return false;
    }

    TemplateElement prevTerminalNode() {
        TemplateElement prev = this.previousSibling();
        if (prev != null) {
            return prev.getLastLeaf();
        }
        if (this.parent != null) {
            return this.parent.prevTerminalNode();
        }
        return null;
    }

    TemplateElement nextTerminalNode() {
        TemplateElement next = this.nextSibling();
        if (next != null) {
            return next.getFirstLeaf();
        }
        if (this.parent != null) {
            return this.parent.nextTerminalNode();
        }
        return null;
    }

    TemplateElement previousSibling() {
        if (this.parent == null) {
            return null;
        }
        return this.index > 0 ? this.parent.regulatedChildBuffer[this.index - 1] : null;
    }

    TemplateElement nextSibling() {
        if (this.parent == null) {
            return null;
        }
        return this.index + 1 < this.parent.regulatedChildCount ? this.parent.regulatedChildBuffer[this.index + 1] : null;
    }

    private TemplateElement getFirstChild() {
        if (this.nestedBlock != null) {
            return this.nestedBlock;
        }
        if (this.regulatedChildCount == 0) {
            return null;
        }
        return this.regulatedChildBuffer[0];
    }

    private TemplateElement getLastChild() {
        if (this.nestedBlock != null) {
            return this.nestedBlock;
        }
        int regulatedChildCount = this.regulatedChildCount;
        if (regulatedChildCount == 0) {
            return null;
        }
        return this.regulatedChildBuffer[regulatedChildCount - 1];
    }

    private TemplateElement getFirstLeaf() {
        TemplateElement te = this;
        while (!(te.isLeaf() || te instanceof Macro || te instanceof BlockAssignment)) {
            te = te.getFirstChild();
        }
        return te;
    }

    private TemplateElement getLastLeaf() {
        TemplateElement te = this;
        while (!(te.isLeaf() || te instanceof Macro || te instanceof BlockAssignment)) {
            te = te.getLastChild();
        }
        return te;
    }

    boolean isOutputCacheable() {
        return false;
    }

    boolean heedsOpeningWhitespace() {
        return false;
    }

    boolean heedsTrailingWhitespace() {
        return false;
    }
}

