/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.ext.beans;

import java.beans.IndexedPropertyDescriptor;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import znaishaded.freemarker.core.CollectionAndSequence;
import znaishaded.freemarker.core._DelayedFTLTypeDescription;
import znaishaded.freemarker.core._DelayedJQuote;
import znaishaded.freemarker.core._TemplateModelException;
import znaishaded.freemarker.ext.beans.BeansWrapper;
import znaishaded.freemarker.ext.beans.ClassIntrospector;
import znaishaded.freemarker.ext.beans.InvalidPropertyException;
import znaishaded.freemarker.ext.beans.OverloadedMethods;
import znaishaded.freemarker.ext.beans.OverloadedMethodsModel;
import znaishaded.freemarker.ext.beans.SimpleMethodModel;
import znaishaded.freemarker.ext.util.ModelFactory;
import znaishaded.freemarker.ext.util.WrapperTemplateModel;
import znaishaded.freemarker.log.Logger;
import znaishaded.freemarker.template.AdapterTemplateModel;
import znaishaded.freemarker.template.ObjectWrapper;
import znaishaded.freemarker.template.SimpleScalar;
import znaishaded.freemarker.template.SimpleSequence;
import znaishaded.freemarker.template.TemplateCollectionModel;
import znaishaded.freemarker.template.TemplateHashModelEx;
import znaishaded.freemarker.template.TemplateModel;
import znaishaded.freemarker.template.TemplateModelException;
import znaishaded.freemarker.template.TemplateModelIterator;
import znaishaded.freemarker.template.TemplateModelWithAPISupport;
import znaishaded.freemarker.template.TemplateScalarModel;
import znaishaded.freemarker.template.utility.StringUtil;

public class BeanModel
implements TemplateHashModelEx,
AdapterTemplateModel,
WrapperTemplateModel,
TemplateModelWithAPISupport {
    private static final Logger LOG = Logger.getLogger("znaishaded.freemarker.beans");
    protected final Object object;
    protected final BeansWrapper wrapper;
    static final TemplateModel UNKNOWN = new SimpleScalar("UNKNOWN");
    static final ModelFactory FACTORY = new ModelFactory(){

        public TemplateModel create(Object object, ObjectWrapper wrapper) {
            return new BeanModel(object, (BeansWrapper)wrapper);
        }
    };
    private HashMap memberMap;

    public BeanModel(Object object, BeansWrapper wrapper) {
        this(object, wrapper, true);
    }

    BeanModel(Object object, BeansWrapper wrapper, boolean inrospectNow) {
        this.object = object;
        this.wrapper = wrapper;
        if (inrospectNow && object != null) {
            wrapper.getClassIntrospector().get(object.getClass());
        }
    }

    public TemplateModel get(String key) throws TemplateModelException {
        Class<?> clazz = this.object.getClass();
        Map classInfo = this.wrapper.getClassIntrospector().get(clazz);
        TemplateModel retval = null;
        try {
            if (this.wrapper.isMethodsShadowItems()) {
                Object fd = classInfo.get(key);
                retval = fd != null ? this.invokeThroughDescriptor(fd, classInfo) : this.invokeGenericGet(classInfo, clazz, key);
            } else {
                TemplateModel nullModel;
                TemplateModel model = this.invokeGenericGet(classInfo, clazz, key);
                if (model != (nullModel = this.wrapper.wrap(null)) && model != UNKNOWN) {
                    return model;
                }
                Object fd = classInfo.get(key);
                if (fd != null && (retval = this.invokeThroughDescriptor(fd, classInfo)) == UNKNOWN && model == nullModel) {
                    retval = nullModel;
                }
            }
            if (retval == UNKNOWN) {
                if (this.wrapper.isStrict()) {
                    throw new InvalidPropertyException("No such bean property: " + key);
                }
                if (LOG.isDebugEnabled()) {
                    this.logNoSuchKey(key, classInfo);
                }
                retval = this.wrapper.wrap(null);
            }
            return retval;
        }
        catch (TemplateModelException e) {
            throw e;
        }
        catch (Exception e) {
            throw new _TemplateModelException((Throwable)e, new Object[]{"An error has occurred when reading existing sub-variable ", new _DelayedJQuote(key), "; see cause exception! The type of the containing value was: ", new _DelayedFTLTypeDescription(this)});
        }
    }

    private void logNoSuchKey(String key, Map keyMap) {
        LOG.debug("Key " + StringUtil.jQuoteNoXSS(key) + " was not found on instance of " + this.object.getClass().getName() + ". Introspection information for " + "the class is: " + keyMap);
    }

    protected boolean hasPlainGetMethod() {
        return this.wrapper.getClassIntrospector().get(this.object.getClass()).get(ClassIntrospector.GENERIC_GET_KEY) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TemplateModel invokeThroughDescriptor(Object desc, Map classInfo) throws IllegalAccessException, InvocationTargetException, TemplateModelException {
        TemplateModel member;
        BeanModel beanModel = this;
        synchronized (beanModel) {
            member = this.memberMap != null ? (TemplateModel)this.memberMap.get(desc) : null;
        }
        if (member != null) {
            return member;
        }
        TemplateModel retval = UNKNOWN;
        if (desc instanceof IndexedPropertyDescriptor) {
            Method readMethod = ((IndexedPropertyDescriptor)desc).getIndexedReadMethod();
            retval = member = new SimpleMethodModel(this.object, readMethod, ClassIntrospector.getArgTypes(classInfo, readMethod), this.wrapper);
        } else if (desc instanceof PropertyDescriptor) {
            PropertyDescriptor pd = (PropertyDescriptor)desc;
            retval = this.wrapper.invokeMethod(this.object, pd.getReadMethod(), null);
        } else if (desc instanceof Field) {
            retval = this.wrapper.wrap(((Field)desc).get(this.object));
        } else if (desc instanceof Method) {
            Method method = (Method)desc;
            retval = member = new SimpleMethodModel(this.object, method, ClassIntrospector.getArgTypes(classInfo, method), this.wrapper);
        } else if (desc instanceof OverloadedMethods) {
            retval = member = new OverloadedMethodsModel(this.object, (OverloadedMethods)desc, this.wrapper);
        }
        if (member != null) {
            BeanModel beanModel2 = this;
            synchronized (beanModel2) {
                if (this.memberMap == null) {
                    this.memberMap = new HashMap();
                }
                this.memberMap.put(desc, member);
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearMemberCache() {
        BeanModel beanModel = this;
        synchronized (beanModel) {
            this.memberMap = null;
        }
    }

    protected TemplateModel invokeGenericGet(Map keyMap, Class clazz, String key) throws IllegalAccessException, InvocationTargetException, TemplateModelException {
        Method genericGet = (Method)keyMap.get(ClassIntrospector.GENERIC_GET_KEY);
        if (genericGet == null) {
            return UNKNOWN;
        }
        return this.wrapper.invokeMethod(this.object, genericGet, new Object[]{key});
    }

    protected TemplateModel wrap(Object obj) throws TemplateModelException {
        return this.wrapper.getOuterIdentity().wrap(obj);
    }

    protected Object unwrap(TemplateModel model) throws TemplateModelException {
        return this.wrapper.unwrap(model);
    }

    public boolean isEmpty() {
        if (this.object instanceof String) {
            return ((String)this.object).length() == 0;
        }
        if (this.object instanceof Collection) {
            return ((Collection)this.object).isEmpty();
        }
        if (this.object instanceof Map) {
            return ((Map)this.object).isEmpty();
        }
        return this.object == null || Boolean.FALSE.equals(this.object);
    }

    public Object getAdaptedObject(Class hint) {
        return this.object;
    }

    public Object getWrappedObject() {
        return this.object;
    }

    public int size() {
        return this.wrapper.getClassIntrospector().keyCount(this.object.getClass());
    }

    public TemplateCollectionModel keys() {
        return new CollectionAndSequence(new SimpleSequence(this.keySet(), (ObjectWrapper)this.wrapper));
    }

    public TemplateCollectionModel values() throws TemplateModelException {
        ArrayList<TemplateModel> values = new ArrayList<TemplateModel>(this.size());
        TemplateModelIterator it = this.keys().iterator();
        while (it.hasNext()) {
            String key = ((TemplateScalarModel)it.next()).getAsString();
            values.add(this.get(key));
        }
        return new CollectionAndSequence(new SimpleSequence(values, (ObjectWrapper)this.wrapper));
    }

    String getAsClassicCompatibleString() {
        return this.object == null ? "null" : this.object.toString();
    }

    public String toString() {
        return this.object.toString();
    }

    protected Set keySet() {
        return this.wrapper.getClassIntrospector().keySet(this.object.getClass());
    }

    public TemplateModel getAPI() throws TemplateModelException {
        return this.wrapper.wrapAsAPI(this.object);
    }
}

