/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.ext.dom;

import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import znaishaded.freemarker.core.Environment;
import znaishaded.freemarker.ext.dom.ElementModel;
import znaishaded.freemarker.ext.dom.NodeListModel;
import znaishaded.freemarker.ext.dom.NodeModel;
import znaishaded.freemarker.template.TemplateHashModel;
import znaishaded.freemarker.template.TemplateModel;
import znaishaded.freemarker.template.TemplateModelException;
import znaishaded.freemarker.template.utility.StringUtil;

class DocumentModel
extends NodeModel
implements TemplateHashModel {
    private ElementModel rootElement;

    DocumentModel(Document doc) {
        super(doc);
    }

    public String getNodeName() {
        return "@document";
    }

    public TemplateModel get(String key) throws TemplateModelException {
        if (key.equals("*")) {
            return this.getRootElement();
        }
        if (key.equals("**")) {
            NodeList nl = ((Document)this.node).getElementsByTagName("*");
            return new NodeListModel(nl, (NodeModel)this);
        }
        if (StringUtil.isXMLID(key)) {
            ElementModel em = (ElementModel)NodeModel.wrap(((Document)this.node).getDocumentElement());
            if (em.matchesName(key, Environment.getCurrentEnvironment())) {
                return em;
            }
            return new NodeListModel(this);
        }
        return super.get(key);
    }

    ElementModel getRootElement() {
        if (this.rootElement == null) {
            this.rootElement = (ElementModel)DocumentModel.wrap(((Document)this.node).getDocumentElement());
        }
        return this.rootElement;
    }

    public boolean isEmpty() {
        return false;
    }
}

