/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.ext.jsp;

import java.lang.reflect.Method;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import znaishaded.freemarker.template.utility.ClassUtil;
import znaishaded.freemarker.template.utility.StringUtil;

final class TaglibMethodUtil {
    private static final Pattern FUNCTION_SIGNATURE_PATTERN = Pattern.compile("^([\\w\\.]+(\\s*\\[\\s*\\])?)\\s+([\\w]+)\\s*\\((.*)\\)$");
    private static final Pattern FUNCTION_PARAMETER_PATTERN = Pattern.compile("^([\\w\\.]+)(\\s*\\[\\s*\\])?$");
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class array$S;
    static /* synthetic */ Class array$I;
    static /* synthetic */ Class array$J;
    static /* synthetic */ Class array$F;
    static /* synthetic */ Class array$D;
    static /* synthetic */ Class array$Z;
    static /* synthetic */ Class array$C;

    private TaglibMethodUtil() {
    }

    public static Method getMethodByFunctionSignature(Class clazz, String signature) throws SecurityException, NoSuchMethodException, ClassNotFoundException {
        Matcher m1 = FUNCTION_SIGNATURE_PATTERN.matcher(signature);
        if (!m1.matches()) {
            throw new IllegalArgumentException("Invalid function signature.");
        }
        String methodName = m1.group(3);
        String params = m1.group(4).trim();
        Class[] paramTypes = null;
        if ("".equals(params)) {
            paramTypes = new Class[]{};
        } else {
            String[] paramsArray = StringUtil.split(params, ',');
            paramTypes = new Class[paramsArray.length];
            String token = null;
            String paramType = null;
            boolean isPrimitive = false;
            boolean isArrayType = false;
            Matcher m2 = null;
            for (int i = 0; i < paramsArray.length; ++i) {
                token = paramsArray[i].trim();
                m2 = FUNCTION_PARAMETER_PATTERN.matcher(token);
                if (!m2.matches()) {
                    throw new IllegalArgumentException("Invalid argument signature: '" + token + "'.");
                }
                paramType = m2.group(1);
                isPrimitive = paramType.indexOf(46) == -1;
                boolean bl = isArrayType = m2.group(2) != null;
                if (isPrimitive) {
                    if ("byte".equals(paramType)) {
                        paramTypes[i] = isArrayType ? (array$B == null ? TaglibMethodUtil.class$("[B") : array$B) : Byte.TYPE;
                        continue;
                    }
                    if ("short".equals(paramType)) {
                        paramTypes[i] = isArrayType ? (array$S == null ? TaglibMethodUtil.class$("[S") : array$S) : Short.TYPE;
                        continue;
                    }
                    if ("int".equals(paramType)) {
                        paramTypes[i] = isArrayType ? (array$I == null ? TaglibMethodUtil.class$("[I") : array$I) : Integer.TYPE;
                        continue;
                    }
                    if ("long".equals(paramType)) {
                        paramTypes[i] = isArrayType ? (array$J == null ? TaglibMethodUtil.class$("[J") : array$J) : Long.TYPE;
                        continue;
                    }
                    if ("float".equals(paramType)) {
                        paramTypes[i] = isArrayType ? (array$F == null ? TaglibMethodUtil.class$("[F") : array$F) : Float.TYPE;
                        continue;
                    }
                    if ("double".equals(paramType)) {
                        paramTypes[i] = isArrayType ? (array$D == null ? TaglibMethodUtil.class$("[D") : array$D) : Double.TYPE;
                        continue;
                    }
                    if ("boolean".equals(paramType)) {
                        paramTypes[i] = isArrayType ? (array$Z == null ? TaglibMethodUtil.class$("[Z") : array$Z) : Boolean.TYPE;
                        continue;
                    }
                    if ("char".equals(paramType)) {
                        paramTypes[i] = isArrayType ? (array$C == null ? TaglibMethodUtil.class$("[C") : array$C) : Character.TYPE;
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid primitive type: '" + paramType + "'.");
                }
                paramTypes[i] = isArrayType ? ClassUtil.forName("[L" + paramType + ";") : ClassUtil.forName(paramType);
            }
        }
        return clazz.getMethod(methodName, paramTypes);
    }
}

