/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.parsetools.impl;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import znaishaded.com.fasterxml.jackson.core.JsonFactory;
import znaishaded.com.fasterxml.jackson.core.JsonToken;
import znaishaded.com.fasterxml.jackson.core.json.async.NonBlockingJsonParser;
import znaishaded.com.fasterxml.jackson.databind.util.TokenBuffer;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.VertxException;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.json.DecodeException;
import znaishaded.io.vertx.core.json.Json;
import znaishaded.io.vertx.core.json.JsonArray;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.core.parsetools.JsonEvent;
import znaishaded.io.vertx.core.parsetools.JsonEventType;
import znaishaded.io.vertx.core.parsetools.JsonParser;
import znaishaded.io.vertx.core.parsetools.impl.JsonEventImpl;
import znaishaded.io.vertx.core.streams.ReadStream;

public class JsonParserImpl
implements JsonParser {
    private NonBlockingJsonParser parser;
    private Handler<JsonEvent> eventHandler;
    private Handler<JsonToken> tokenHandler = this::handleToken;
    private BufferingHandler arrayHandler;
    private BufferingHandler objectHandler;
    private Handler<Throwable> exceptionHandler;
    private String currentField;
    private Handler<Void> endHandler;
    private final ReadStream<Buffer> stream;

    public JsonParserImpl(ReadStream<Buffer> stream) {
        this.stream = stream;
        JsonFactory factory = new JsonFactory();
        try {
            this.parser = (NonBlockingJsonParser)factory.createNonBlockingByteArrayParser();
        }
        catch (Exception e) {
            throw new VertxException(e);
        }
    }

    @Override
    public JsonParser pause() {
        if (this.stream != null) {
            this.stream.pause();
        }
        return this;
    }

    @Override
    public JsonParser resume() {
        if (this.stream != null) {
            this.stream.resume();
        }
        return this;
    }

    @Override
    public JsonParser endHandler(Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }

    @Override
    public JsonParser handler(Handler<JsonEvent> handler) {
        this.eventHandler = handler;
        if (this.stream != null) {
            if (handler != null) {
                this.stream.endHandler((Void v) -> this.end());
                this.stream.exceptionHandler(err -> {
                    if (this.exceptionHandler != null) {
                        this.exceptionHandler.handle((Throwable)err);
                    }
                });
                this.stream.handler(this);
            } else {
                this.stream.handler(null);
                this.stream.endHandler(null);
                this.stream.exceptionHandler((Handler)null);
            }
        }
        return this;
    }

    private void handleToken(JsonToken token) {
        try {
            switch (token) {
                case START_OBJECT: {
                    BufferingHandler handler = this.objectHandler;
                    if (handler != null) {
                        this.tokenHandler = handler;
                        handler.handle(token);
                        break;
                    }
                    Handler<JsonEvent> h = this.eventHandler;
                    if (h != null) {
                        h.handle(new JsonEventImpl(JsonEventType.START_OBJECT, this.currentField, null));
                    }
                    break;
                }
                case START_ARRAY: {
                    BufferingHandler handler = this.arrayHandler;
                    if (handler != null) {
                        this.tokenHandler = handler;
                        handler.handle(token);
                        break;
                    }
                    Handler<JsonEvent> h = this.eventHandler;
                    if (h != null) {
                        h.handle(new JsonEventImpl(JsonEventType.START_ARRAY, this.currentField, null));
                    }
                    break;
                }
                case FIELD_NAME: {
                    this.currentField = this.parser.getCurrentName();
                    break;
                }
                case VALUE_STRING: {
                    Handler<JsonEvent> handler = this.eventHandler;
                    if (handler != null) {
                        handler.handle(new JsonEventImpl(JsonEventType.VALUE, this.currentField, this.parser.getText()));
                    }
                    this.currentField = null;
                    break;
                }
                case VALUE_TRUE: {
                    Handler<JsonEvent> handler = this.eventHandler;
                    if (handler != null) {
                        handler.handle(new JsonEventImpl(JsonEventType.VALUE, this.currentField, Boolean.TRUE));
                    }
                    break;
                }
                case VALUE_FALSE: {
                    Handler<JsonEvent> handler = this.eventHandler;
                    if (handler != null) {
                        handler.handle(new JsonEventImpl(JsonEventType.VALUE, this.currentField, Boolean.FALSE));
                    }
                    break;
                }
                case VALUE_NULL: {
                    Handler<JsonEvent> handler = this.eventHandler;
                    if (handler != null) {
                        handler.handle(new JsonEventImpl(JsonEventType.VALUE, this.currentField, null));
                    }
                    break;
                }
                case VALUE_NUMBER_INT: {
                    Handler<JsonEvent> handler = this.eventHandler;
                    if (handler != null) {
                        handler.handle(new JsonEventImpl(JsonEventType.VALUE, this.currentField, this.parser.getLongValue()));
                    }
                    break;
                }
                case VALUE_NUMBER_FLOAT: {
                    Handler<JsonEvent> handler = this.eventHandler;
                    if (handler != null) {
                        handler.handle(new JsonEventImpl(JsonEventType.VALUE, this.currentField, this.parser.getDoubleValue()));
                    }
                    break;
                }
                case END_OBJECT: {
                    Handler<JsonEvent> handler = this.eventHandler;
                    if (handler != null) {
                        handler.handle(new JsonEventImpl(JsonEventType.END_OBJECT, null, null));
                    }
                    break;
                }
                case END_ARRAY: {
                    Handler<JsonEvent> handler = this.eventHandler;
                    if (handler != null) {
                        handler.handle(new JsonEventImpl(JsonEventType.END_ARRAY, null, null));
                    }
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Token " + (Object)((Object)token) + " not implemented");
                }
            }
        }
        catch (IOException e) {
            throw new DecodeException(e.getMessage());
        }
    }

    @Override
    public void handle(Buffer event) {
        this.handle(event.getBytes());
    }

    @Override
    public void end() {
        this.handle((byte[])null);
    }

    @Override
    private void handle(byte[] bytes) {
        if (this.parser == null) {
            throw new IllegalStateException("Parsing already done");
        }
        try {
            JsonToken token;
            if (bytes != null) {
                this.parser.feedInput(bytes, 0, bytes.length);
            } else {
                this.parser.endOfInput();
            }
            while ((token = this.parser.nextToken()) != null && token != JsonToken.NOT_AVAILABLE) {
                this.tokenHandler.handle(token);
            }
            if (bytes == null) {
                this.parser = null;
                if (this.endHandler != null) {
                    this.endHandler.handle(null);
                }
            }
        }
        catch (IOException e) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(e);
            }
            throw new DecodeException(e.getMessage());
        }
        catch (Exception e) {
            if (this.exceptionHandler != null) {
                this.exceptionHandler.handle(e);
            }
            throw e;
        }
    }

    @Override
    public JsonParser objectEventMode() {
        if (this.objectHandler != null) {
            this.objectHandler = null;
            this.tokenHandler = this::handleToken;
        }
        return this;
    }

    @Override
    public JsonParser objectValueMode() {
        if (this.objectHandler == null) {
            BufferingHandler handler = new BufferingHandler();
            handler.handler = buffer -> {
                if (this.eventHandler != null) {
                    this.eventHandler.handle(new JsonEventImpl(JsonEventType.VALUE, this.currentField, new JsonObject(handler.convert(Map.class)), handler.buffer));
                }
            };
            this.objectHandler = handler;
        }
        return this;
    }

    @Override
    public JsonParser arrayEventMode() {
        if (this.arrayHandler != null) {
            this.arrayHandler = null;
            this.tokenHandler = this::handleToken;
        }
        return this;
    }

    @Override
    public JsonParser arrayValueMode() {
        if (this.arrayHandler == null) {
            BufferingHandler handler = new BufferingHandler();
            handler.handler = buffer -> {
                if (this.eventHandler != null) {
                    this.eventHandler.handle(new JsonEventImpl(JsonEventType.VALUE, this.currentField, new JsonArray(handler.convert(List.class)), handler.buffer));
                }
            };
            this.arrayHandler = handler;
        }
        return this;
    }

    @Override
    public JsonParser write(Buffer buffer) {
        this.handle(buffer);
        return this;
    }

    @Override
    public JsonParser exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    private class BufferingHandler
    implements Handler<JsonToken> {
        Handler<Void> handler;
        int depth;
        TokenBuffer buffer;

        private BufferingHandler() {
        }

        @Override
        public void handle(JsonToken event) {
            try {
                switch (event) {
                    case START_OBJECT: 
                    case START_ARRAY: {
                        if (this.depth++ == 0) {
                            this.buffer = new TokenBuffer(Json.mapper, false);
                        }
                        if (event == JsonToken.START_OBJECT) {
                            this.buffer.writeStartObject();
                            break;
                        }
                        this.buffer.writeStartArray();
                        break;
                    }
                    case FIELD_NAME: {
                        this.buffer.writeFieldName(JsonParserImpl.this.parser.getCurrentName());
                        break;
                    }
                    case VALUE_NUMBER_INT: {
                        this.buffer.writeNumber(JsonParserImpl.this.parser.getLongValue());
                        break;
                    }
                    case VALUE_NUMBER_FLOAT: {
                        this.buffer.writeNumber(JsonParserImpl.this.parser.getDoubleValue());
                        break;
                    }
                    case VALUE_STRING: {
                        this.buffer.writeString(JsonParserImpl.this.parser.getText());
                        break;
                    }
                    case VALUE_TRUE: {
                        this.buffer.writeBoolean(true);
                        break;
                    }
                    case VALUE_FALSE: {
                        this.buffer.writeBoolean(false);
                        break;
                    }
                    case VALUE_NULL: {
                        this.buffer.writeNull();
                        break;
                    }
                    case END_OBJECT: 
                    case END_ARRAY: {
                        if (event == JsonToken.END_OBJECT) {
                            this.buffer.writeEndObject();
                        } else {
                            this.buffer.writeEndArray();
                        }
                        if (--this.depth == 0) {
                            JsonParserImpl.this.tokenHandler = x$0 -> JsonParserImpl.this.handleToken(x$0);
                            this.buffer.flush();
                            this.handler.handle(null);
                        }
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Not implemented " + (Object)((Object)event));
                    }
                }
            }
            catch (IOException e) {
                throw new VertxException(e);
            }
        }

        <T> T convert(Class<T> type) {
            try {
                return Json.mapper.readValue(this.buffer.asParser(), type);
            }
            catch (Exception e) {
                throw new DecodeException(e.getMessage());
            }
        }
    }
}

